/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import javax.microedition.lcdui.Graphics;
import ntr.ttme.DoublePolygon;
import ntr.ttme.IntPolygon;
import ntr.ttme.Polyline;

public final class BezierCurveRenderer {
    public static final int DEFAULT_CASTELJAU_RECURSION_DEPTH = 5;
    int recursionDepth;
    IntPolygon points;
    DoublePolygon worldPoints;

    public BezierCurveRenderer() {
        this.recursionDepth = 5;
        this.points = new IntPolygon();
        this.worldPoints = new DoublePolygon();
    }

    public BezierCurveRenderer(int n) {
        this.recursionDepth = n;
        this.points = new IntPolygon();
        this.worldPoints = new DoublePolygon();
    }

    public int getRecursionDepth() {
        return this.recursionDepth;
    }

    public void renderBezier(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.calculateBezier(n, n2, n3, n4, n5, n6, n7, n8);
        graphics.setColor(n9);
        Polyline.draw(graphics, this.points.xpoints, this.points.ypoints, this.points.npoints);
    }

    public void calculateBezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.points.npoints = 0;
        this.points.addPoint(n, n2);
        this.casteljauBezierSubDivision(n, n2, n3, n4, n5, n6, n7, n8, this.recursionDepth);
    }

    private void casteljauBezierSubDivision(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n9 == 0) {
            this.points.addPoint(n7, n8);
        } else {
            int n10 = (n + n3) / 2;
            int n11 = (n2 + n4) / 2;
            int n12 = (n3 + n5) / 2;
            int n13 = (n4 + n6) / 2;
            int n14 = (n5 + n7) / 2;
            int n15 = (n6 + n8) / 2;
            int n16 = (n10 + n12) / 2;
            int n17 = (n11 + n13) / 2;
            int n18 = (n12 + n14) / 2;
            int n19 = (n13 + n15) / 2;
            int n20 = (n16 + n18) / 2;
            int n21 = (n17 + n19) / 2;
            this.casteljauBezierSubDivision(n, n2, n10, n11, n16, n17, n20, n21, n9 - 1);
            this.casteljauBezierSubDivision(n20, n21, n18, n19, n14, n15, n7, n8, n9 - 1);
        }
    }

    public void worldCalculateBezier(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.worldPoints.clear();
        this.worldPoints.addPoint(d, d2);
        this.worldCasteljauBezierSubDivision(d, d2, d3, d4, d5, d6, d7, d8, this.recursionDepth);
    }

    private void worldCasteljauBezierSubDivision(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n) {
        if (n == 0) {
            this.worldPoints.addPoint(d7, d8);
        } else {
            double d9 = (d + d3) / 2.0;
            double d10 = (d2 + d4) / 2.0;
            double d11 = (d3 + d5) / 2.0;
            double d12 = (d4 + d6) / 2.0;
            double d13 = (d5 + d7) / 2.0;
            double d14 = (d6 + d8) / 2.0;
            double d15 = (d9 + d11) / 2.0;
            double d16 = (d10 + d12) / 2.0;
            double d17 = (d11 + d13) / 2.0;
            double d18 = (d12 + d14) / 2.0;
            double d19 = (d15 + d17) / 2.0;
            double d20 = (d16 + d18) / 2.0;
            this.worldCasteljauBezierSubDivision(d, d2, d9, d10, d15, d16, d19, d20, n - 1);
            this.worldCasteljauBezierSubDivision(d19, d20, d17, d18, d13, d14, d7, d8, n - 1);
        }
    }
}

