/*
 * Decompiled with CFR 0.152.
 */
package drivehub.util;

public class Base64 {
    private static final char[] Base64Map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char Base64Pad = '=';

    private static int _indexOf(char c) {
        for (int i = 0; i < Base64Map.length; ++i) {
            if (c != Base64Map[i]) continue;
            return i;
        }
        return 0;
    }

    public static String encode(String string) {
        return string != null ? Base64.encode(string.getBytes()) : "";
    }

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; i += 3) {
            int n2 = byArray[i] << 16 & 0xFF0000;
            if (i + 1 < n) {
                n2 |= byArray[i + 1] << 8 & 0xFF00;
            }
            if (i + 2 < n) {
                n2 |= byArray[i + 2] & 0xFF;
            }
            stringBuffer.append(Base64Map[n2 >>> 18 & 0x3F]);
            stringBuffer.append(Base64Map[n2 >>> 12 & 0x3F]);
            stringBuffer.append(i + 1 < n ? Base64Map[n2 >>> 6 & 0x3F] : (char)'=');
            stringBuffer.append(i + 2 < n ? Base64Map[n2 & 0x3F] : (char)'=');
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = string.length(); n > 0 && string.charAt(n - 1) == '='; --n) {
        }
        int n2 = 0;
        int n3 = (n - 1) / 4 * 3 + (n - 1) % 4;
        if ((n - 1) % 4 == 0) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n; i += 4) {
            int n4 = Base64._indexOf(string.charAt(i)) << 18 & 0xFC0000;
            if (i + 1 < n) {
                n4 |= Base64._indexOf(string.charAt(i + 1)) << 12 & 0x3F000;
            }
            if (i + 2 < n) {
                n4 |= Base64._indexOf(string.charAt(i + 2)) << 6 & 0xFC0;
            }
            if (i + 3 < n) {
                n4 |= Base64._indexOf(string.charAt(i + 3)) & 0x3F;
            }
            byArray[n2++] = (byte)(n4 >>> 16 & 0xFF);
            if (i + 2 < n) {
                byArray[n2++] = (byte)(n4 >>> 8 & 0xFF);
            }
            if (i + 3 >= n) continue;
            byArray[n2++] = (byte)(n4 & 0xFF);
        }
        return byArray;
    }
}

