/*
 * Decompiled with CFR 0.152.
 */
package drivehub.client;

import drivehub.client.ProgressLogger;
import drivehub.client.SensorRecordStore;
import drivehub.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public abstract class SensorPush
implements Runnable {
    private static final long EVENTS_GROUP_THRESHOLD = 120000L;
    private static final int MAX_RECORDS_IN_PUSH = 150;
    private static final long PUSH_TIMEOUT = 300000L;
    protected String pushURL;
    protected ProgressLogger logger;
    protected boolean active;
    protected int minimumPushSize = 20;
    protected int pushedSize;
    private Object sync = new Object();
    private long active_trip_stamp;
    private SensorRecordStore recordStore;
    private Vector collectedRecordIDs;
    private Vector collectedRecordBytes;
    private long collected_trip_stamp;
    private long min_ts;
    private long max_ts;

    public SensorPush(SensorRecordStore sensorRecordStore, String string, String string2, ProgressLogger progressLogger) {
        String string3 = "";
        if (string.indexOf("://") == -1) {
            string3 = "http://";
        }
        this.pushURL = string3 + string + "?token=" + string2;
        if (progressLogger == null) {
            progressLogger = new ProgressLogger(){

                public void info(String string, String string2) {
                }

                public void info(String string) {
                }

                public void error(String string, Exception exception) {
                }
            };
        }
        this.logger = progressLogger;
        this.recordStore = sensorRecordStore;
    }

    public void setActiveTrip(long l) {
        this.active_trip_stamp = l;
    }

    public void analyseRecord(int n, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        long l = dataInputStream.readLong();
        dataInputStream.readUTF();
        dataInputStream.readByte();
        long l2 = dataInputStream.readLong();
        if (this.collectedRecordIDs.size() > 150) {
            return;
        }
        if (this.min_ts == -1L) {
            this.min_ts = l2;
        }
        if (this.max_ts == -1L) {
            this.max_ts = l2;
        }
        if (this.collected_trip_stamp == -1L) {
            this.collected_trip_stamp = l;
        }
        if (this.collected_trip_stamp != l && (this.min_ts - l2 > 120000L || l2 - this.max_ts > 120000L)) {
            return;
        }
        if (this.min_ts > l2) {
            this.min_ts = l2;
        }
        if (this.max_ts < l2) {
            this.max_ts = l2;
        }
        this.collectedRecordIDs.addElement(new Integer(n));
        this.collectedRecordBytes.addElement(byArray);
    }

    public void pushStream(OutputStream outputStream) throws Exception {
        this.pushedSize = 0;
        outputStream.write("date=".getBytes("UTF-8"));
        outputStream.write(String.valueOf((int)(this.min_ts / 1000L)).getBytes("UTF-8"));
        outputStream.write(38);
        outputStream.write("tags=sensor".getBytes("UTF-8"));
        outputStream.write(38);
        outputStream.write("push=".getBytes("UTF-8"));
        this.pushedSize += 20;
        for (int i = 0; i < this.collectedRecordBytes.size(); ++i) {
            byte[] byArray = (byte[])this.collectedRecordBytes.elementAt(i);
            outputStream.write("$E07D=".getBytes("UTF-8"));
            String string = Base64.encode(byArray);
            this.pushedSize += string.length();
            outputStream.write(string.getBytes());
        }
    }

    public int getPushedSize() {
        return this.pushedSize;
    }

    public void activate() {
        if (!this.active) {
            this.active = true;
            new Thread(this).start();
        }
    }

    public void deactivate() {
        this.active = false;
        this.triggerUpload();
    }

    public void setMinimumPushSize(int n) {
        this.minimumPushSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerUpload() {
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = true;
        while (true) {
            Object object;
            try {
                if (!bl) {
                    object = this.sync;
                    synchronized (object) {
                        this.sync.wait(300000L);
                    }
                }
                if (!this.active) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            try {
                int n;
                this.collectedRecordIDs = new Vector();
                this.collectedRecordBytes = new Vector();
                this.collected_trip_stamp = -1L;
                this.min_ts = -1L;
                this.max_ts = -1L;
                object = this.recordStore.enumerateRecordIDs();
                while (object.hasMoreElements()) {
                    n = (Integer)object.nextElement();
                    byte[] byArray = this.recordStore.getRecord(n);
                    this.analyseRecord(n, byArray);
                }
                if (this.active_trip_stamp == this.collected_trip_stamp) continue;
                if (this.collectedRecordIDs.size() == 0) {
                    this.logger.info("no records");
                    bl = false;
                    continue;
                }
                if (this.collectedRecordIDs.size() < this.minimumPushSize) {
                    this.logger.info("not enough records");
                    bl = false;
                    continue;
                }
                this.logger.info("pushing " + this.collectedRecordIDs.size() + " records");
                n = this.pushData() ? 1 : 0;
                if (n != 0) {
                    for (int i = 0; i < this.collectedRecordIDs.size(); ++i) {
                        this.recordStore.deleteRecord((Integer)this.collectedRecordIDs.elementAt(i));
                    }
                    this.logger.info("pushed " + this.getPushedSize());
                    continue;
                }
                bl = false;
                continue;
            }
            catch (Exception exception) {
                this.logger.error("pushing", exception);
                exception.printStackTrace();
                bl = false;
                continue;
            }
            break;
        }
    }

    public abstract boolean pushData() throws Exception;
}

