/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.util;

import com.mympgtracker.util.Convert;
import com.mympgtracker.util.TrackerException;
import java.util.Calendar;
import java.util.Vector;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Log {
    public static boolean disableAll_ = false;
    public static boolean enableInfo_ = true;
    public static boolean enableWarn_ = true;
    public static boolean enableError_ = true;
    public static boolean enableFatal_ = true;
    public static boolean enableDebug_ = true;
    public static boolean echoToRecordStore_ = false;
    public static boolean echoToSTDOUT = true;
    public static boolean enablePrintStackTrace_ = true;
    private static final String RS_NAME = "MyMPGTracker.Log";
    private static RecordStore rs_ = null;
    private static Vector messageListeners_ = new Vector();
    private static int closeCounter_ = 0;

    private Log() {
    }

    public static void addMessageListener(LogMessageListener logMessageListener) {
        messageListeners_.addElement(logMessageListener);
    }

    public static void deleteExistingLog() throws Exception {
        Log.init();
        Log.close();
        String[] stringArray = RecordStore.listRecordStores();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!RS_NAME.equals(stringArray[i])) continue;
            RecordStore.deleteRecordStore((String)RS_NAME);
            return;
        }
    }

    private static void init() throws Exception {
        if (rs_ == null && echoToRecordStore_) {
            rs_ = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
        }
    }

    public static void close() {
        if (rs_ != null) {
            try {
                Log.close(true);
                rs_ = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void close(boolean bl) throws Exception {
        if (bl) {
            closeCounter_ = 0;
        }
        System.out.println("Close Count: " + ++closeCounter_);
        try {
            rs_.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            if (recordStoreException.getMessage().indexOf("record store is still open") >= 0) {
                Log.close(false);
            }
            throw recordStoreException;
        }
        catch (Exception exception) {
            System.out.println("Unexpected Exception Closing Log");
        }
    }

    public static RecordEnumeration getLogRecordIDEnumeration() throws Exception {
        Log.init();
        if (rs_ == null) {
            return null;
        }
        return rs_.enumerateRecords(null, new RecordComparator(){

            public int compare(byte[] byArray, byte[] byArray2) {
                return new String(byArray, 0, 13).compareTo(new String(byArray2, 0, 13));
            }
        }, false);
    }

    public static String getLogRecordById(int n) throws Exception {
        Log.init();
        return new String(rs_.getRecord(n));
    }

    private static void appendMessage(Object object, String string, String string2, Throwable throwable) {
        if (disableAll_) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        String string3 = "--\n";
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        int n4 = calendar.get(14);
        string3 = string3 + (n < 10 ? "0" : "") + n + ":" + (n2 < 10 ? "0" : "") + n2 + ":" + (n3 < 10 ? "0" : "") + n3 + ":" + (n4 < 1000 ? "0" : "") + (n4 < 100 ? "0" : "") + (n4 < 10 ? "0" : "") + n4;
        string3 = string3 + "(" + string + ")";
        if (object != null) {
            string3 = string3 + Convert.toShortName(object.getClass());
        }
        string3 = string3 + "\n";
        string3 = string3 + "[free:" + Runtime.getRuntime().freeMemory() / 1024L + "kb]";
        if (throwable == null || string2 != throwable.getMessage()) {
            string3 = string3 + string2 + "\n";
        }
        if (throwable != null) {
            string3 = string3 + Convert.toShortName(throwable.getClass()) + "\n";
            string3 = string3 + throwable.getMessage();
            string3 = string3 + "\n";
            if (enablePrintStackTrace_ && echoToSTDOUT && echoToSTDOUT) {
                if (throwable instanceof TrackerException) {
                    TrackerException trackerException = (TrackerException)throwable;
                    string3 = string3 + trackerException.originator_;
                    if (trackerException.method_ != null) {
                        string3 = string3 + "." + trackerException.method_;
                    }
                    if (trackerException.id_ != null) {
                        string3 = string3 + " id:" + trackerException.id_;
                    }
                    string3 = string3 + "\n";
                }
                throwable.printStackTrace();
            }
        }
        for (int i = 0; i < messageListeners_.size(); ++i) {
            ((LogMessageListener)messageListeners_.elementAt(i)).logMessage(string3);
        }
        if (echoToSTDOUT) {
            System.out.print(string3);
        }
        if (echoToRecordStore_) {
            try {
                Log.init();
                if (rs_.getSize() + string3.length() >= rs_.getSizeAvailable()) {
                    Log.trimLogToFit(string3.length());
                }
                rs_.addRecord(string3.getBytes(), 0, string3.length());
                Log.close();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to log to the log record store.\n" + exception.getMessage());
            }
        }
    }

    private static void trimLogToFit(int n) throws Exception {
        RecordEnumeration recordEnumeration = Log.getLogRecordIDEnumeration();
        while (rs_.getSize() + n >= rs_.getSizeAvailable()) {
            rs_.deleteRecord(recordEnumeration.nextRecordId());
        }
    }

    public static final void info(Object object, String string) {
        if (enableInfo_) {
            Log.appendMessage(object, "I", string, null);
        }
    }

    public static final void warn(Object object, String string) {
        if (enableWarn_) {
            Log.appendMessage(object, "W", string, null);
        }
    }

    public static final void error(Object object, String string) {
        Log.error(object, string, null);
    }

    public static final void error(Object object, String string, Throwable throwable) {
        if (enableError_) {
            Log.appendMessage(object, "E", string, throwable);
        }
    }

    public static final void fatal(Object object, String string, Throwable throwable) {
        if (enableFatal_) {
            Log.appendMessage(object, "F", string, throwable);
        }
    }

    public static final void fatal(Object object, String string) {
        if (enableFatal_) {
            Log.appendMessage(object, "F", string, null);
        }
    }

    public static final void debug(Object object, String string) {
        if (enableDebug_) {
            Log.appendMessage(object, "D", string, null);
        }
    }

    public static interface LogMessageListener {
        public void logMessage(String var1);
    }
}

