/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.util;

public class Convert {
    private static char[] B2H = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Convert() {
    }

    public static int toInt(String string) {
        return Integer.valueOf(string);
    }

    public static int toRoundedInt(double d) {
        if (d % 1.0 >= 0.5) {
            return (int)d + 1;
        }
        return (int)d;
    }

    public static double toDouble(String string) {
        boolean bl = false;
        int n = -1;
        double d = 0.0;
        double d2 = 0.0;
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                n = 0;
                continue;
            }
            if (c == '-') {
                bl = true;
                continue;
            }
            if (n == -1) {
                d *= 10.0;
                d += (double)(c - 48);
                continue;
            }
            if (n == 0) {
                d2 = (double)(c - 48) / 10.0;
            } else {
                double d3 = 0.1;
                for (int j = 1; j < n; ++j) {
                    d3 *= 0.1;
                }
                d2 += (double)(c - 48) / 10.0 * d3;
            }
            ++n;
        }
        return bl ? -d : (d += d2);
    }

    public static String toString(int n) {
        return "" + n;
    }

    public static String toString(double d) {
        return "" + d;
    }

    public static String toString(double d, int n) {
        return Convert.toString(d, n, true);
    }

    public static String toString(double d, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = d < 0.0;
        if (n <= 0) {
            return (int)d + "";
        }
        d = Math.abs(d);
        d *= (double)(n * 10);
        d = (int)d;
        String string = (d /= (double)(n * 10)) + "000000";
        int n2 = string.indexOf(46);
        string = string.substring(0, n2 + n + 1);
        if (d == 0.0) {
            return string;
        }
        if (bl2) {
            string = bl ? "-" + string : string + "-";
        }
        return string;
    }

    public static String unsigned2hex(int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = n2 - 1; i >= 0; --i) {
            cArray[i] = B2H[n & 0xF];
            n >>= 4;
        }
        return new String(cArray);
    }

    public static int toOct(char c) throws RuntimeException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("the char [" + c + "] is not a valid octal character");
    }

    public static boolean isHex(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'A' && c <= 'F') {
            return true;
        }
        return c >= 'a' && c <= 'f';
    }

    public static char toUpperCase(char c) {
        return Character.toUpperCase(c);
    }

    public static String toShortName(Class clazz) {
        String string = clazz.getName();
        if (string.indexOf(".") >= 0) {
            string = string.substring(string.lastIndexOf(46) + 1, string.length());
        }
        return string;
    }

    public static String bytesToString(byte[] byArray) {
        return Convert.bytesToString(byArray, 0, byArray.length);
    }

    public static String bytesToString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < byArray.length && i < n2; ++i) {
            stringBuffer.append("x" + Convert.unsigned2hex(byArray[i], 2));
        }
        return stringBuffer.toString();
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public static byte calcCheckSum(byte[] byArray) {
        byte by = 0;
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(by + byArray[i]);
        }
        return by;
    }

    public static void main(String[] stringArray) {
        System.out.println("-12.345 p2 -> " + Convert.toString(-12.345, 0));
    }
}

