/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.util;

import com.mympgtracker.util.Convert;
import com.mympgtracker.util.Coord;
import com.mympgtracker.util.Rect;

public class AffineTransform {
    private static final int AFFINE_MATRIX_SIZE = 3;
    private Matrix matrix_ = null;

    private AffineTransform(Matrix matrix) {
        this.matrix_ = matrix;
    }

    public String toString() {
        return this.matrix_.toString();
    }

    public void apply(Rect rect) {
        PointVector pointVector = new PointVector(rect.x, rect.y);
        PointVector pointVector2 = new PointVector(rect.x + rect.width, rect.y + rect.height);
        pointVector = AffineTransform.multiply(pointVector, this.matrix_);
        pointVector2 = AffineTransform.multiply(pointVector2, this.matrix_);
        rect.x = pointVector.getX();
        rect.y = pointVector.getY();
        rect.width = pointVector2.getX() - pointVector.getX();
        rect.height = pointVector2.getY() - pointVector.getY();
    }

    public void apply(Coord coord) {
        PointVector pointVector = new PointVector(coord.x, coord.y);
        pointVector = AffineTransform.multiply(pointVector, this.matrix_);
        coord.x = pointVector.getX();
        coord.y = pointVector.getY();
    }

    public void apply(Coord[] coordArray) {
        for (int i = 0; i < coordArray.length; ++i) {
            this.apply(coordArray[i]);
        }
    }

    public void addTranslate(int n, int n2) {
        Matrix matrix = AffineTransform.createTranslateMatrix(n, n2);
        this.matrix_ = AffineTransform.multiply(matrix, this.matrix_);
    }

    public void addRotate(double d) {
        Matrix matrix = AffineTransform.createRotateMatrix(d);
        this.matrix_ = AffineTransform.multiply(matrix, this.matrix_);
    }

    public void addScale(double d, double d2) {
        Matrix matrix = AffineTransform.createScaleMatrix(d, d2);
        this.matrix_ = AffineTransform.multiply(matrix, this.matrix_);
    }

    public static AffineTransform translateInstance(int n, int n2) {
        return new AffineTransform(AffineTransform.createTranslateMatrix(n, n2));
    }

    public static AffineTransform translateInstance(double d, double d2) {
        return new AffineTransform(AffineTransform.createTranslateMatrix(d, d2));
    }

    public static AffineTransform rotateInstance(double d) {
        return new AffineTransform(AffineTransform.createRotateMatrix(d));
    }

    public static AffineTransform scaleInstance(double d, double d2) {
        return new AffineTransform(AffineTransform.createScaleMatrix(d, d2));
    }

    private static PointVector multiply(PointVector pointVector, Matrix matrix) {
        PointVector pointVector2 = new PointVector(0, 0);
        for (int i = 0; i < matrix.getSize(); ++i) {
            double d = 0.0;
            for (int j = 0; j < matrix.getSize(); ++j) {
                d += (double)pointVector.m_[j] * matrix.m_[i][j];
            }
            pointVector2.m_[i] = d - (double)((int)d) >= 0.5 ? (int)d + 1 : (int)d;
        }
        return pointVector2;
    }

    private static Matrix createScaleMatrix(double d, double d2) {
        Matrix matrix = new Matrix();
        matrix.m_[0][0] = d;
        matrix.m_[0][1] = 0.0;
        matrix.m_[0][2] = 0.0;
        matrix.m_[1][0] = 0.0;
        matrix.m_[1][1] = d2;
        matrix.m_[1][2] = 0.0;
        matrix.m_[2][0] = 0.0;
        matrix.m_[2][1] = 0.0;
        matrix.m_[2][2] = 1.0;
        return matrix;
    }

    private static Matrix createRotateMatrix(double d) {
        Matrix matrix = new Matrix();
        matrix.m_[0][0] = Math.cos(d);
        matrix.m_[0][1] = Math.sin(d) * -1.0;
        matrix.m_[0][2] = 0.0;
        matrix.m_[1][0] = Math.sin(d);
        matrix.m_[1][1] = Math.cos(d);
        matrix.m_[1][2] = 0.0;
        matrix.m_[2][0] = 0.0;
        matrix.m_[2][1] = 0.0;
        matrix.m_[2][2] = 1.0;
        return matrix;
    }

    private static Matrix createTranslateMatrix(double d, double d2) {
        Matrix matrix = new Matrix();
        matrix.m_[0][0] = 1.0;
        matrix.m_[0][1] = 0.0;
        matrix.m_[0][2] = d;
        matrix.m_[1][0] = 0.0;
        matrix.m_[1][1] = 1.0;
        matrix.m_[1][2] = d2;
        matrix.m_[2][0] = 0.0;
        matrix.m_[2][1] = 0.0;
        matrix.m_[2][2] = 1.0;
        return matrix;
    }

    private static Matrix multiply(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = new Matrix();
        for (int i = 0; i < matrix.getSize(); ++i) {
            for (int j = 0; j < matrix.getSize(); ++j) {
                double d = 0.0;
                for (int k = 0; k < matrix.getSize(); ++k) {
                    d += matrix.m_[i][k] * matrix2.m_[k][j];
                }
                matrix3.m_[i][j] = d;
            }
        }
        return matrix3;
    }

    private static class PointVector {
        public int[] m_ = new int[3];

        protected PointVector(int n, int n2) {
            this.m_[0] = n;
            this.m_[1] = n2;
            this.m_[2] = 1;
        }

        public int getSize() {
            return this.m_.length;
        }

        public int getX() {
            return this.m_[0];
        }

        public int getY() {
            return this.m_[1];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(15);
            stringBuffer.append("\n");
            for (int i = 0; i < this.getSize(); ++i) {
                stringBuffer.append("|");
                stringBuffer.append(Convert.toString(this.m_[i]));
                stringBuffer.append("|\n");
            }
            return stringBuffer.toString();
        }
    }

    private static class Matrix {
        protected double[][] m_ = new double[3][3];

        protected Matrix() {
        }

        public int getSize() {
            return this.m_.length;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n");
            for (int i = 0; i < this.getSize(); ++i) {
                stringBuffer.append("|");
                for (int j = 0; j < this.getSize(); ++j) {
                    stringBuffer.append(Convert.toString(this.m_[i][j]));
                    stringBuffer.append(" ");
                }
                stringBuffer.append("|\n");
            }
            return stringBuffer.toString();
        }
    }
}

