/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.profile.text;

import com.mympgtracker.ecutracker.profile.color.Color;
import com.mympgtracker.ecutracker.profile.text.TextRenderer;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Convert;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ntr.ttme.DoubleRectangle;
import ntr.ttme.TrueTypeRegistry;
import ntr.ttme.TrueTypeText;
import ntr.ttme.View;

public class TTFTextRenderer
implements TextRenderer,
Cleanable {
    private static final String TTF_RESOURCE_PATH = "/ecutracker-res/ttf/";
    public static final String FONT_FFF_FORWARD = "FFF_Forward.ttf";
    public static final String FONT_BOMBARDIER = "bombardier.ttf";
    public static final String FONT_DEFAULT = "bombardier.ttf";
    public static final String[] ALL_FONTS = new String[]{"FFF_Forward.ttf", "bombardier.ttf"};
    private static String GLYPH_KEY_SEP = "/";
    private String fontName_ = null;
    private String fontPath_ = null;
    private int heightInPixels_ = 0;
    private Color color_ = null;
    private Image stagingImage_ = Image.createImage((int)1, (int)1);
    private Hashtable glyphCache_ = new Hashtable(10);
    static Font f = Font.getFont((int)32, (int)0, (int)16);
    static /* synthetic */ Class class$com$mympgtracker$ecutracker$profile$text$TTFTextRenderer;

    public TTFTextRenderer(String string, int n, Color color) throws Exception {
        this.fontName_ = string;
        this.fontPath_ = TTF_RESOURCE_PATH + string;
        this.heightInPixels_ = n;
        this.color_ = color;
        if (TrueTypeRegistry.instance.get(this.fontPath_) == null) {
            TrueTypeRegistry.instance.registerTrueType(this.fontPath_, (class$com$mympgtracker$ecutracker$profile$text$TTFTextRenderer == null ? (class$com$mympgtracker$ecutracker$profile$text$TTFTextRenderer = TTFTextRenderer.class$("com.mympgtracker.ecutracker.profile.text.TTFTextRenderer")) : class$com$mympgtracker$ecutracker$profile$text$TTFTextRenderer).getResourceAsStream(this.fontPath_));
        }
        this.heightInPixels_ = n;
    }

    public void cleanYourRoom() {
        this.glyphCache_.clear();
        this.glyphCache_ = null;
        this.stagingImage_ = null;
    }

    public String generateKey() {
        return TTFTextRenderer.generateKey(this.fontName_, this.heightInPixels_, this.color_);
    }

    public static String generateKey(String string, int n, Color color) {
        return Convert.toShortName(class$com$mympgtracker$ecutracker$profile$text$TTFTextRenderer == null ? (class$com$mympgtracker$ecutracker$profile$text$TTFTextRenderer = TTFTextRenderer.class$("com.mympgtracker.ecutracker.profile.text.TTFTextRenderer")) : class$com$mympgtracker$ecutracker$profile$text$TTFTextRenderer) + GLYPH_KEY_SEP + string + GLYPH_KEY_SEP + n + GLYPH_KEY_SEP + color;
    }

    public synchronized void drawText(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2) throws Exception {
        graphics.setFont(f);
        graphics.drawString(string, n, n2, 65);
    }

    private String generateGlyphKey(String string, char c, int n, Color color) {
        return string + GLYPH_KEY_SEP + c + GLYPH_KEY_SEP + n + GLYPH_KEY_SEP + color;
    }

    private Glyph[] getGlyphs(String string, Color color) throws Exception {
        int n;
        Glyph[] glyphArray = new Glyph[string.length()];
        Glyph glyph = null;
        int[] nArray = new int[2500];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < string.length(); ++n) {
            String string2 = this.generateGlyphKey(this.fontPath_, string.charAt(n), this.heightInPixels_, color);
            glyph = (Glyph)this.glyphCache_.get(string2);
            if (glyph == null) {
                glyph = this.createTransparantBGGlyph(string.charAt(n), color);
                this.glyphCache_.put(string2, glyph);
            }
            glyphArray[n] = glyph;
        }
        return glyphArray;
    }

    private Glyph createTransparantBGGlyph(char c, Color color) throws Exception {
        View view = new View(0, 0);
        double d = view.convertXViewToWorld(0);
        double d2 = view.convertYViewToWorld(0);
        TrueTypeText trueTypeText = new TrueTypeText(this.fontPath_, d, d2, c + "", this.heightInPixels_, new Integer(color.value()), new Integer(color.value()));
        trueTypeText.draw(view, this.stagingImage_.getGraphics());
        DoubleRectangle doubleRectangle = trueTypeText.getBounds();
        int n = view.convertXWorldToView(doubleRectangle.getX()) + view.convertXWorldToView(doubleRectangle.getWidth()) + 1;
        int n2 = Math.max(Math.abs(view.convertYWorldToView(doubleRectangle.getHeight())), Math.abs(view.convertYWorldToView(doubleRectangle.getY())));
        n2 += n2 + view.convertYWorldToView(doubleRectangle.getY());
        int n3 = Math.abs(view.convertYWorldToView(doubleRectangle.getY()));
        trueTypeText.translate(0.0, view.convertYViewToWorld(n3 + 1));
        int n4 = color.equals(Color.GREEN) ? Color.RED.value() : Color.GREEN.value();
        Image image = Image.createImage((int)n, (int)(n2 + 1));
        Graphics graphics = image.getGraphics();
        graphics.setColor(n4);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(color.value());
        int[] nArray = new int[1];
        image.getRGB(nArray, 0, 1, 0, 0, 1, 1);
        n4 = nArray[0];
        trueTypeText.draw(view, graphics);
        nArray = new int[image.getWidth() * image.getHeight()];
        image.getRGB(nArray, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        for (int i = 0; i < image.getWidth() * image.getHeight(); ++i) {
            if (nArray[i] != n4) continue;
            nArray[i] = nArray[i] & 0xFFFFFF;
        }
        image = Image.createRGBImage((int[])nArray, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
        Glyph glyph = new Glyph();
        glyph.image_ = image;
        glyph.yOffset = n2 - n3;
        return glyph;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Glyph {
        public Image image_ = null;
        public int yOffset = 0;

        private Glyph() {
        }
    }
}

