/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.profile.gauge;

import com.mympgtracker.ecutracker.profile.ProfileRenderer;
import com.mympgtracker.ecutracker.profile.color.ColorModel;
import com.mympgtracker.ecutracker.profile.gauge.ProfileGauge;
import com.mympgtracker.ecutracker.profile.text.TTFTextRenderer;
import com.mympgtracker.ecutracker.profile.text.TextRendererCache;
import com.mympgtracker.util.Convert;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.Rect;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class DigitalGauge
extends ProfileGauge {
    private static final double DEFAULT_FONT_HEIGHT_PERCENT = 0.5;
    public static final String PROP_I_PRECISION = "precision";
    public static final String PROP_D_FONT_HEIGHT = "font-height";

    protected double getCurrentDisplayValue() {
        return this.getECUParameter().getValue();
    }

    public void render(Graphics graphics, Rect rect, ColorModel colorModel, boolean bl) {
        if (this.isRangeRedGreenValid()) {
            int n = this.getRangeColor(this.getCurrentDisplayValue(), colorModel.get(200).value());
            graphics.setColor(n);
        } else {
            graphics.setColor(colorModel.get(200).value());
        }
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        graphics.setColor(colorModel.get(201).value());
        graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        graphics.setColor(colorModel.get(202).value());
        String string = this.getProperty("label");
        Font font = null;
        if (string != null) {
            font = ProfileRenderer.findFontBestFitWidth(rect.width - 6, string, false);
            graphics.setFont(font);
            graphics.drawString(string, rect.x + rect.width / 2, rect.y + rect.height - 1, 33);
        }
        try {
            String string2;
            TTFTextRenderer tTFTextRenderer;
            String string3 = Convert.toString(this.getCurrentDisplayValue(), this.getIntProperty(PROP_I_PRECISION, 0));
            double d = this.getDoubleProperty(PROP_D_FONT_HEIGHT, 0.5);
            int n = (int)((double)rect.height * d);
            if (this.currentColorModel_ == null) {
                this.currentColorModel_ = colorModel;
            }
            if ((tTFTextRenderer = (TTFTextRenderer)TextRendererCache.get(string2 = TTFTextRenderer.generateKey("bombardier.ttf", n, colorModel.get(202)))) == null) {
                tTFTextRenderer = new TTFTextRenderer("bombardier.ttf", n, colorModel.get(202));
                TextRendererCache.put(string2, tTFTextRenderer);
            }
            tTFTextRenderer.drawText(graphics, string3, rect.x + rect.width / 2, rect.y + rect.height / 2, true, true);
            this.currentColorModel_ = colorModel;
        }
        catch (Exception exception) {
            Log.error(this, "Error rendering value", exception);
            throw new RuntimeException("Render Error: " + exception.getMessage());
        }
    }
}

