/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.profile.gauge;

import com.mympgtracker.ecutracker.profile.ProfileRenderer;
import com.mympgtracker.ecutracker.profile.color.ColorModel;
import com.mympgtracker.ecutracker.profile.gauge.ProfileGauge;
import com.mympgtracker.util.AffineTransform;
import com.mympgtracker.util.Convert;
import com.mympgtracker.util.Coord;
import com.mympgtracker.util.Rect;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class AbstractAnalogGauge
extends ProfileGauge {
    protected static final String PROP_D_RANGE_START = "range-start";
    protected static final String PROP_D_RANGE_END = "range-end";
    protected static final String PROP_D_TICK_INTERVAL = "tick-interval";
    protected static final String PROP_D_TICK_LABEL_INTERVAL = "tick-label-interval";
    protected static final String PROP_B_REVERSE = "reverse";
    protected static final String PROP_B_INCLUDE_TICKS = "include-ticks";
    protected static final String PROP_B_INCLUDE_TICK_LABELS = "include-tick-labels";
    protected static final String PROP_B_INCLUDE_DIGITAL_VALUE = "include-digital-value";
    protected static final String PROP_B_INCLUDE_HIGH_HOLD = "include-high-hold";
    protected static final String PROP_B_INCLUDE_LOW_HOLD = "include-low-hold";
    protected static final String PROP_I_PRECISION = "precision";
    protected static final String PROP_I_TICK_LABEL_DIV = "tick-label-divisor";
    protected static final String PROP_D_NORMAL_LOW = "normal-low";
    protected static final String PROP_D_NORMAL_HIGH = "normal-high";
    protected static final String PROP_D_WARNING_LOW = "warning-low";
    protected static final String PROP_D_WARNING_HIGH = "warning-high";
    protected static final String PROP_D_CRITICAL_LOW = "critical-low";
    protected static final String PROP_D_CRITICAL_HIGH = "critical-high";
    protected static final String PROP_I_LOW_HOLD_DELAY = "low-hold-delay";
    protected static final String PROP_I_HIGH_HOLD_DELAY = "high-hold-delay";
    protected static final int MINIMUM_NEEDLE_WIDTH = 3;
    protected static final int MINIMUM_TICK_LENGTH = 4;
    private static final int HOLD_NEEDLE_DELAY_IN_SEC = 4;
    private static final double HOLD_NEEDLE_RETURN_VALUE_PERCENT = 0.03;
    protected double outerRingRadiusPrecent_ = 0.48;
    protected double tickMarkOuterRadiusPrecent_ = 0.46;
    protected double tickMarkLengthPercent_ = 0.04;
    protected double needleWidthPrecent_ = 0.05;
    protected double needleTailPrecent_ = 0.02;
    protected int ringStartAngle_ = 0;
    protected int ringEndAngle_ = 360;
    protected int minimumAngle_ = 50;
    protected int maximumAngle_ = 360 - this.minimumAngle_;
    protected double labelDistanceFromPivotPercentX_ = 0.0;
    protected double labelDistanceFromPivotPercentY_ = 0.0;
    protected int labelAnchor_ = 33;
    protected double digitalDistanceFromPivotPercentX_ = 0.0;
    protected double digitalDistanceFromPivotPercentY_ = 0.0;
    protected int digitalAnchor_ = 17;
    private double highHoldValue_ = Double.MIN_VALUE;
    private double lowHoldValue_ = Double.MAX_VALUE;
    private long highHoldTimestamp_ = 0L;
    private long lowHoldTimestamp_ = 0L;
    private Image staticContent_ = null;
    private Font currentValueFont_ = null;
    private double previousValue_ = Double.MAX_VALUE;

    public double getRangeStart() {
        return this.getDoubleProperty(PROP_D_RANGE_START, 0.0);
    }

    public void setRangeStart(double d) {
        this.setDoubleProperty(PROP_D_RANGE_START, d);
    }

    public double getRangeEnd() {
        return this.getDoubleProperty(PROP_D_RANGE_END, 0.0);
    }

    public void setRangeEnd(double d) {
        this.setDoubleProperty(PROP_D_RANGE_END, d);
    }

    public int getTickInterval() {
        return this.getIntProperty(PROP_D_TICK_INTERVAL, 5);
    }

    public void setTickInterval(int n) {
        this.setIntProperty(PROP_D_TICK_INTERVAL, n);
    }

    public boolean getReverse() {
        return this.getBooleanProperty(PROP_B_REVERSE);
    }

    public boolean getIncludeTicks() {
        return this.getBooleanProperty(PROP_B_INCLUDE_TICKS);
    }

    public void setIncludeTicks(boolean bl) {
        this.setBooleanProperty(PROP_B_INCLUDE_TICKS, bl);
    }

    public boolean getIncludeTickLabels() {
        return this.getBooleanProperty(PROP_B_INCLUDE_TICK_LABELS);
    }

    public void setIncludeTickLabels(boolean bl) {
        this.setBooleanProperty(PROP_B_INCLUDE_TICK_LABELS, bl);
    }

    public int getTickLabelInterval() {
        return this.getIntProperty(PROP_D_TICK_LABEL_INTERVAL, 5);
    }

    public void setTickLabelInterval(int n) {
        this.setIntProperty(PROP_D_TICK_LABEL_INTERVAL, n);
    }

    public double getTickLabelDivisor() {
        return this.getDoubleProperty(PROP_I_TICK_LABEL_DIV, 1.0);
    }

    public void setTickLabelDivisor(double d) {
        this.setDoubleProperty(PROP_I_TICK_LABEL_DIV, d);
    }

    public boolean getIncludeDigitalValue() {
        return this.getBooleanProperty(PROP_B_INCLUDE_DIGITAL_VALUE);
    }

    public void setIncludeDigitalValue(boolean bl) {
        this.setBooleanProperty(PROP_B_INCLUDE_DIGITAL_VALUE, bl);
    }

    public int getPrecision() {
        return this.getIntProperty(PROP_I_PRECISION, 0);
    }

    public void setPrecision(int n) {
        this.setIntProperty(PROP_I_PRECISION, n);
    }

    public void setIncludeHighHold(boolean bl) {
        this.setBooleanProperty(PROP_B_INCLUDE_HIGH_HOLD, bl);
    }

    public boolean getIncludeHighHold() {
        return this.getBooleanProperty(PROP_B_INCLUDE_HIGH_HOLD);
    }

    public void setIncludeLowHold(boolean bl) {
        this.setBooleanProperty(PROP_B_INCLUDE_LOW_HOLD, bl);
    }

    public boolean getIncludeLowHold() {
        return this.getBooleanProperty(PROP_B_INCLUDE_LOW_HOLD);
    }

    public int getLowHoldDelay() {
        return this.getIntProperty(PROP_I_LOW_HOLD_DELAY, 4);
    }

    public int getHighHoldDelay() {
        return this.getIntProperty(PROP_I_HIGH_HOLD_DELAY, 4);
    }

    public double getNormalLow() {
        return this.getDoubleProperty(PROP_D_NORMAL_LOW, this.getRangeStart() - 1.0);
    }

    public double getNormalHigh() {
        return this.getDoubleProperty(PROP_D_NORMAL_HIGH, this.getRangeEnd() + 1.0);
    }

    public double getWarningLow() {
        return this.getDoubleProperty(PROP_D_WARNING_LOW, this.getRangeStart() - 1.0);
    }

    public double getWarningHigh() {
        return this.getDoubleProperty(PROP_D_WARNING_HIGH, this.getRangeEnd() + 1.0);
    }

    public double getCriticalLow() {
        return this.getDoubleProperty(PROP_D_CRITICAL_LOW, this.getRangeStart() - 1.0);
    }

    public double getCriticalHigh() {
        return this.getDoubleProperty(PROP_D_CRITICAL_HIGH, this.getRangeEnd() + 1.0);
    }

    private double calculateValueAngle(double d) {
        d -= this.getRangeStart();
        d /= this.getRangeEnd() - this.getRangeStart();
        d = this.getReverse() ? (double)this.maximumAngle_ - (double)(this.maximumAngle_ - this.minimumAngle_) * d : (double)this.minimumAngle_ + (double)(this.maximumAngle_ - this.minimumAngle_) * d;
        return d;
    }

    public abstract Coord getPivotPoint(Rect var1);

    public void render(Graphics graphics, Rect rect, ColorModel colorModel, boolean bl) {
        Coord coord = this.getPivotPoint(rect);
        if (!rect.equals(this.currentRect_) || colorModel != this.currentColorModel_ || bl || this.staticContent_ == null) {
            Rect rect2 = new Rect(0, 0, rect.width, rect.height);
            Coord coord2 = new Coord(coord.x - rect.x, coord.y - rect.y);
            this.staticContent_ = this.generateStaticImage(colorModel, rect2, coord2);
        }
        if (this.previousValue_ != this.getECUParameter().getValue() || bl || !rect.equals(this.currentRect_) || colorModel != this.currentColorModel_) {
            graphics.drawImage(this.staticContent_, rect.x, rect.y, 20);
            this.renderDynamic(graphics, rect, colorModel, coord);
        }
        this.currentRect_ = rect;
        this.currentColorModel_ = colorModel;
    }

    public void renderDynamic(Graphics graphics, Rect rect, ColorModel colorModel, Coord coord) {
        int n = (int)((double)Math.min(rect.width, rect.height) * (this.tickMarkOuterRadiusPrecent_ - this.tickMarkLengthPercent_ / 5.0));
        int n2 = (int)((double)n * this.needleWidthPrecent_);
        int n3 = (int)((double)n * this.needleTailPrecent_);
        n2 = Math.max(3, n2);
        double d = (this.getRangeEnd() - this.getRangeStart()) * 0.03;
        double d2 = this.getECUParameter().getValue();
        if (d2 >= this.getRangeEnd()) {
            d2 = this.getRangeEnd();
        } else if (d2 <= this.getRangeStart()) {
            d2 = this.getRangeStart();
        }
        double d3 = this.calculateValueAngle(d2);
        Coord[] coordArray = null;
        AffineTransform affineTransform = null;
        if (this.getIncludeHighHold()) {
            if (d2 > this.highHoldValue_) {
                this.highHoldValue_ = d2;
                this.highHoldTimestamp_ = System.currentTimeMillis();
            }
            if (this.highHoldTimestamp_ < System.currentTimeMillis() - (long)this.getHighHoldDelay() * 1000L) {
                this.highHoldValue_ -= d;
                if (this.highHoldValue_ <= d2 + d / 2.0) {
                    this.highHoldValue_ = d2;
                    this.highHoldTimestamp_ = System.currentTimeMillis();
                }
            }
            coordArray = new Coord[]{new Coord(n2 / 2 * -1, n3 * -1), new Coord(n2 / 2 * -1, n), new Coord(n2 / 2, n), new Coord(n2 / 2, n3 * -1)};
            affineTransform = AffineTransform.rotateInstance(Math.toRadians(this.calculateValueAngle(this.highHoldValue_)));
            affineTransform.addTranslate(coord.x, coord.y);
            affineTransform.apply(coordArray);
            graphics.setColor(colorModel.get(304).value());
            this.fillPolygon(graphics, coordArray);
            graphics.setColor(colorModel.get(302).value());
            this.drawPolygon(graphics, coordArray);
        }
        if (this.getIncludeLowHold()) {
            if (d2 < this.lowHoldValue_) {
                this.lowHoldValue_ = d2;
                this.lowHoldTimestamp_ = System.currentTimeMillis();
            }
            if (this.lowHoldTimestamp_ < System.currentTimeMillis() - (long)this.getLowHoldDelay() * 1000L) {
                this.lowHoldValue_ += d;
                if (this.lowHoldValue_ >= d2 - d / 2.0) {
                    this.lowHoldValue_ = d2;
                    this.lowHoldTimestamp_ = System.currentTimeMillis();
                }
            }
            coordArray = new Coord[]{new Coord(n2 / 2 * -1, n3 * -1), new Coord(n2 / 2 * -1, n), new Coord(n2 / 2, n), new Coord(n2 / 2, n3 * -1)};
            affineTransform = AffineTransform.rotateInstance(Math.toRadians(this.calculateValueAngle(this.lowHoldValue_)));
            affineTransform.addTranslate(coord.x, coord.y);
            affineTransform.apply(coordArray);
            graphics.setColor(colorModel.get(305).value());
            this.fillPolygon(graphics, coordArray);
            graphics.setColor(colorModel.get(302).value());
            this.drawPolygon(graphics, coordArray);
        }
        coordArray = new Coord[]{new Coord(0, n3 * -1), new Coord(n2 * -1, 0), new Coord(n2 / 3 * -1, n), new Coord(n2 / 3, n), new Coord(n2, 0)};
        affineTransform = AffineTransform.rotateInstance(Math.toRadians(d3));
        affineTransform.addTranslate(coord.x, coord.y);
        affineTransform.apply(coordArray);
        graphics.setColor(colorModel.get(303).value());
        this.fillPolygon(graphics, coordArray);
        graphics.setColor(colorModel.get(302).value());
        this.drawPolygon(graphics, coordArray);
        if (this.getIncludeDigitalValue()) {
            int n4 = (int)((double)Math.min(rect.width, rect.height) * this.outerRingRadiusPrecent_);
            graphics.setFont(this.currentValueFont_);
            graphics.setColor(colorModel.get(302).value());
            String string = Convert.toString(this.getECUParameter().getValue(), this.getPrecision());
            graphics.drawString(string, coord.x + (int)((double)n4 * this.digitalDistanceFromPivotPercentX_), coord.y + (int)((double)n4 * this.digitalDistanceFromPivotPercentY_), this.digitalAnchor_);
        }
    }

    private Image generateStaticImage(ColorModel colorModel, Rect rect, Coord coord) {
        int n;
        double d;
        double d2;
        Image image = Image.createImage((int)rect.width, (int)rect.height);
        Graphics graphics = image.getGraphics();
        rect = new Rect(0, 0, rect.width, rect.height);
        int n2 = Math.max((int)((double)Math.min(rect.width, rect.height) * this.tickMarkLengthPercent_), 4);
        graphics.setColor(colorModel.get(200).value());
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        graphics.setColor(colorModel.get(201).value());
        graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        Font font = ProfileRenderer.findFontBestFitHeight(n2 * 2, false);
        int n3 = (int)((double)Math.min(rect.width, rect.height) * this.outerRingRadiusPrecent_);
        this.currentValueFont_ = ProfileRenderer.findFontBestFitWidth((int)((double)n3 * 0.8), Convert.toString(this.getRangeEnd(), this.getPrecision()), false);
        if (this.currentValueFont_.getHeight() > n3 / 3) {
            this.currentValueFont_ = ProfileRenderer.findFontBestFitHeight(n3 / 3, false);
        }
        graphics.setColor(colorModel.get(301).value());
        this.fillArc(graphics, coord, n3, this.ringStartAngle_, this.ringEndAngle_ - this.ringStartAngle_);
        if (this.getNormalLow() >= this.getRangeStart() && this.getNormalHigh() <= this.getRangeEnd()) {
            d2 = this.calculateValueAngle(this.getReverse() ? this.getNormalHigh() : this.getNormalLow());
            d = this.calculateValueAngle(this.getReverse() ? this.getNormalLow() : this.getNormalHigh());
            graphics.setColor(colorModel.get(306).value());
            this.fillArc(graphics, coord, n3, (int)d2, (int)(d -= d2));
        }
        if (this.getWarningLow() >= this.getRangeStart() && this.getWarningHigh() <= this.getRangeEnd()) {
            d2 = this.calculateValueAngle(this.getReverse() ? this.getWarningHigh() : this.getWarningLow());
            d = this.calculateValueAngle(this.getReverse() ? this.getWarningLow() : this.getWarningHigh());
            graphics.setColor(colorModel.get(307).value());
            this.fillArc(graphics, coord, n3, (int)d2, (int)(d -= d2));
        }
        if (this.getCriticalLow() >= this.getRangeStart() && this.getCriticalHigh() <= this.getRangeEnd()) {
            d2 = this.calculateValueAngle(this.getReverse() ? this.getCriticalHigh() : this.getCriticalLow());
            d = this.calculateValueAngle(this.getReverse() ? this.getCriticalLow() : this.getCriticalHigh());
            graphics.setColor(colorModel.get(308).value());
            this.fillArc(graphics, coord, n3, (int)d2, (int)(d -= d2));
        }
        graphics.setColor(colorModel.get(301).value());
        this.fillArc(graphics, coord, n3 - n2, this.ringStartAngle_, this.ringEndAngle_ - this.ringStartAngle_);
        graphics.setColor(colorModel.get(300).value());
        this.drawArc(graphics, coord, n3, this.ringStartAngle_, this.ringEndAngle_ - this.ringStartAngle_);
        if (this.getIncludeTicks()) {
            int n4 = (int)(Math.max(this.getRangeStart(), this.getRangeEnd()) - Math.min(this.getRangeStart(), this.getRangeEnd()));
            n4 /= this.getTickInterval();
            ++n4;
            graphics.setFont(font);
            graphics.setColor(colorModel.get(302).value());
            for (n = 0; n < n4; ++n) {
                Coord coord2 = new Coord(0, n3 - n2 / 2);
                Coord coord3 = new Coord(0, coord2.y - n2);
                Coord coord4 = new Coord(0, coord3.y - (int)((double)n2 * 1.5));
                double d3 = this.calculateValueAngle(this.getRangeStart() + (double)(this.getTickInterval() * n));
                AffineTransform affineTransform = AffineTransform.rotateInstance(Math.toRadians(d3));
                affineTransform.addTranslate(coord.x, coord.y);
                affineTransform.apply(coord2);
                affineTransform.apply(coord3);
                affineTransform.apply(coord4);
                graphics.drawLine(coord2.x, coord2.y, coord3.x, coord3.y);
                if (!this.getIncludeTickLabels() || n % this.getTickLabelInterval() != 0) continue;
                String string = Convert.toString((this.getRangeStart() + (double)(n * this.getTickInterval())) / this.getTickLabelDivisor(), this.getPrecision());
                if (this.getRangeStart() + (double)(n * this.getTickInterval()) == 0.0) {
                    string = "0";
                }
                coord4.x -= font.charsWidth(string.toCharArray(), 0, string.length()) / 2;
                coord4.y -= font.getHeight() / 2;
                graphics.drawString(string, coord4.x, coord4.y, 20);
            }
        }
        String string = this.getProperty("label");
        graphics.setFont(this.currentValueFont_);
        if (string != null) {
            graphics.setColor(colorModel.get(302).value());
            n = coord.x + (int)((double)n3 * this.labelDistanceFromPivotPercentX_);
            int n5 = coord.y + (int)((double)n3 * this.labelDistanceFromPivotPercentY_);
            graphics.drawString(string, n, n5, this.labelAnchor_);
        }
        return image;
    }
}

