/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.profile;

import com.mympgtracker.ecutracker.profile.ProfileRenderer;
import com.mympgtracker.ecutracker.profile.RenderableProfileComponent;
import com.mympgtracker.ecutracker.profile.color.ColorModel;
import com.mympgtracker.util.Rect;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class PageBar
implements RenderableProfileComponent {
    private static final int MAX_PAGES = 4;
    private int pageCount_ = 0;
    private int activePage_ = 0;
    private Rect currentRect_ = null;
    private int startingPage_ = 0;

    public int getPageCount() {
        return this.pageCount_;
    }

    public void setPageCount(int n) {
        this.pageCount_ = n;
    }

    public int getActivePage() {
        return this.activePage_;
    }

    public void setActivePage(int n) {
        this.activePage_ = n;
    }

    public int getPageIndex(int n, int n2) {
        if (this.currentRect_.contains(n, n2)) {
            return n / (this.currentRect_.width / this.pageCount_);
        }
        return -1;
    }

    public void render(Graphics graphics, Rect rect, ColorModel colorModel) throws Exception {
        this.currentRect_ = rect;
        Font font = ProfileRenderer.findFontBestFitHeight(rect.height - 2, false);
        graphics.setFont(font);
        graphics.setColor(colorModel.get(101).value());
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        if (this.pageCount_ > 0) {
            int n = Math.min(this.pageCount_, 4);
            int n2 = rect.width / n;
            if (this.startingPage_ > this.activePage_) {
                this.startingPage_ = this.activePage_;
            }
            if (this.startingPage_ <= this.activePage_ - n) {
                this.startingPage_ = this.activePage_ - n + 1;
            }
            int n3 = this.startingPage_;
            for (int i = 0; i < n; ++i) {
                int n4 = rect.x + i * n2;
                if (++n3 - 1 == this.activePage_) {
                    if (i == n - 1) {
                        n2 = rect.width - n4;
                    }
                    graphics.setColor(colorModel.get(100).value());
                    graphics.fillRect(n4, rect.y, n2, rect.height);
                    graphics.setColor(colorModel.get(102).value());
                } else {
                    graphics.setColor(colorModel.get(103).value());
                }
                String string = "" + n3;
                if (i == n - 1 && n < this.pageCount_ && n3 != this.pageCount_) {
                    string = string + " >";
                }
                if (i == 0 && n3 != 1) {
                    string = "< " + string;
                }
                graphics.drawString(string, n4 + n2 / 2, rect.y + rect.height, 33);
                if (i <= 0) continue;
                graphics.setColor(colorModel.get(201).value());
                graphics.drawLine(n4, rect.y, n4, rect.y + rect.height);
            }
        }
        graphics.setColor(colorModel.get(201).value());
        graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
    }
}

