/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.menu;

import com.mympgtracker.ecutracker.profile.RenderableProfileComponent;
import com.mympgtracker.ecutracker.profile.color.ColorModel;
import com.mympgtracker.ecutracker.profile.text.TTFTextRenderer;
import com.mympgtracker.ecutracker.profile.text.TextRendererCache;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Rect;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class MenuRenderer
implements Cleanable,
RenderableProfileComponent {
    private static final double ITEM_WIDTH = 0.9;
    private int selectedMenuItem_ = 0;
    private Vector menuItems_ = new Vector();
    private int longestMenuItem_ = 0;

    public void addItem(String string) {
        this.menuItems_.addElement(string);
        this.longestMenuItem_ = Math.max(this.longestMenuItem_, string.length());
    }

    public Vector getItems() {
        return this.menuItems_;
    }

    public void selectUp() {
        this.selectedMenuItem_ = Math.max(0, this.selectedMenuItem_ - 1);
    }

    public void selectDown() {
        this.selectedMenuItem_ = Math.min(this.menuItems_.size() - 1, this.selectedMenuItem_ + 1);
    }

    public int getSelected() {
        return this.selectedMenuItem_;
    }

    public void cleanYourRoom() {
        this.menuItems_ = null;
    }

    public void render(Graphics graphics, Rect rect, ColorModel colorModel) throws Exception {
        int n = (int)((double)rect.width * 0.9);
        int n2 = n / this.longestMenuItem_;
        n2 = n2 / 3 * 4;
        int n3 = n2 + (int)((double)n2 * 0.15);
        int n4 = (rect.width - n) / 2;
        int n5 = (rect.height - n3 * this.menuItems_.size()) / (this.menuItems_.size() + 1);
        int n6 = n5 + n5 / 2;
        n5 -= n5 / (this.menuItems_.size() - 1);
        for (int i = 0; i < this.menuItems_.size(); ++i) {
            boolean bl = i == this.selectedMenuItem_;
            graphics.setColor(colorModel.get(603).value());
            graphics.fillRect(n4 + n5 / 4, n6 + n5 / 4, n, n3);
            graphics.setColor(colorModel.get(bl ? 611 : 601).value());
            graphics.fillRect(n4, n6, n, n3);
            graphics.setColor(colorModel.get(bl ? 610 : 600).value());
            graphics.drawRect(n4, n6, n, n3);
            String string = TTFTextRenderer.generateKey("bombardier.ttf", n2, colorModel.get(bl ? 612 : 602));
            TTFTextRenderer tTFTextRenderer = (TTFTextRenderer)TextRendererCache.get(string);
            if (tTFTextRenderer == null) {
                tTFTextRenderer = new TTFTextRenderer("bombardier.ttf", n2, colorModel.get(bl ? 612 : 602));
                TextRendererCache.put(string, tTFTextRenderer);
            }
            tTFTextRenderer.drawText(graphics, this.menuItems_.elementAt(i).toString(), n4 + n / 2, n6 + n3 / 2, true, true);
            n6 += n3 + n5;
        }
    }
}

