/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.param;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.MultiParamMetaParameter;
import com.mympgtracker.ecutracker.ecu.param.ValueChangedListener;
import com.mympgtracker.util.CummulativeAverageDouble;

public class LPKAverageMetaParam
extends MultiParamMetaParameter {
    private CummulativeAverageDouble lph_avg = new CummulativeAverageDouble();
    private CummulativeAverageDouble kph_avg = new CummulativeAverageDouble();
    private int limit;
    private static final int LPH_NDX = 0;
    private static final int KPH_NDX = 1;

    public LPKAverageMetaParam(String string, ECUParameter eCUParameter, ECUParameter eCUParameter2, int n) {
        super(string, new ECUParameter[]{eCUParameter, eCUParameter2});
        this.limit = n;
        eCUParameter.addValueChangedListener(new ValueChangedListener(){

            public void onValueChanged(ECUParameter eCUParameter) {
                LPKAverageMetaParam.this.lph_avg.add(eCUParameter.getValue());
                if (LPKAverageMetaParam.this.limit > 0 && LPKAverageMetaParam.this.lph_avg.getCount() > (double)LPKAverageMetaParam.this.limit) {
                    double d = LPKAverageMetaParam.this.lph_avg.getAverage();
                    LPKAverageMetaParam.this.lph_avg = new CummulativeAverageDouble();
                    LPKAverageMetaParam.this.lph_avg.add(d);
                }
            }
        });
        eCUParameter2.addValueChangedListener(new ValueChangedListener(){

            public void onValueChanged(ECUParameter eCUParameter) {
                LPKAverageMetaParam.this.kph_avg.add(eCUParameter.getValue());
                if (LPKAverageMetaParam.this.limit > 0 && LPKAverageMetaParam.this.kph_avg.getCount() > (double)LPKAverageMetaParam.this.limit) {
                    double d = LPKAverageMetaParam.this.kph_avg.getAverage();
                    LPKAverageMetaParam.this.kph_avg = new CummulativeAverageDouble();
                    LPKAverageMetaParam.this.kph_avg.add(d);
                }
            }
        });
    }

    public double getValue() {
        if (this.kph_avg.getAverage() != 0.0) {
            return this.lph_avg.getAverage() / this.kph_avg.getAverage() * 100.0;
        }
        return -1.0;
    }
}

