/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.param;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.MultiParamMetaParameter;
import com.mympgtracker.util.Convert;

public class LPHInjectorPWMetaParam
extends MultiParamMetaParameter {
    private static final int RPM_NDX = 0;
    private static final int INJECTOR_NDX = 1;
    private double injectorFlowLPS_ = 230.0;
    private int cylinders_ = 4;

    public LPHInjectorPWMetaParam(String string, ECUParameter eCUParameter, ECUParameter eCUParameter2) {
        super(string, new ECUParameter[]{eCUParameter, eCUParameter2});
    }

    public void setExtraValue(String string, String string2) {
        if ("engine-no-cyls".equals(string)) {
            this.cylinders_ = Convert.toInt(string2);
        }
        if ("injector-ccpm".equals(string)) {
            this.injectorFlowLPS_ = Convert.toDouble(string2);
        }
    }

    public double getValue() {
        if (this.params_[0].getValue() != 0.0) {
            return LPHInjectorPWMetaParam.calculateLPH(this.params_[0].getValue(), this.params_[1].getValue(), this.injectorFlowLPS_, this.cylinders_);
        }
        return 0.0;
    }

    public static double calculateLPH(double d, double d2, double d3, int n) {
        return LPHInjectorPWMetaParam.calculateLitersPerSec(d, d2, d3, n) * 3600.0;
    }

    public static double calculateLitersPerSec(double d, double d2, double d3, int n) {
        return d / 60.0 * (double)n * d2 * 0.001 * d3 / 60.0 / 1000.0;
    }
}

