/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.param;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.MultiParamMetaParameter;
import com.mympgtracker.ecutracker.ecu.param.StaticParameter;

public class LPH1MetaParam
extends MultiParamMetaParameter {
    private static final int MAF_NDX = 0;
    private static final int AF_NDX = 1;

    public LPH1MetaParam(String string, ECUParameter eCUParameter, double d) {
        this(string, eCUParameter, new StaticParameter(d));
    }

    public LPH1MetaParam(String string, ECUParameter eCUParameter, ECUParameter eCUParameter2) {
        super(string, new ECUParameter[]{eCUParameter, eCUParameter2});
    }

    public double getValue() {
        double d = this.params_[0].getValue();
        double d2 = this.params_[1].getValue();
        return LPH1MetaParam.calculateLPH(d, d2);
    }

    public static double calculateLPH(double d, double d2) {
        return 3600.0 * LPH1MetaParam.calculateLitersPerSec(d, d2);
    }

    public static double calculateLitersPerSec(double d, double d2) {
        return d / (d2 * 454.0 * 6.17 / 3.78);
    }
}

