/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.param;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.LPHInjectorPWMetaParam;
import com.mympgtracker.ecutracker.ecu.param.MultiParamMetaParameter;
import com.mympgtracker.ecutracker.ecu.param.ValueChangedListener;
import com.mympgtracker.util.Convert;

public class FuelConsumedMetaParam
extends MultiParamMetaParameter {
    private static final int RPM_NDX = 0;
    private static final int INJECTOR_NDX = 1;
    protected static final long MAX_TIME_GAP = 30000L;
    private double injectorFlow_ = 230.0;
    private int cylinders_ = 4;
    private double fuelConsumed = 0.0;

    public FuelConsumedMetaParam(String string, ECUParameter eCUParameter, ECUParameter eCUParameter2) {
        super(string, new ECUParameter[]{eCUParameter, eCUParameter2});
        eCUParameter2.addValueChangedListener(new ValueChangedListener(){
            private long lastTimeStamp = 0L;

            public void onValueChanged(ECUParameter eCUParameter) {
                double d = eCUParameter.getValue();
                double d2 = FuelConsumedMetaParam.this.params_[0].getValue();
                long l = eCUParameter.getTimeStamp();
                if (this.lastTimeStamp == 0L || l - this.lastTimeStamp > 30000L) {
                    this.lastTimeStamp = l - 5000L;
                }
                FuelConsumedMetaParam.this.fuelConsumed += LPHInjectorPWMetaParam.calculateLitersPerSec(d2, d, FuelConsumedMetaParam.this.injectorFlow_, FuelConsumedMetaParam.this.cylinders_) * (double)(l - this.lastTimeStamp);
                this.lastTimeStamp = l;
            }
        });
    }

    public void setExtraValue(String string, String string2) {
        if ("engine-no-cyls".equals(string)) {
            this.cylinders_ = Convert.toInt(string2);
        }
        if ("injector-ccpm".equals(string)) {
            this.injectorFlow_ = Convert.toDouble(string2);
        }
    }

    public double getValue() {
        return this.fuelConsumed;
    }
}

