/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.param;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.LPH1MetaParam;
import com.mympgtracker.ecutracker.ecu.param.MultiParamMetaParameter;
import com.mympgtracker.ecutracker.ecu.param.StaticParameter;
import com.mympgtracker.ecutracker.ecu.param.ValueChangedListener;

public class FuelConsumedMAFMetaParam
extends MultiParamMetaParameter {
    protected static final long MAX_TIME_GAP = 30000L;
    private static final int MAF_NDX = 0;
    private static final int AF_NDX = 1;
    private double fuelConsumed = 0.0;

    public FuelConsumedMAFMetaParam(String string, ECUParameter eCUParameter, double d) {
        this(string, eCUParameter, new StaticParameter(d));
    }

    public FuelConsumedMAFMetaParam(String string, ECUParameter eCUParameter, ECUParameter eCUParameter2) {
        super(string, new ECUParameter[]{eCUParameter, eCUParameter2});
        eCUParameter.addValueChangedListener(new ValueChangedListener(){
            private long lastTimeStamp = 0L;

            public void onValueChanged(ECUParameter eCUParameter) {
                double d = eCUParameter.getValue();
                long l = eCUParameter.getTimeStamp();
                if (this.lastTimeStamp == 0L || l - this.lastTimeStamp > 30000L) {
                    this.lastTimeStamp = l - 5000L;
                }
                FuelConsumedMAFMetaParam.this.fuelConsumed += LPH1MetaParam.calculateLitersPerSec(d, FuelConsumedMAFMetaParam.this.params_[1].getValue()) * 1000.0 * (double)(l - this.lastTimeStamp) / 1000.0;
                this.lastTimeStamp = l;
            }
        });
    }

    public double getValue() {
        return this.fuelConsumed;
    }
}

