/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.param;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.OneParamMetaParameter;
import com.mympgtracker.ecutracker.ecu.param.ValueChangedListener;

public class DistanceRunMetaParam
extends OneParamMetaParameter {
    protected static final long MAX_TIME_GAP = 30000L;
    private double distanceRun = 0.0;

    public DistanceRunMetaParam(String string, ECUParameter eCUParameter) {
        super(string, eCUParameter);
        eCUParameter.addValueChangedListener(new ValueChangedListener(){
            private long lastTimeStamp = 0L;

            public void onValueChanged(ECUParameter eCUParameter) {
                double d = eCUParameter.getValue();
                long l = eCUParameter.getTimeStamp();
                if (this.lastTimeStamp == 0L || l - this.lastTimeStamp > 30000L) {
                    this.lastTimeStamp = l - 5000L;
                }
                DistanceRunMetaParam.this.distanceRun += d * 1000.0 / 3600.0 * (double)(l - this.lastTimeStamp) / 1000.0;
                this.lastTimeStamp = l;
            }
        });
    }

    public double getValue() {
        return this.distanceRun;
    }
}

