/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.comm.SSM;

import com.mympgtracker.util.Convert;
import java.io.IOException;
import java.io.OutputStream;

public class SSMPacket {
    public static final int MAX_DATA_LENGTH = 128;
    private byte[] header_ = null;
    private int dataLength_ = 0;
    private byte[] data_ = new byte[128];
    private byte checkSum_ = 0;

    public byte[] getHeader() {
        return this.header_;
    }

    public void setHeader(byte[] byArray) {
        this.header_ = byArray;
    }

    public int getDataLength() {
        return this.dataLength_;
    }

    public void setDataLength(byte by) {
        this.setDataLength(Convert.unsignedByteToInt(by));
    }

    public void setDataLength(int n) {
        if (n > 128) {
            throw new RuntimeException("Maximum of [128] data bytes exceeded in RS232 Packet. [" + n + "]");
        }
        this.dataLength_ = n;
    }

    public byte[] getData() {
        return this.data_;
    }

    public void addDataByte(byte by) {
        if (this.dataLength_ == 128) {
            throw new RuntimeException("Cannot add data byte. Data Array already at MAX [" + this.dataLength_ + "]");
        }
        this.data_[this.dataLength_] = by;
        ++this.dataLength_;
    }

    public void addDataBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.addDataByte(byArray[i]);
        }
    }

    public byte getCheckSum() {
        return this.checkSum_;
    }

    public void setCheckSum(byte by) {
        this.checkSum_ = by;
    }

    public void setCheckSum() {
        this.checkSum_ = this.calcCheckSum();
    }

    public byte calcCheckSum() {
        byte by = Convert.calcCheckSum(this.header_);
        by = (byte)(by + (byte)this.dataLength_);
        by = (byte)(by + Convert.calcCheckSum(this.data_));
        return by;
    }

    public int length() {
        return this.header_.length + 1 + this.dataLength_ + 1;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getHeader());
        outputStream.write((byte)this.getDataLength());
        outputStream.write(this.getData(), 0, this.getDataLength());
        outputStream.write(this.getCheckSum());
    }

    public String toString() {
        String string = "";
        string = "\nSSMPacket";
        string = string + "\nH: " + Convert.bytesToString(this.getHeader());
        string = string + "\nL: " + this.getDataLength();
        string = string + "\nD: " + Convert.bytesToString(this.getData(), 0, this.getDataLength());
        string = string + "\nC: " + Convert.unsignedByteToInt(this.getCheckSum());
        return string;
    }
}

