/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.comm.SSM;

import com.mympgtracker.ecutracker.ecu.comm.AbstractProtocolHandler;
import com.mympgtracker.ecutracker.ecu.comm.SSM.SSMPacket;
import com.mympgtracker.ecutracker.ecu.comm.SSM.SSMParameter;
import com.mympgtracker.ecutracker.ecu.param.BitCheckMetaParam;
import com.mympgtracker.ecutracker.ecu.param.DegCelToDegFarMetaParam;
import com.mympgtracker.ecutracker.ecu.param.DegCelToDegKelvinMetaParam;
import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.LambdaToAirFuel;
import com.mympgtracker.ecutracker.ecu.param.ParameterRegistry;
import com.mympgtracker.ecutracker.ecu.param.PsiToInhgPsiMetaParam;
import com.mympgtracker.ecutracker.ecu.param.PsiToKpaMetaParam;
import com.mympgtracker.ecutracker.ecu.param.TwoParamMetaParameter;
import com.mympgtracker.util.Convert;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.TrackerException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.StreamConnection;

public class SSMOBD2ProtocolHandler
extends AbstractProtocolHandler {
    private static final int THREAD_NOT_CONNECTED_SLEEP_TIME = 25;
    private static final int READ_TIMEOUT = 1000;
    private static final int READ_SLEEP_TIME = 10;
    private static final int MAX_PACKET_FAILURES = 3;
    private static final int SSM_OBD2_ADDRESS_SIZE = 3;
    private static final int SSM_HEADER_LEN = 3;
    private static final int MAX_PARAMS_PER_PACKET = 41;
    private static final String LOW_SUFFIX = "_L";
    private static final String HIGH_SUFFIX = "_H";
    private String ecuId_ = null;
    private static final String PNAME_BIT_BLOCK_2 = "__BIT_BLOCK_2";
    private static final byte SSM_READ_COMMAND = -88;
    private static final byte SSM_WRITE_COMMAND = -72;
    private static final byte SSM_DEVICE_ECU = 16;
    private static final byte SSM_DEVICE_APP = -16;
    private static final byte[] HEADER_PROTOCOL_INIT = new byte[]{-128, 16, -16};
    private static final byte PROTOCOL_INIT_DATA = -65;
    private static final byte[] ADDRESS_RESET_ECU = new byte[]{0, 0, 96};
    private static final byte[] ADDRESS_IGNITION_RETARD = new byte[]{0, 0, 111};
    private static final byte[] ADDRESS_IDLE_SPEED_ADJUST_NORMAL = new byte[]{0, 0, 112};
    private static final byte[] ADDRESS_IDLE_SPEED_ADJUST_AIRCON = new byte[]{0, 0, 113};
    public static final int SSM_BAUD = 4800;
    public static final int SSM_DATA_BITS = 8;
    public static final String SSM_PARITY = "none";
    public static final int SSM_STOP_BITS = 1;
    private StreamConnection streamConnection_ = null;
    private InputStream inputStream_ = null;
    private OutputStream outputStram_ = null;
    static /* synthetic */ Class class$com$mympgtracker$ecutracker$ecu$comm$SSM$SSMParameter;

    public SSMOBD2ProtocolHandler() throws Exception {
        super(SSMOBD2ProtocolHandler.generateParameterRegistry());
    }

    public void cleanYourRoom() {
        this.inputStream_ = null;
        this.outputStram_ = null;
        this.streamConnection_ = null;
        super.cleanYourRoom();
    }

    private void initProtocol() throws Exception {
        this.fireEventProtocolConnecting();
        this.streamConnection_ = this.openStreamConnection(4800, 8, SSM_PARITY, 1);
        if (this.streamConnection_ == null) {
            throw new TrackerException(this, "initProtocol", "open port", Lang.get("protocol.status.init.failure"));
        }
        this.inputStream_ = this.streamConnection_.openInputStream();
        this.outputStram_ = this.streamConnection_.openOutputStream();
        this.fireEventInitStarted();
        this.fireEventInitStatus(Lang.get("protocol.ssm.status.init"));
        SSMPacket sSMPacket = new SSMPacket();
        sSMPacket.setHeader(HEADER_PROTOCOL_INIT);
        sSMPacket.addDataByte((byte)-65);
        sSMPacket.setCheckSum();
        Thread.sleep(10L);
        this.inputStream_.skip(this.inputStream_.available());
        SSMPacket sSMPacket2 = null;
        try {
            sSMPacket2 = this.sendPacket(sSMPacket);
        }
        catch (Exception exception) {
            this.fireEventInitStatus(Lang.get("protocol.ssm.status.reinit"));
            Thread.sleep(10L);
            this.inputStream_.skip(this.inputStream_.available());
            sSMPacket2 = this.sendPacket(sSMPacket);
        }
        if (sSMPacket2.getHeader().length != 3) {
            throw new Exception("Init RX packet did not return the expected header\nExpected: " + Convert.bytesToString(sSMPacket.getHeader()) + sSMPacket.getDataLength() + " " + Convert.bytesToString(sSMPacket.getData()) + " " + sSMPacket.getCheckSum() + " 0x80 0xf0 0x10\n" + "Received: " + Convert.bytesToString(sSMPacket2.getHeader()));
        }
        this.ecuId_ = "x" + Convert.unsignedByteToInt(sSMPacket2.getData()[1]);
        this.ecuId_ = this.ecuId_ + "x" + Convert.unsignedByteToInt(sSMPacket2.getData()[2]);
        this.ecuId_ = this.ecuId_ + "x" + Convert.unsignedByteToInt(sSMPacket2.getData()[3]);
        this.ecuId_ = this.ecuId_ + "x" + Convert.unsignedByteToInt(sSMPacket2.getData()[4]);
        this.ecuId_ = this.ecuId_ + "x" + Convert.unsignedByteToInt(sSMPacket2.getData()[5]);
        this.ecuId_ = this.ecuId_ + "x" + Convert.unsignedByteToInt(sSMPacket2.getData()[6]);
        this.ecuId_ = this.ecuId_ + "x" + Convert.unsignedByteToInt(sSMPacket2.getData()[7]);
        this.ecuId_ = this.ecuId_ + "x" + Convert.unsignedByteToInt(sSMPacket2.getData()[8]);
        Log.info(this, "ECUID: " + this.ecuId_);
        this.fireEventInitFinished();
    }

    public void run() {
        boolean bl = false;
        while (!this.getTerminate() || this.streamConnection_ != null) {
            try {
                Object object;
                int n;
                if (this.streamConnection_ != null && !this.getConnect()) {
                    if (this.inputStream_ != null) {
                        this.inputStream_.close();
                        this.inputStream_ = null;
                    }
                    if (this.outputStram_ != null) {
                        this.outputStram_.close();
                        this.outputStram_ = null;
                    }
                    if (this.streamConnection_ != null) {
                        this.streamConnection_.close();
                        this.streamConnection_ = null;
                    }
                    if (!bl) {
                        this.fireEventProtocolDisconnected();
                    }
                }
                if (this.streamConnection_ == null && this.getConnect()) {
                    bl = false;
                    this.initProtocol();
                }
                if (this.streamConnection_ == null) {
                    Thread.sleep(25L);
                    continue;
                }
                Vector<Object> vector = new Vector<Object>(5);
                for (n = 0; n < this.getParameterRegistry().size(); ++n) {
                    object = this.getParameterRegistry().get(n);
                    if (!((ECUParameter)object).areValueConsumersReady() || !(class$com$mympgtracker$ecutracker$ecu$comm$SSM$SSMParameter == null ? SSMOBD2ProtocolHandler.class$("com.mympgtracker.ecutracker.ecu.comm.SSM.SSMParameter") : class$com$mympgtracker$ecutracker$ecu$comm$SSM$SSMParameter).isInstance(object)) continue;
                    vector.addElement(object);
                }
                for (n = 0; n < vector.size(); n += 41) {
                    object = new Vector();
                    for (int i = n; i < vector.size() && i < n + 41; ++i) {
                        ((Vector)object).addElement(vector.elementAt(i));
                    }
                    SSMPacket sSMPacket = this.createTxPacket((Vector)object, true);
                    int n2 = 0;
                    while (n2 < 3) {
                        try {
                            SSMPacket sSMPacket2 = this.sendPacket(sSMPacket);
                            this.distributeResult(vector, sSMPacket2);
                            n2 = 3;
                        }
                        catch (Exception exception) {
                            if (++n2 < 3) continue;
                            throw new TrackerException(this, "run", "sendPacket", Lang.get("protocol.ssm.status.send_fail"));
                        }
                    }
                }
            }
            catch (Exception exception) {
                this.disconnect();
                bl = true;
                this.fireEventInitStatus(Lang.get("protocol.status.error") + " " + exception.getMessage());
                Log.error(this, "msg[" + exception.getMessage() + "]", exception);
            }
        }
        this.fireEventProtocolDisconnected();
    }

    public String getEcuInfo() throws Exception {
        return "SSP Monitor:\nECUID: " + this.ecuId_;
    }

    private SSMPacket sendPacket(SSMPacket sSMPacket) throws TrackerException {
        try {
            if (this.inputStream_.available() != 0) {
                Thread.sleep(100L);
                this.readBytes(this.inputStream_, this.inputStream_.available());
            }
            sSMPacket.write(this.outputStram_);
            this.outputStram_.flush();
            if (!this.waitForData(this.inputStream_, sSMPacket.length(), 1000L)) {
                byte[] byArray = this.readBytes(this.inputStream_, this.inputStream_.available());
                Log.debug(this, "TimedOut[" + sSMPacket.length() + "]: " + Convert.bytesToString(byArray));
                throw new TrackerException(this, "sendPacket", Lang.get("protocol.status.timeout"));
            }
            Object object = this.readBytes(this.inputStream_, sSMPacket.length());
            object = new SSMPacket();
            ((SSMPacket)object).setHeader(this.readBytes(this.inputStream_, 3));
            byte by = this.readBytes(this.inputStream_, 1)[0];
            ((SSMPacket)object).addDataBytes(this.readBytes(this.inputStream_, by));
            if (((SSMPacket)object).getDataLength() != by) {
                throw new TrackerException(this, "sendPacket", "Retreived Data length error [" + ((SSMPacket)object).getDataLength() + "] != [" + by + "]");
            }
            ((SSMPacket)object).setCheckSum(this.readBytes(this.inputStream_, 1)[0]);
            byte by2 = ((SSMPacket)object).calcCheckSum();
            if (by2 != ((SSMPacket)object).getCheckSum()) {
                throw new TrackerException(this, "sendPacket", "RX packet checksum != expected value.  expected[" + by2 + "]" + " got[" + ((SSMPacket)object).getCheckSum() + "]\n" + object);
            }
            return object;
        }
        catch (Exception exception) {
            throw new TrackerException(this, "sendPacket", exception.getMessage());
        }
    }

    private void distributeResult(Vector vector, SSMPacket sSMPacket) {
        ECUParameter[] eCUParameterArray = new ECUParameter[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            SSMParameter sSMParameter = (SSMParameter)vector.elementAt(i);
            sSMParameter.setValue(sSMPacket.getData()[i + 1]);
            sSMParameter.fireValueChanged();
            eCUParameterArray[i] = sSMParameter;
        }
        this.fireEventParametersFetched(eCUParameterArray);
    }

    protected byte[] readBytes(InputStream inputStream, int n) throws Exception {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            inputStream.read(byArray, i, 1);
        }
        return byArray;
    }

    private SSMPacket createTxPacket(Vector vector, boolean bl) {
        SSMPacket sSMPacket = new SSMPacket();
        sSMPacket.setHeader(new byte[]{-128, 16, -16});
        if (bl) {
            sSMPacket.addDataByte((byte)-88);
        } else {
            sSMPacket.addDataByte((byte)-72);
        }
        sSMPacket.addDataByte((byte)0);
        for (int i = 0; i < vector.size(); ++i) {
            SSMParameter sSMParameter = (SSMParameter)vector.elementAt(i);
            if (sSMParameter.getAddress().length != 3) {
                throw new RuntimeException("This SSM Protocol allows for ONLY 3 address bytes.  Parameter " + sSMParameter.getName() + " has " + sSMParameter.getAddress());
            }
            for (int j = 0; j < sSMParameter.getAddress().length; ++j) {
                sSMPacket.addDataByte(sSMParameter.getAddress()[j]);
            }
        }
        sSMPacket.setCheckSum();
        return sSMPacket;
    }

    private boolean waitForData(InputStream inputStream, int n, long l) throws Exception {
        long l2 = System.currentTimeMillis();
        while (inputStream.available() < n) {
            if (System.currentTimeMillis() - l2 > l) {
                return false;
            }
            Thread.sleep(10L);
        }
        return true;
    }

    private static ParameterRegistry generateParameterRegistry() throws Exception {
        ParameterRegistry parameterRegistry = new ParameterRegistry();
        parameterRegistry.add(new SSMParameter("LOAD", new byte[]{0, 0, 7}){

            public double getValue() {
                return super.getValue() * 100.0 / 255.0;
            }
        });
        parameterRegistry.add(new SSMParameter("COOLANT_TEMP_C", new byte[]{0, 0, 8}){

            public double getValue() {
                return super.getValue() - 40.0;
            }
        });
        parameterRegistry.add(new DegCelToDegFarMetaParam("COOLANT_TEMP_F", parameterRegistry.get("COOLANT_TEMP_C")));
        parameterRegistry.add(new SSMParameter("STFT1", new byte[]{0, 0, 9}){

            public double getValue() {
                return (super.getValue() - 128.0) / 1.28;
            }
        });
        parameterRegistry.add(new SSMParameter("LTFT1", new byte[]{0, 0, 10}){

            public double getValue() {
                return (super.getValue() - 128.0) / 1.28;
            }
        });
        parameterRegistry.add(new SSMParameter("BATTERY_VOLTS", new byte[]{0, 0, 12}){

            public double getValue() {
                return super.getValue() * 0.08;
            }
        });
        parameterRegistry.add(new SSMParameter("MAP_PSI", new byte[]{0, 0, 13}){

            public double getValue() {
                return super.getValue() * 37.0 / 255.0;
            }
        });
        parameterRegistry.add(new PsiToKpaMetaParam("MAP_KPA", parameterRegistry.get("MAP_PSI")));
        parameterRegistry.add(new SSMParameter("RPM_H", new byte[]{0, 0, 14}));
        parameterRegistry.add(new SSMParameter("RPM_L", new byte[]{0, 0, 15}));
        parameterRegistry.add(new TwoParamMetaParameter("RPM", parameterRegistry.get("RPM_H"), parameterRegistry.get("RPM_L")){

            public double getValue() {
                return (double)(((int)this.getP1().getValue() << 8) + (int)this.getP2().getValue()) / 4.0;
            }
        });
        parameterRegistry.add(new SSMParameter("KPH", new byte[]{0, 0, 16}));
        parameterRegistry.add(new SSMParameter("IG_TIMING", new byte[]{0, 0, 17}){

            public double getValue() {
                return (super.getValue() - 128.0) / 2.0;
            }
        });
        parameterRegistry.add(new SSMParameter("INTAKE_TEMP_C", new byte[]{0, 0, 18}){

            public double getValue() {
                return super.getValue() - 40.0;
            }
        });
        parameterRegistry.add(new DegCelToDegFarMetaParam("INTAKE_TEMP_F", parameterRegistry.get("INTAKE_TEMP_C")));
        parameterRegistry.add(new DegCelToDegKelvinMetaParam("INTAKE_TEMP_K", parameterRegistry.get("INTAKE_TEMP_C")));
        parameterRegistry.add(new SSMParameter("MAF_H", new byte[]{0, 0, 19}));
        parameterRegistry.add(new SSMParameter("MAF_L", new byte[]{0, 0, 20}));
        parameterRegistry.add(new SSMParameter("TPS", new byte[]{0, 0, 21}){

            public double getValue() {
                return super.getValue() * 100.0 / 255.0;
            }
        });
        parameterRegistry.add(new SSMParameter("FRONT_O2V_1_H", new byte[]{0, 0, 22}));
        parameterRegistry.add(new SSMParameter("FRONT_O2V_1_L", new byte[]{0, 0, 23}));
        parameterRegistry.add(new TwoParamMetaParameter("FRONT_O2V_1", parameterRegistry.get("FRONT_O2V_1_H"), parameterRegistry.get("FRONT_O2V_1_L")){

            public double getValue() {
                return (double)(((int)this.getP1().getValue() << 8) + (int)this.getP2().getValue()) * 0.005;
            }
        });
        parameterRegistry.add(new SSMParameter("REAR_O2V_1_H", new byte[]{0, 0, 24}));
        parameterRegistry.add(new SSMParameter("REAR_O2V_1_L", new byte[]{0, 0, 25}));
        parameterRegistry.add(new TwoParamMetaParameter("REAR_O2V_1", parameterRegistry.get("REAR_O2V_1_H"), parameterRegistry.get("REAR_O2V_1_L")){

            public double getValue() {
                return (double)(((int)this.getP1().getValue() << 8) + (int)this.getP2().getValue()) * 0.005;
            }
        });
        parameterRegistry.add(new SSMParameter("FRONT_O2V_2_H", new byte[]{0, 0, 26}));
        parameterRegistry.add(new SSMParameter("FRONT_O2V_2_L", new byte[]{0, 0, 27}));
        parameterRegistry.add(new TwoParamMetaParameter("REAR_O2V_1", parameterRegistry.get("FRONT_O2V_2_H"), parameterRegistry.get("FRONT_O2V_2_L")){

            public double getValue() {
                return (double)(((int)this.getP1().getValue() << 8) + (int)this.getP2().getValue()) * 0.005;
            }
        });
        parameterRegistry.add(new SSMParameter("KNOCK_COR", new byte[]{0, 0, 34}){

            public double getValue() {
                return (super.getValue() - 128.0) / 2.0;
            }
        });
        parameterRegistry.add(new SSMParameter("VAC_BOOST_PSI", new byte[]{0, 0, 36}){

            public double getValue() {
                return (super.getValue() - 128.0) * 37.0 / 255.0;
            }
        });
        parameterRegistry.add(new PsiToInhgPsiMetaParam("VAC_BOOST_INHG_PSI", parameterRegistry.get("VAC_BOOST_PSI")));
        parameterRegistry.add(new TwoParamMetaParameter("MAF", parameterRegistry.get("MAF_H"), parameterRegistry.get("MAF_L")){

            public double getValue() {
                return (double)(((int)this.getP1().getValue() << 8) + (int)this.getP2().getValue()) / 100.0;
            }
        });
        parameterRegistry.add(new SSMParameter("IAC_STEP", new byte[]{0, 0, 56}){

            public double getValue() {
                return super.getValue();
            }
        });
        parameterRegistry.add(new SSMParameter("LAMBDA1", new byte[]{0, 0, 70}){

            public double getValue() {
                return super.getValue() / 128.0;
            }
        });
        parameterRegistry.add(new LambdaToAirFuel("AF1_GAS", LambdaToAirFuel.AF_STOICH_GAS, parameterRegistry.get("LAMBDA1")));
        parameterRegistry.add(new LambdaToAirFuel("AF1_E85", LambdaToAirFuel.AF_STOICH_E85, parameterRegistry.get("LAMBDA1")));
        parameterRegistry.add(new LambdaToAirFuel("AF1_DIESEL", LambdaToAirFuel.AF_STOICH_DIESEL, parameterRegistry.get("LAMBDA1")));
        parameterRegistry.add(new SSMParameter(PNAME_BIT_BLOCK_2, new byte[]{0, 0, 99}));
        parameterRegistry.add(new BitCheckMetaParam("KNOCK_1", parameterRegistry.get(PNAME_BIT_BLOCK_2), 4));
        parameterRegistry.add(new BitCheckMetaParam("KNOCK_2", parameterRegistry.get(PNAME_BIT_BLOCK_2), 2));
        parameterRegistry.add(new SSMParameter("IDLE_ADJUST_NORMAL", ADDRESS_IDLE_SPEED_ADJUST_NORMAL){

            public double getValue() {
                return (super.getValue() - 128.0) * 25.0;
            }
        });
        parameterRegistry.add(new SSMParameter("IDLE_ADJUST_AIRCON", ADDRESS_IDLE_SPEED_ADJUST_AIRCON){

            public double getValue() {
                return (super.getValue() - 128.0) * 25.0;
            }
        });
        AbstractProtocolHandler.addVMafParameter(parameterRegistry);
        AbstractProtocolHandler.addMPG1aParameters(parameterRegistry);
        AbstractProtocolHandler.addMPG1bParameters(parameterRegistry);
        AbstractProtocolHandler.addMPG1cParameters(parameterRegistry);
        AbstractProtocolHandler.addMPG1dParameters(parameterRegistry);
        return parameterRegistry;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

