/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.comm.ELM;

import com.mympgtracker.ecutracker.ecu.comm.AbstractProtocolHandler;
import com.mympgtracker.ecutracker.ecu.comm.ELM.ELMDTCParameter;
import com.mympgtracker.ecutracker.ecu.comm.ELM.ELMParameter;
import com.mympgtracker.ecutracker.ecu.param.BitCheckMetaParam;
import com.mympgtracker.ecutracker.ecu.param.DegCelToDegFarMetaParam;
import com.mympgtracker.ecutracker.ecu.param.DegCelToDegKelvinMetaParam;
import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.KpaToInHgMetaParam;
import com.mympgtracker.ecutracker.ecu.param.KpaToPsiMetaParam;
import com.mympgtracker.ecutracker.ecu.param.KphToMphMetaParam;
import com.mympgtracker.ecutracker.ecu.param.OneParamMetaParameter;
import com.mympgtracker.ecutracker.ecu.param.ParameterRegistry;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.TrackerException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.StreamConnection;

public class ELMProtocolHandler
extends AbstractProtocolHandler {
    private static final int SLEEP_TIME_IN_MS = 25;
    private static final int TIMEOUT_INIT_MS = 35000;
    private static final int TIMEOUT_READ_WRITE_MS = 2000;
    public static final String ELM_NEWLINE = "\r";
    public static final String AT_CMD_RESET = "ATZ\r";
    public static final String AT_CMD_ECHO_OFF = "ATE0\r";
    public static final String AT_CMD_LINEFEED_OFF = "ATL0\r";
    public static final String AT_CMD_SET_PROTOCOL_AUTO = "ATSP0\r";
    public static final String AT_CMD_SET_PROTOCOL_PASSTHROUGH = "ATSPC\r";
    public static final String AT_CMD_SET_PROTOCOL_RECALL = "ATM1";
    public static final String AT_RESPONSE_OK = "OK";
    public static final String AT_RESPONSE_ELM = "ELM";
    public static final String AT_RESPONSE_OBDKEY = "OBDKey";
    public static final String CMD_RESPONSE_READY = ">";
    public static final String ERROR_BUS_BUSY = "BUS BUSY";
    public static final String ERROR_FB_ERROR = "FB ERROR";
    public static final String ERROR_DATA_ERROR = "DATA ERROR";
    public static final String ERROR_NO_DATA = "NO DATA";
    public static final String ERROR_UNABLE_TO_CONNECT = "UNABLE TO CONNECT";
    public static final String ERROR_UNKNOWN = "?";
    public static final String[] KNOWN_ERRORS = new String[]{"BUS BUSY", "DATA ERROR", "FB ERROR", "?", "UNABLE TO CONNECT"};
    public static final int ELM_BAUD = 9600;
    public static final int ELM_DATA_BITS = 8;
    public static final String ELM_PARITY = "none";
    public static final int ELM_STOP_BITS = 1;
    public static final int MAX_RESPONSE_BUFFER = 1024;
    private int responseBufferOffset_ = 0;
    private byte[] responseBuffer_ = new byte[1024];
    private StreamConnection streamConnection_ = null;
    private InputStream inputStream_ = null;
    private OutputStream outputStream_ = null;
    private static final String ENAME_DTC_STATUS = "ELM_DTC_STATUS";
    private static final String ENAME_DTC_CODES = "ELM_DTC_CODES";
    private static final String ENAME_PTC_CODES = "ELM_PTC_CODES";
    private static final String ENAME_FUEL_STATUS = "ELM_FULE_STATUS";
    static /* synthetic */ Class class$com$mympgtracker$ecutracker$ecu$comm$ELM$ELMParameter;

    public ELMProtocolHandler() throws Exception {
        super(new ParameterRegistry());
        this.generateParameters(this.getParameterRegistry());
    }

    public void cleanYourRoom() {
        this.inputStream_ = null;
        this.outputStream_ = null;
        this.streamConnection_ = null;
        super.cleanYourRoom();
    }

    public void run() {
        ECUParameter[] eCUParameterArray = new ECUParameter[1];
        while (!this.getTerminate() || this.streamConnection_ != null) {
            try {
                if (this.streamConnection_ != null && !this.getConnect()) {
                    if (this.inputStream_ != null) {
                        this.inputStream_.close();
                        this.inputStream_ = null;
                    }
                    if (this.outputStream_ != null) {
                        this.outputStream_.close();
                        this.outputStream_ = null;
                    }
                    if (this.streamConnection_ != null) {
                        this.streamConnection_.close();
                        this.streamConnection_ = null;
                    }
                    this.fireEventProtocolDisconnected();
                }
                if (this.streamConnection_ == null && this.getConnect()) {
                    this.initProtocol();
                }
                if (this.streamConnection_ == null) {
                    Thread.sleep(25L);
                    continue;
                }
                ECUParameter eCUParameter = this.getParameterRegistry().getNextActiveParameter(class$com$mympgtracker$ecutracker$ecu$comm$ELM$ELMParameter == null ? ELMProtocolHandler.class$("com.mympgtracker.ecutracker.ecu.comm.ELM.ELMParameter") : class$com$mympgtracker$ecutracker$ecu$comm$ELM$ELMParameter);
                if (eCUParameter == null) {
                    throw new TrackerException(this, "run", "A", "No valid Active ECU Parameter Found");
                }
                this.readSeralData();
                this.resetReadBuffer();
                this.sendELMCommand(((ELMParameter)eCUParameter).getFullCommand());
                this.setOperationTimer(2000L);
                this.retreiveResponse(CMD_RESPONSE_READY);
                if (this.checkBufferForErrorString()) {
                    throw new TrackerException(this, "run", "B", Lang.get("protocol.status.error"));
                }
                ((ELMParameter)eCUParameter).extractResponseBytes(this.responseBuffer_, 0, this.responseBufferOffset_);
                eCUParameterArray[0] = eCUParameter;
                this.fireEventParametersFetched(eCUParameterArray);
            }
            catch (Throwable throwable) {
                this.disconnect();
                Log.error(this, "msg[" + throwable.getMessage() + "]", throwable);
            }
        }
        this.fireEventProtocolDisconnected();
    }

    private void initProtocol() throws Exception {
        this.fireEventProtocolConnecting();
        this.streamConnection_ = this.openStreamConnection(9600, 8, ELM_PARITY, 1);
        if (this.streamConnection_ == null) {
            throw new TrackerException(this, "initProtocol", "open port", Lang.get("protocol.status.init.failure"));
        }
        this.inputStream_ = this.streamConnection_.openInputStream();
        this.outputStream_ = this.streamConnection_.openOutputStream();
        this.fireEventInitStarted();
        this.fireEventInitStatus(Lang.get("protocol.elm.status.reset"));
        this.readSeralData();
        this.resetReadBuffer();
        this.sendELMCommand(AT_CMD_RESET);
        this.setOperationTimer(35000L);
        this.retreiveResponse(CMD_RESPONSE_READY);
        if (!this.checkBufferForString(AT_RESPONSE_ELM) && !this.checkBufferForString(AT_RESPONSE_OBDKEY)) {
            throw new TrackerException(this, "initProtocol", "B", Lang.get("protocol.status.init.failure"));
        }
        this.fireEventInitStatus(Lang.get("protocol.elm.status.echo"));
        this.readSeralData();
        this.resetReadBuffer();
        this.sendELMCommand(AT_CMD_ECHO_OFF);
        this.setOperationTimer(2000L);
        this.retreiveResponse(CMD_RESPONSE_READY);
        if (this.checkBufferForErrorString()) {
            Log.warn(this, "ATE0\r returned " + this.responseToString());
            throw new TrackerException(this, "initProtocol", "C", Lang.get("protocol.status.init.failure"));
        }
        this.fireEventInitStatus(Lang.get("protocol.elm.status.linefeed"));
        this.readSeralData();
        this.resetReadBuffer();
        this.sendELMCommand(AT_CMD_LINEFEED_OFF);
        this.setOperationTimer(2000L);
        this.retreiveResponse(CMD_RESPONSE_READY);
        if (this.checkBufferForErrorString()) {
            Log.warn(this, "ATE0\r returned " + this.responseToString());
            throw new TrackerException(this, "initProtocol", "D", Lang.get("protocol.status.init.failure"));
        }
        this.fireEventInitStatus(Lang.get("protocol.elm.status.protocol"));
        this.readSeralData();
        this.resetReadBuffer();
        this.sendELMCommand(AT_CMD_SET_PROTOCOL_AUTO);
        this.setOperationTimer(2000L);
        this.retreiveResponse(CMD_RESPONSE_READY);
        if (this.checkBufferForErrorString()) {
            Log.warn(this, "ATE0\r returned " + this.responseToString());
            throw new TrackerException(this, "initProtocol", "E", Lang.get("protocol.status.init.failure"));
        }
        ELMParameter eLMParameter = (ELMParameter)this.getParameterRegistry().get("RPM");
        this.fireEventInitStatus(Lang.get("protocol.elm.status.pid"));
        this.readSeralData();
        this.resetReadBuffer();
        this.sendELMCommand(eLMParameter.getFullCommand());
        this.setOperationTimer(35000L);
        this.retreiveResponse(CMD_RESPONSE_READY);
        if (this.checkBufferForErrorString()) {
            Log.warn(this, eLMParameter.getFullCommand() + " returned " + this.responseToString());
            throw new TrackerException(this, "initProtocol", "F", Lang.get("protocol.status.init.failure"));
        }
        eLMParameter.extractResponseBytes(this.responseBuffer_, 0, this.responseBufferOffset_);
        this.fireEventInitFinished();
    }

    private void retreiveResponse(String string) throws Exception {
        while (!this.isOperationTimerExpired()) {
            this.readSeralData();
            if (this.checkBufferForString(string)) {
                this.cleanUnwantedCharsFromBuffer();
                if (Log.enableDebug_) {
                    Log.debug(this, "RX: [" + this.responseToString() + "]");
                }
                return;
            }
            Thread.sleep(25L);
        }
        if (Log.enableDebug_) {
            Log.debug(this, "RX: [" + this.responseToString() + "]");
        }
        throw new TrackerException(this, "retreiveResponse", Lang.get("protocol.status.timeout"));
    }

    private void readSeralData() throws Exception {
        int n = 0;
        if (this.inputStream_.available() <= 0) {
            return;
        }
        n = this.inputStream_.read(this.responseBuffer_, this.responseBufferOffset_, this.inputStream_.available());
        this.responseBufferOffset_ += Math.max(n, 0);
    }

    private void sendELMCommand(String string) throws Exception {
        if (Log.enableDebug_) {
            Log.debug(this, "TX: [" + string + "]");
        }
        if (!string.endsWith(ELM_NEWLINE)) {
            string = string + ELM_NEWLINE;
        }
        this.outputStream_.write(string.getBytes(), 0, string.length());
        this.outputStream_.flush();
    }

    private void resetReadBuffer() {
        this.responseBufferOffset_ = 0;
        for (int i = 0; i < this.responseBuffer_.length; ++i) {
            this.responseBuffer_[i] = 48;
        }
    }

    private void cleanUnwantedCharsFromBuffer() {
        for (int i = 0; i < this.responseBufferOffset_; ++i) {
            boolean bl = false;
            if (this.responseBuffer_[i] == 10) {
                bl = true;
            }
            if (this.responseBuffer_[i] == 13) {
                bl = true;
            }
            if (this.responseBuffer_[i] == -1) {
                bl = true;
            }
            if (this.responseBuffer_[i] == 62) {
                bl = true;
            }
            if (!bl) continue;
            this.responseBuffer_[i] = 32;
        }
    }

    private boolean checkBufferForErrorString() {
        for (int i = 0; i < KNOWN_ERRORS.length; ++i) {
            if (!this.checkBufferForString(KNOWN_ERRORS[i])) continue;
            return true;
        }
        return false;
    }

    private boolean checkBufferForString(String string) {
        for (int i = 0; i < this.responseBufferOffset_; ++i) {
            if (string.length() > this.responseBufferOffset_ - i) continue;
            int n = 0;
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) == this.responseBuffer_[i + n]) continue;
                n = string.length() + 1;
            }
            if (n != string.length()) continue;
            return true;
        }
        return false;
    }

    private String responseToString() {
        return new String(this.responseBuffer_, 0, this.responseBufferOffset_);
    }

    protected void addCoreParameters(ParameterRegistry parameterRegistry) throws Exception {
        parameterRegistry.add(new ELMParameter(ENAME_DTC_STATUS, 1, 1, 8){

            public double getValue() {
                return this.fromHexCharsToInt(0, 8);
            }
        });
        parameterRegistry.add(new OneParamMetaParameter("CEL", parameterRegistry.get(ENAME_DTC_STATUS)){

            public double getValue() {
                return ((ELMParameter)this.p1_).getInt(0) >> 7;
            }
        });
        parameterRegistry.add(new OneParamMetaParameter("DTC_COUNT", parameterRegistry.get(ENAME_DTC_STATUS)){

            public double getValue() {
                return ((ELMParameter)this.p1_).getInt(0) & 0x7F;
            }
        });
        parameterRegistry.add(new ELMParameter(ENAME_DTC_CODES, 3, -1, -1){

            public double getValue() {
                return 0.0;
            }
        });
        parameterRegistry.add(new ELMDTCParameter("DTC1", parameterRegistry.get(ENAME_DTC_CODES), 0));
        parameterRegistry.add(new ELMDTCParameter("DTC2", parameterRegistry.get(ENAME_DTC_CODES), 4));
        parameterRegistry.add(new ELMDTCParameter("DTC3", parameterRegistry.get(ENAME_DTC_CODES), 8));
        parameterRegistry.add(new ELMDTCParameter("DTC4", parameterRegistry.get(ENAME_DTC_CODES), 14));
        parameterRegistry.add(new ELMDTCParameter("DTC5", parameterRegistry.get(ENAME_DTC_CODES), 18));
        parameterRegistry.add(new ELMDTCParameter("DTC6", parameterRegistry.get(ENAME_DTC_CODES), 22));
        parameterRegistry.add(new ELMParameter(ENAME_PTC_CODES, 7, -1, -1){

            public double getValue() {
                return 0.0;
            }
        });
        parameterRegistry.add(new ELMDTCParameter("PTC1", parameterRegistry.get(ENAME_PTC_CODES), 0));
        parameterRegistry.add(new ELMDTCParameter("PTC2", parameterRegistry.get(ENAME_PTC_CODES), 4));
        parameterRegistry.add(new ELMDTCParameter("PTC3", parameterRegistry.get(ENAME_PTC_CODES), 8));
        parameterRegistry.add(new ELMDTCParameter("PTC4", parameterRegistry.get(ENAME_PTC_CODES), 14));
        parameterRegistry.add(new ELMDTCParameter("PTC5", parameterRegistry.get(ENAME_PTC_CODES), 18));
        parameterRegistry.add(new ELMDTCParameter("PTC6", parameterRegistry.get(ENAME_PTC_CODES), 22));
        parameterRegistry.add(new ELMParameter(ENAME_FUEL_STATUS, 1, 3, 4){

            public double getValue() {
                return this.fromHexCharsToInt(0, 4);
            }
        });
        parameterRegistry.add(new BitCheckMetaParam("FS0", parameterRegistry.get(ENAME_FUEL_STATUS), 256));
        parameterRegistry.add(new BitCheckMetaParam("FS1", parameterRegistry.get(ENAME_FUEL_STATUS), 512));
        parameterRegistry.add(new BitCheckMetaParam("FS2", parameterRegistry.get(ENAME_FUEL_STATUS), 1024));
        parameterRegistry.add(new BitCheckMetaParam("FS3", parameterRegistry.get(ENAME_FUEL_STATUS), 2048));
        parameterRegistry.add(new BitCheckMetaParam("FS4", parameterRegistry.get(ENAME_FUEL_STATUS), 4096));
        parameterRegistry.add(new ELMParameter("LOAD", 1, 4, 2){

            public double getValue() {
                return this.getDouble(0) * 100.0 / 255.0;
            }
        });
        parameterRegistry.add(new ELMParameter("COOLANT_TEMP_C", 1, 5, 2){

            public double getValue() {
                return this.getDouble(0) - 40.0;
            }
        });
        parameterRegistry.add(new DegCelToDegFarMetaParam("COOLANT_TEMP_F", parameterRegistry.get("COOLANT_TEMP_C")));
        parameterRegistry.add(new ELMParameter("STFT1", 1, 6, 2){

            public double getValue() {
                return 0.7812 * (this.getDouble(0) - 128.0);
            }
        });
        parameterRegistry.add(new ELMParameter("LTFT1", 1, 7, 2){

            public double getValue() {
                return 0.7812 * (this.getDouble(0) - 128.0);
            }
        });
        parameterRegistry.add(new ELMParameter("STFT2", 1, 8, 2){

            public double getValue() {
                return 0.7812 * (this.getDouble(0) - 128.0);
            }
        });
        parameterRegistry.add(new ELMParameter("LTFT2", 1, 9, 2){

            public double getValue() {
                return 0.7812 * (this.getDouble(0) - 128.0);
            }
        });
        parameterRegistry.add(new ELMParameter("MAF", 1, 16, 4){

            public double getValue() {
                return (256.0 * this.getDouble(0) + this.getDouble(1)) / 100.0;
            }
        });
        parameterRegistry.add(new ELMParameter("TPS", 1, 17, 2){

            public double getValue() {
                return this.getDouble(0) * 100.0 / 255.0;
            }
        });
        parameterRegistry.add(new ELMParameter("FuelPressure", 1, 10, 2){

            public double getValue() {
                return this.getDouble(0) * 3.0;
            }
        });
        parameterRegistry.add(new ELMParameter("MAP_KPA", 1, 11, 2){

            public double getValue() {
                return this.getDouble(0);
            }
        });
        parameterRegistry.add(new KpaToPsiMetaParam("MAP_PSI", parameterRegistry.get("MAP_KPA")));
        parameterRegistry.add(new KpaToInHgMetaParam("MAP_INHG", parameterRegistry.get("MAP_KPA")));
        parameterRegistry.add(new ELMParameter("RPM", 1, 12, 4){

            public double getValue() {
                return (this.getDouble(0) * 256.0 + this.getDouble(1)) / 4.0;
            }
        });
        parameterRegistry.add(new ELMParameter("KPH", 1, 13, 2){

            public double getValue() {
                return this.getDouble(0);
            }
        });
        parameterRegistry.add(new KphToMphMetaParam("MPH", parameterRegistry.get("KPH")));
        parameterRegistry.add(new ELMParameter("INTAKE_TEMP_C", 1, 15, 2){

            public double getValue() {
                return this.getDouble(0) - 40.0;
            }
        });
        parameterRegistry.add(new DegCelToDegFarMetaParam("INTAKE_TEMP_F", parameterRegistry.get("INTAKE_TEMP_C")));
        parameterRegistry.add(new DegCelToDegKelvinMetaParam("INTAKE_TEMP_K", parameterRegistry.get("INTAKE_TEMP_C")));
    }

    private void generateParameters(ParameterRegistry parameterRegistry) throws Exception {
        this.addCoreParameters(parameterRegistry);
        AbstractProtocolHandler.addVMafParameter(parameterRegistry);
        AbstractProtocolHandler.addMPG1aParameters(parameterRegistry);
        AbstractProtocolHandler.addMPG1bParameters(parameterRegistry);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

