/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.comm.ELM;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.util.Convert;

public abstract class ELMParameter
extends ECUParameter {
    public static final int MODE_1 = 1;
    public static final int MODE_2 = 2;
    public static final int MODE_3 = 3;
    public static final int MODE_4 = 4;
    public static final int MODE_5 = 5;
    public static final int MODE_6 = 6;
    public static final int MODE_7 = 7;
    public static final int MODE_8 = 8;
    public static final int MODE_9 = 9;
    public static final int MODE_A = 10;
    public static final int COMMAND_NULL = -1;
    public static final int RESONSE_SIZE_DYNAMIC = -1;
    private int mode_ = -1;
    private int command_ = -1;
    private int expectedResponseLength_ = 0;
    private String response_ = null;
    private String fullCommand_ = null;
    private String expectedResponsePrefix_ = null;

    public ELMParameter(String string, int n, int n2, int n3) {
        super(string);
        this.mode_ = n;
        this.command_ = n2;
        this.expectedResponseLength_ = n3;
    }

    public int getMode() {
        return this.mode_;
    }

    public int getCommand() {
        return this.command_;
    }

    public String getFullCommand() {
        if (this.fullCommand_ == null) {
            this.fullCommand_ = Convert.unsigned2hex(this.getMode(), 2);
            if (this.getCommand() != -1) {
                this.fullCommand_ = this.fullCommand_ + Convert.unsigned2hex(this.getCommand(), 2) + "\r";
            }
        }
        return this.fullCommand_;
    }

    private String getExpectedResponsePrefix() {
        if (this.expectedResponsePrefix_ == null) {
            this.expectedResponsePrefix_ = "4" + Convert.unsigned2hex(this.getMode(), 1);
            if (this.getCommand() != -1) {
                this.expectedResponsePrefix_ = this.expectedResponsePrefix_ + Convert.unsigned2hex(this.getCommand(), 2);
            }
        }
        return this.expectedResponsePrefix_;
    }

    protected void extractResponseBytes(byte[] byArray, int n, int n2) throws RuntimeException {
        int n3;
        this.response_ = "";
        for (n3 = 0; n3 < n2; ++n3) {
            char c = (char)byArray[n + n3];
            if (!Convert.isHex(c)) continue;
            this.response_ = this.response_ + Convert.toUpperCase(c);
        }
        n3 = 0;
        n3 = this.response_.indexOf(this.getExpectedResponsePrefix());
        if (n3 < 0) {
            throw new RuntimeException("Response Header Not Found\nTX[" + this.getFullCommand().replace("\r".charAt(0), ']') + "\nRX[" + this.response_ + "]");
        }
        if (this.expectedResponseLength_ != -1 && this.response_.length() != (n3 += this.getExpectedResponsePrefix().length()) + this.expectedResponseLength_) {
            throw new RuntimeException("Incorrect Response Length\nTX[" + this.getFullCommand().replace("\r".charAt(0), ']') + "\nRX[" + this.response_ + "]");
        }
        this.response_ = this.response_.substring(n3);
        this.fireValueChanged();
    }

    public int fromHexCharsToInt(int n, int n2) {
        if (this.response_ == null) {
            return 0;
        }
        int n3 = 0;
        boolean bl = false;
        for (int i = n; i < n + n2; ++i) {
            if (bl) {
                n3 <<= 4;
            }
            n3 |= Convert.toOct(this.response_.charAt(i));
            bl = true;
        }
        return n3;
    }

    public int fromCharsToInt(int n, int n2) {
        if (this.response_ == null) {
            return 0;
        }
        if (n > this.response_.length()) {
            return 0;
        }
        if (n + n2 > this.response_.length()) {
            return 0;
        }
        return Convert.toInt(this.response_.substring(n, n + n2));
    }

    public int getInt(int n) {
        return this.fromHexCharsToInt(n, 2);
    }

    public double getDouble(int n) {
        return this.getInt(n);
    }

    public double setDemoValue() {
        byte[] byArray = new byte[this.expectedResponseLength_ == -1 ? 8 : this.expectedResponseLength_];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            byArray[i] = by = (byte)(by + 2);
        }
        this.extractResponseBytes(byArray, 0, byArray.length);
        return this.getValue();
    }

    public static void main(String[] stringArray) {
        try {
            byte[] byArray = "SEARCHING... 41 0C 0E 74  \n\r".getBytes();
            ELMParameter eLMParameter = new ELMParameter("test", 1, 12, 4){

                public double getValue() {
                    return this.getDouble(0);
                }
            };
            eLMParameter.extractResponseBytes(byArray, 0, byArray.length);
            System.out.println(">>" + eLMParameter.fromHexCharsToInt(0, 4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

