/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.comm;

import com.mympgtracker.ecutracker.ecu.comm.ProtocolEventListener;
import com.mympgtracker.ecutracker.ecu.comm.ProtocolHandler;
import com.mympgtracker.ecutracker.ecu.param.DistanceRunMetaParam;
import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.FuelConsumedMAFMetaParam;
import com.mympgtracker.ecutracker.ecu.param.FuelConsumedMetaParam;
import com.mympgtracker.ecutracker.ecu.param.LPH1MetaParam;
import com.mympgtracker.ecutracker.ecu.param.LPHInjectorPWMetaParam;
import com.mympgtracker.ecutracker.ecu.param.LPKAverageMetaParam;
import com.mympgtracker.ecutracker.ecu.param.LPKInstantMetaParam;
import com.mympgtracker.ecutracker.ecu.param.LPKTripMetaParam;
import com.mympgtracker.ecutracker.ecu.param.LambdaToAirFuel;
import com.mympgtracker.ecutracker.ecu.param.MPG1AverageMetaParam;
import com.mympgtracker.ecutracker.ecu.param.MPG1MetaParam;
import com.mympgtracker.ecutracker.ecu.param.MPGToLPKMetaParam;
import com.mympgtracker.ecutracker.ecu.param.ParameterRegistry;
import com.mympgtracker.ecutracker.ecu.param.VMAFMetaParam;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.TrackerRuntimeException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public abstract class AbstractProtocolHandler
implements ProtocolHandler {
    private ParameterRegistry supportedParameters_ = null;
    private Vector eventListeners_ = new Vector();
    private boolean terminate_ = false;
    private boolean connect_ = false;
    private String connectUrl_ = null;
    private long opTimeLimit_ = 0L;
    private long opTimeStart_ = 0L;

    public AbstractProtocolHandler(ParameterRegistry parameterRegistry) throws Exception {
        this.supportedParameters_ = parameterRegistry;
        this.setTerminate(false);
        this.setConnect(false);
    }

    public void cleanYourRoom() {
        try {
            this.terminate();
        }
        catch (Exception exception) {
            Log.error(this, "Handler Cleanup Error: ", exception);
        }
    }

    public void addParameterExtraValues(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            for (int i = 0; i < this.supportedParameters_.size(); ++i) {
                this.supportedParameters_.get(i).setExtraValue(string, string2);
            }
        }
    }

    public void setTerminate(boolean bl) {
        this.terminate_ = bl;
    }

    public boolean getTerminate() {
        return this.terminate_;
    }

    public void setConnect(boolean bl) {
        this.connect_ = bl;
    }

    public boolean getConnect() {
        return this.connect_;
    }

    public void connect(String string) throws Exception {
        if (string == null || string.length() <= 1) {
            throw new Exception(Lang.get("form.options.comm.not_set_error"));
        }
        if (this.getTerminate()) {
            throw new TrackerRuntimeException(this, "connect", Lang.get("protocol.status.terminated"));
        }
        this.connectUrl_ = string;
        this.setConnect(true);
    }

    protected StreamConnection openStreamConnection(int n, int n2, String string, int n3) throws Exception {
        StreamConnection streamConnection = null;
        String string2 = this.getConnectUrl();
        if (string2 == null || string2.length() <= 1) {
            throw new Exception(Lang.get("protocol.status.init.com_failure"));
        }
        if (string2.startsWith("comm:")) {
            string2 = string2 + ";baudrate=" + n + ";bitsperchar=" + n2 + ";stopbits=" + n3 + ";parity=" + string + ";autocts=on;autorts=on";
        }
        Log.info(this, "URL:[" + string2 + "]");
        streamConnection = (StreamConnection)Connector.open((String)string2, (int)3, (boolean)true);
        return streamConnection;
    }

    public String getConnectUrl() {
        return this.connectUrl_;
    }

    public void disconnect() {
        this.setConnect(false);
    }

    public void terminate() {
        this.disconnect();
        this.setTerminate(true);
    }

    public ParameterRegistry getParameterRegistry() {
        return this.supportedParameters_;
    }

    protected void setOperationTimer(long l) {
        this.opTimeStart_ = System.currentTimeMillis();
        this.opTimeLimit_ = l;
    }

    protected boolean isOperationTimerExpired() {
        return this.opTimeStart_ + this.opTimeLimit_ < System.currentTimeMillis();
    }

    public void addProtocolEventListener(ProtocolEventListener protocolEventListener) {
        this.eventListeners_.addElement(protocolEventListener);
    }

    public Vector getEventListeners() {
        return this.eventListeners_;
    }

    public void fireEventInitStarted() {
        for (int i = 0; i < this.eventListeners_.size(); ++i) {
            ProtocolEventListener protocolEventListener = (ProtocolEventListener)this.eventListeners_.elementAt(i);
            protocolEventListener.initStarted();
        }
    }

    public void fireEventInitFinished() {
        for (int i = 0; i < this.eventListeners_.size(); ++i) {
            ProtocolEventListener protocolEventListener = (ProtocolEventListener)this.eventListeners_.elementAt(i);
            protocolEventListener.initFinished();
        }
    }

    public void fireEventInitStatus(String string) {
        for (int i = 0; i < this.eventListeners_.size(); ++i) {
            ProtocolEventListener protocolEventListener = (ProtocolEventListener)this.eventListeners_.elementAt(i);
            protocolEventListener.initStatus(string);
        }
    }

    public void fireEventParametersFetched(ECUParameter[] eCUParameterArray) {
        for (int i = 0; i < this.eventListeners_.size(); ++i) {
            ProtocolEventListener protocolEventListener = (ProtocolEventListener)this.eventListeners_.elementAt(i);
            protocolEventListener.parametersFetched(eCUParameterArray);
        }
    }

    public void fireEventProtocolConnecting() {
        for (int i = 0; i < this.eventListeners_.size(); ++i) {
            ProtocolEventListener protocolEventListener = (ProtocolEventListener)this.eventListeners_.elementAt(i);
            protocolEventListener.protocolConnecting();
        }
    }

    public void fireEventProtocolDisconnected() {
        for (int i = 0; i < this.eventListeners_.size(); ++i) {
            ProtocolEventListener protocolEventListener = (ProtocolEventListener)this.eventListeners_.elementAt(i);
            protocolEventListener.protocolDisconnected();
        }
    }

    public static void addVMafParameter(ParameterRegistry parameterRegistry) {
        parameterRegistry.add(new VMAFMetaParam("VMAF", parameterRegistry.get("RPM"), parameterRegistry.get("MAP_KPA"), parameterRegistry.get("INTAKE_TEMP_K")));
    }

    public static void addMPG1aParameters(ParameterRegistry parameterRegistry) throws Exception {
        parameterRegistry.assertParam("MAF");
        parameterRegistry.assertParam("KPH");
        parameterRegistry.add(new MPG1MetaParam("MPG1a_GAS", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_GAS));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1a_GAS_AVERAGE", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_GAS));
        parameterRegistry.add(new MPG1MetaParam("MPG1a_DIESEL", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_DIESEL));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1a_DIESEL_AVERAGE", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_DIESEL));
        parameterRegistry.add(new MPG1MetaParam("MPG1a_E85", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_E85));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1a_E85_AVERAGE", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_E85));
        parameterRegistry.add(new MPGToLPKMetaParam("LPK1a_GAS", parameterRegistry.get("MPG1a_GAS")));
        parameterRegistry.add(new MPGToLPKMetaParam("LPK1a_GAS_AVERAGE", parameterRegistry.get("MPG1a_GAS_AVERAGE")));
        parameterRegistry.add(new MPGToLPKMetaParam("LPK1a_DIESEL", parameterRegistry.get("MPG1a_DIESEL")));
        parameterRegistry.add(new MPGToLPKMetaParam("LPK1a_DIESEL_AVERAGE", parameterRegistry.get("MPG1a_DIESEL_AVERAGE")));
        parameterRegistry.add(new MPGToLPKMetaParam("LPK1a_E85", parameterRegistry.get("MPG1a_E85")));
        parameterRegistry.add(new MPGToLPKMetaParam("LPK1a_E85_AVERAGE", parameterRegistry.get("MPG1a_E85_AVERAGE")));
        parameterRegistry.add(new LPH1MetaParam("LPH1a_GAS", parameterRegistry.get("MAF"), LambdaToAirFuel.AF_STOICH_GAS));
        if (parameterRegistry.get("INJECTOR_PULSE_WIDTH_MS") != null) {
            parameterRegistry.add(new LPHInjectorPWMetaParam("LPH_INJECTOR_PW", parameterRegistry.get("RPM"), parameterRegistry.get("INJECTOR_PULSE_WIDTH_MS")));
            parameterRegistry.add(new LPKInstantMetaParam("LPK_INSTANT_INJECTOR_PW", parameterRegistry.get("LPH_INJECTOR_PW"), parameterRegistry.get("KPH")));
            parameterRegistry.add(new LPKAverageMetaParam("LPK_SHORT_INJECTOR_PW", parameterRegistry.get("LPH_INJECTOR_PW"), parameterRegistry.get("KPH"), 90));
            parameterRegistry.add(new LPKAverageMetaParam("LPK_AVG_INJECTOR_PW", parameterRegistry.get("LPH_INJECTOR_PW"), parameterRegistry.get("KPH"), -1));
            parameterRegistry.add(new FuelConsumedMetaParam("FUEL_CONSUMED", parameterRegistry.get("RPM"), parameterRegistry.get("INJECTOR_PULSE_WIDTH_MS")));
        } else {
            parameterRegistry.add(new FuelConsumedMAFMetaParam("FUEL_CONSUMED", parameterRegistry.get("MAF"), LambdaToAirFuel.AF_STOICH_GAS));
        }
        parameterRegistry.add(new DistanceRunMetaParam("DISTANCE_RUN", parameterRegistry.get("KPH")));
        parameterRegistry.add(new LPKTripMetaParam("LPK_TRIP", parameterRegistry.get("FUEL_CONSUMED"), parameterRegistry.get("DISTANCE_RUN")));
    }

    public static void addMPG1bParameters(ParameterRegistry parameterRegistry) throws Exception {
        parameterRegistry.assertParam("VMAF");
        parameterRegistry.assertParam("KPH");
        parameterRegistry.add(new MPG1MetaParam("MPG1b_GAS", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_GAS));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1b_GAS_AVERAGE", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_GAS));
        parameterRegistry.add(new MPG1MetaParam("MPG1b_DIESEL", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_DIESEL));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1b_DIESEL_AVERAGE", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_DIESEL));
        parameterRegistry.add(new MPG1MetaParam("MPG1b_E85", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_E85));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1b_E85_AVERAGE", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), LambdaToAirFuel.AF_STOICH_E85));
    }

    public static void addMPG1cParameters(ParameterRegistry parameterRegistry) throws Exception {
        parameterRegistry.assertParam("MAF");
        parameterRegistry.assertParam("KPH");
        parameterRegistry.assertParam("AF1_GAS");
        parameterRegistry.assertParam("AF1_DIESEL");
        parameterRegistry.assertParam("AF1_E85");
        parameterRegistry.add(new MPG1MetaParam("MPG1c_GAS", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_GAS")));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1c_GAS_AVERAGE", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_GAS")));
        parameterRegistry.add(new MPG1MetaParam("MPG1c_DIESEL", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_DIESEL")));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1c_DIESEL_AVERAGE", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_DIESEL")));
        parameterRegistry.add(new MPG1MetaParam("MPG1c_E85", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_E85")));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1c_E85_AVERAGE", parameterRegistry.get("MAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_E85")));
    }

    public static void addMPG1dParameters(ParameterRegistry parameterRegistry) throws Exception {
        parameterRegistry.assertParam("VMAF");
        parameterRegistry.assertParam("KPH");
        parameterRegistry.assertParam("AF1_GAS");
        parameterRegistry.assertParam("AF1_DIESEL");
        parameterRegistry.assertParam("AF1_E85");
        parameterRegistry.add(new MPG1MetaParam("MPG1d_GAS", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_GAS")));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1d_GAS_AVERAGE", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_GAS")));
        parameterRegistry.add(new MPG1MetaParam("MPG1d_DIESEL", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_DIESEL")));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1d_DIESEL_AVERAGE", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_DIESEL")));
        parameterRegistry.add(new MPG1MetaParam("MPG1d_E85", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_E85")));
        parameterRegistry.add(new MPG1AverageMetaParam("MPG1d_E85_AVERAGE", parameterRegistry.get("VMAF"), parameterRegistry.get("KPH"), parameterRegistry.get("AF1_E85")));
    }

    public abstract /* synthetic */ void run();
}

