/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.config;

import com.mympgtracker.ecutracker.OptionsForm;
import com.mympgtracker.ecutracker.config.ProfileParser;
import com.mympgtracker.ecutracker.profile.DeviceConfig;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.StringReader;
import com.mympgtracker.util.qdxml.QDParser;
import java.io.InputStreamReader;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class ProfileFetcher
extends Thread
implements Cleanable {
    private static final String DEVICE_PROFILE_REMOTE_URL_PREFIX = "http://www.mympgtracker.com/ecutracker/devices/xml/";
    private boolean isFinished_ = false;
    private String profileUrl_ = null;
    private OptionsForm oForm_ = null;
    private static final int STATUS_DELAY = 500;

    public ProfileFetcher(String string, OptionsForm optionsForm) {
        this.profileUrl_ = string;
        this.oForm_ = optionsForm;
        Log.info(this, string);
    }

    public void cleanYourRoom() {
        this.oForm_ = null;
    }

    public static String generateFetchUrl(String string, String string2) {
        return DEVICE_PROFILE_REMOTE_URL_PREFIX + string.toLowerCase() + "/" + string2.toLowerCase() + "/";
    }

    public boolean isFinished() {
        return this.isFinished_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HttpConnection httpConnection = null;
        InputStreamReader inputStreamReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.oForm_.statusUpdate(Lang.get("fetch.status.connecting"));
            Thread.sleep(500L);
            httpConnection = (HttpConnection)Connector.open((String)this.profileUrl_, (int)3, (boolean)true);
            if (httpConnection.getResponseCode() != 200) {
                throw new Exception(Lang.get("fetch.status.error.not_found"));
            }
            inputStreamReader = new InputStreamReader(httpConnection.openInputStream());
            this.oForm_.statusUpdate(Lang.get("fetch.status.fetching"));
            Thread.sleep(250L);
            int n = 0;
            while ((n = inputStreamReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            ProfileParser profileParser = new ProfileParser();
            StringReader stringReader = new StringReader(stringBuffer.toString());
            QDParser.parse(profileParser, stringReader);
            DeviceConfig deviceConfig = profileParser.getDeviceConfig();
            if (deviceConfig.getVersionMajor() != 0 && deviceConfig.getVersionMinor() != 10) {
                throw new Exception(Lang.get("form.options.profile.version_error"));
            }
            this.oForm_.setFetchedProfile(stringBuffer.toString());
        }
        catch (Exception exception) {
            Log.error(this, "Error fetching profile", exception);
            this.oForm_.statusUpdate(Lang.get("fetch.status.error") + " - " + exception.getMessage());
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (httpConnection != null) {
                try {
                    httpConnection.close();
                }
                catch (Exception exception) {}
            }
            this.isFinished_ = true;
        }
    }
}

