/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker;

import com.mympgtracker.ecutracker.config.LocalSettingsStore;
import com.mympgtracker.ecutracker.ecu.comm.DummyProtocolHandler;
import com.mympgtracker.ecutracker.ecu.comm.ELM.ELMProtocolHandler;
import com.mympgtracker.ecutracker.ecu.comm.ProtocolEventListener;
import com.mympgtracker.ecutracker.ecu.comm.ProtocolHandler;
import com.mympgtracker.ecutracker.ecu.comm.SSM.SSMOBD2ProtocolHandler;
import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.ValueChangedListener;
import com.mympgtracker.ecutracker.ecu.param.ValueConsumer;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Convert;
import com.mympgtracker.util.Log;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class ProtocolTestingForm
extends TextBox
implements CommandListener,
ProtocolEventListener,
ValueChangedListener,
ValueConsumer,
Log.LogMessageListener,
Cleanable {
    private MIDlet parentMidlet_ = null;
    private Command closeCommand_ = null;
    private Command connectCommand_ = null;
    private static final int MAX_OUTPUT_CHARS = 5000;
    private ProtocolHandler pHandler_ = null;
    private ECUParameter rpmP_ = null;
    private ECUParameter kphP_ = null;
    private ECUParameter tempP_ = null;
    private static final int PROTOCOL_DUMMY = 1;
    private static final int PROTOCOL_ELM = 2;
    private static final int PROTOCOL_SSM = 3;
    private static final int PROTOCOL_DEFAULT = 3;

    public ProtocolTestingForm(MIDlet mIDlet) {
        super("Protocol Testing", "", 5000, 0);
        Log.addMessageListener(this);
        this.parentMidlet_ = mIDlet;
        this.setCommandListener(this);
        this.closeCommand_ = new Command("Close", 7, 1);
        this.addCommand(this.closeCommand_);
        this.connectCommand_ = new Command("go/stop", 4, 1);
        this.addCommand(this.connectCommand_);
        try {
            Log.deleteExistingLog();
        }
        catch (Exception exception) {
            Log.error(this, "Unable to clear existing log", exception);
        }
        Log.info(this, "Protocol Testing MIDLET");
    }

    public void cleanYourRoom() {
        if (this.pHandler_ != null) {
            this.pHandler_.cleanYourRoom();
            this.pHandler_ = null;
        }
        this.parentMidlet_ = null;
    }

    private void connect(int n) {
        try {
            Log.info(this, "Connect");
            switch (n) {
                case 1: {
                    this.doTestDummy();
                    break;
                }
                case 2: {
                    this.doTestElm();
                    break;
                }
                case 3: {
                    this.doTestSSM();
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error Refreshing Log Displah: " + exception.getMessage() == null ? "Null Pointer" : exception.getMessage());
        }
    }

    protected void disconnect() throws Exception {
        if (this.pHandler_ != null) {
            this.pHandler_.terminate();
            this.pHandler_.cleanYourRoom();
            this.pHandler_ = null;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command.getCommandType() == 7) {
                this.disconnect();
                if (this.parentMidlet_ != null) {
                    this.parentMidlet_.notifyDestroyed();
                }
            }
            if (command.getCommandType() == 4) {
                if (this.pHandler_ != null) {
                    this.disconnect();
                } else {
                    this.connect(3);
                }
            }
        }
        catch (Exception exception) {
            Log.info(this, exception.getMessage());
        }
    }

    private void doTestDummy() throws Exception {
        Log.info(this, "Testing Dummy Protocol");
        Thread.yield();
        this.doTestProtocol(new DummyProtocolHandler(), null);
    }

    private void doTestElm() throws Exception {
        Log.info(this, "Testing ELM");
        Thread.yield();
        this.doTestProtocol(new ELMProtocolHandler(), LocalSettingsStore.getStore().getCommPort());
    }

    private void doTestSSM() throws Exception {
        Log.info(this, "Testing SSM");
        Thread.yield();
        this.doTestProtocol(new SSMOBD2ProtocolHandler(), LocalSettingsStore.getStore().getCommPort());
    }

    private void doTestProtocol(ProtocolHandler protocolHandler, String string) throws Exception {
        this.pHandler_ = protocolHandler;
        this.pHandler_.addProtocolEventListener(this);
        Log.info(this, "Using RPM, KPH and Engine Temp on port " + string + " for testing");
        Thread.yield();
        this.rpmP_ = this.pHandler_.getParameterRegistry().get("RPM");
        this.kphP_ = this.pHandler_.getParameterRegistry().get("KPH");
        this.tempP_ = this.pHandler_.getParameterRegistry().get("COOLANT_TEMP_C");
        if (this.rpmP_ == null) {
            throw new Exception("Unable to find RPM parameter in protocol handler\t");
        }
        if (this.kphP_ == null) {
            throw new Exception("Unable to find KPH parameter in protocol handler\t");
        }
        if (this.tempP_ == null) {
            throw new Exception("Unable to find Coolant Temp parameter in protocol handler\t");
        }
        this.rpmP_.addValueChangedListener(this);
        this.rpmP_.addValueConsumer(this);
        this.kphP_.addValueChangedListener(this);
        this.kphP_.addValueConsumer(this);
        this.tempP_.addValueChangedListener(this);
        this.tempP_.addValueConsumer(this);
        Log.info(this, "Creating+Starting Handler Thread: " + this.pHandler_.getClass().getName());
        Thread thread = new Thread(this.pHandler_);
        thread.start();
        Thread.sleep(1000L);
        this.pHandler_.connect(string);
    }

    public boolean proceedWithConnect() {
        return this.isShown();
    }

    public void initStarted() {
        Log.info(this, "Init Started");
        Thread.yield();
    }

    public void initStatus(String string) {
        Log.info(this, "Init Status " + string);
        Thread.yield();
    }

    public void initFinished() {
        Log.info(this, "Init Finished");
        Thread.yield();
    }

    public void protocolConnecting() {
        Log.info(this, "Protocol connecting");
        Thread.yield();
    }

    public void protocolDisconnected() {
        Log.info(this, "Protocol Disconnected");
        Thread.yield();
    }

    public void parametersFetched(ECUParameter[] eCUParameterArray) {
        for (int i = 0; i < eCUParameterArray.length; ++i) {
            ECUParameter eCUParameter = eCUParameterArray[i];
            Log.info(this, "Feched " + Convert.toString(eCUParameter.getValue(), 5) + " from " + eCUParameter.getName());
        }
        Log.info(this, this.rpmP_.getName() + " " + this.rpmP_.getValue());
        Log.info(this, this.kphP_.getName() + " " + this.kphP_.getValue());
        Log.info(this, this.tempP_.getName() + " " + this.tempP_.getValue());
        Thread.yield();
    }

    public void onValueChanged(ECUParameter eCUParameter) {
        Log.info(this, "Value Changed Listener Notified of change");
        Thread.yield();
    }

    public boolean isReadyToReceiveValues() {
        return true;
    }

    public void logMessage(String string) {
        if (string.length() + this.size() >= this.getMaxSize()) {
            this.delete(0, string.length());
        }
        this.insert(string, this.size());
        Thread.yield();
    }
}

