/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker;

import com.mympgtracker.ECUTrackerVersion;
import com.mympgtracker.ecutracker.ECUSensorCollector;
import com.mympgtracker.ecutracker.GaugeCanvas;
import com.mympgtracker.ecutracker.MainControlForm;
import com.mympgtracker.ecutracker.SplashForm;
import com.mympgtracker.ecutracker.config.LocalSettingsStore;
import com.mympgtracker.ecutracker.config.ProfileParser;
import com.mympgtracker.ecutracker.ecu.comm.ProtocolHandler;
import com.mympgtracker.ecutracker.profile.DeviceConfig;
import com.mympgtracker.ecutracker.profile.Profile;
import com.mympgtracker.ecutracker.profile.ProfileRenderer;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.ScreenLighter;
import com.mympgtracker.util.StringReader;
import com.mympgtracker.util.TrackerRuntimeException;
import com.mympgtracker.util.qdxml.DocHandler;
import com.mympgtracker.util.qdxml.QDParser;
import java.io.Reader;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class ECUTrackerMidlet
extends MIDlet
implements ECUTrackerVersion {
    public static final String APP_NAME = "ECU Tracker";
    public static final String APP_VERSION = "v0.10.53";
    public static final String APP_COPYRIGHT = "Copyright \u00a9 " + "2010/07/13".substring(0, "2010/07/13".indexOf("/"));
    public static final String APP_URL = "mympgtracker.com";
    public static final String RESOURCE_PATH = "/ecutracker-res/";
    private static final int SPLASH_DISPLAY_TIME = 2000;
    public static final boolean LOW_MEMORY_DEVICE = true;
    public static final boolean DISABLE_TTF_FONTS = true;
    protected GaugeCanvas gaugeScreen_ = null;
    private DeviceConfig deviceConfig_ = null;
    private ProtocolHandler protocolHandler_ = null;
    private Thread protocolThread_ = null;
    private Thread screenLighter_ = null;
    private AutoReconnectHelper autoConnectHelper_;
    private ECUSensorCollector sensorCollector_;

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        if (this.screenLighter_ != null && this.screenLighter_.isAlive()) {
            this.screenLighter_.interrupt();
            this.screenLighter_ = null;
        }
        this.doDisconnect();
        if (this.gaugeScreen_ != null) {
            this.gaugeScreen_.cleanYourRoom();
        }
        if (this.protocolHandler_ != null) {
            this.protocolHandler_.cleanYourRoom();
        }
        if (this.deviceConfig_ != null) {
            this.deviceConfig_.cleanYourRoom();
        }
        Log.close();
    }

    protected void pauseApp() {
        this.doDisconnect();
        Log.close();
    }

    protected void startApp() throws MIDletStateChangeException {
        try {
            Log.deleteExistingLog();
            Log.enableDebug_ = true;
            Log.echoToRecordStore_ = false;
            Log.info(this, Lang.get("app.startup.start") + " " + APP_NAME);
            try {
                if (this.screenLighter_ == null) {
                    this.screenLighter_ = new ScreenLighter();
                    this.screenLighter_.start();
                }
            }
            catch (Throwable throwable) {
                Log.error(this, "ScreenLighter keep alive failure", throwable);
            }
            if (System.getProperty("microedition.platform").indexOf("Nokia6") != -1) {
                new Thread(new Runnable(){

                    public void run() {
                        while (true) {
                            Display.getDisplay((MIDlet)ECUTrackerMidlet.this).flashBacklight(1);
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                }).start();
            }
            SplashForm splashForm = null;
            if (System.getProperty("microedition.platform").indexOf("SunMicrosystems_wtk") == -1) {
                splashForm = new SplashForm(this, null, true);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)splashForm);
            }
            this.gaugeScreen_ = new GaugeCanvas(this);
            try {
                LocalSettingsStore.getStore().getDeviceConfig();
                LocalSettingsStore.getStore().getActiveProfileIndex();
                LocalSettingsStore.getStore().getCommPort();
                LocalSettingsStore.getStore().getUsername();
                LocalSettingsStore.getStore().getDeviceId();
            }
            catch (Exception exception) {
                Log.warn(this, Lang.get("form.options.corrupted"));
                LocalSettingsStore.getStore().delete();
            }
            if (splashForm != null) {
                Thread.sleep(2000L);
            }
            this.reInitialize(false, true);
            this.displayGaugeScreen();
            if (splashForm != null) {
                splashForm.cleanYourRoom();
            }
            System.gc();
        }
        catch (Throwable throwable) {
            Log.error(this, Lang.get("app.startup.error"), throwable);
            this.showError(throwable.getMessage(), (Displayable)new MainControlForm(this));
        }
    }

    protected void reInitialize(boolean bl) throws Exception {
        this.reInitialize(bl, false);
    }

    protected void reInitialize(boolean bl, boolean bl2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Log.info(this, Lang.get("app.initialize"));
        if (this.protocolHandler_ != null) {
            this.protocolHandler_.terminate();
        }
        String string = null;
        if (this.deviceConfig_ != null) {
            this.deviceConfig_.cleanYourRoom();
            this.deviceConfig_ = null;
            this.protocolHandler_ = null;
        }
        try {
            string = LocalSettingsStore.getStore().getDeviceConfig();
            object3 = new StringReader(string);
            object2 = new ProfileParser();
            QDParser.parse((DocHandler)object2, (Reader)object3);
            this.deviceConfig_ = ((ProfileParser)object2).getDeviceConfig();
            if (this.deviceConfig_ == null) {
                throw new Exception("Parser Returned a Null Device Config");
            }
        }
        catch (Exception exception) {
            Log.error(this, Lang.get("config.corrupt") + ", " + Lang.get("config.use.demo"), exception);
            Log.info(this, "\n---\n" + string + "\n---\n");
            try {
                string = LocalSettingsStore.getStore().setInternalDeviceConfig("demo");
                LocalSettingsStore.getStore().setDeviceConfig(string);
                object2 = new StringReader(string);
                object = new ProfileParser();
                QDParser.parse((DocHandler)object, (Reader)object2);
                this.deviceConfig_ = ((ProfileParser)object).getDeviceConfig();
                if (this.deviceConfig_ == null) {
                    throw new Exception("Parser unable to process Default Config");
                }
            }
            catch (Exception exception2) {
                Log.error(this, Lang.get("config.use.demo") + " " + Lang.get("config.load.failure"), exception2);
                Log.info(this, string);
                throw exception2;
            }
        }
        if (LocalSettingsStore.getStore().getActiveProfileIndex() < 0) {
            LocalSettingsStore.getStore().setActiveProfileIndex(0);
        }
        LocalSettingsStore.getStore().save();
        object3 = this.deviceConfig_.getProfile(LocalSettingsStore.getStore().getActiveProfileIndex());
        object2 = Class.forName(((Profile)object3).getProtocolClass());
        if (this.protocolThread_ != null) {
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(200L);
                if (!this.protocolThread_.isAlive()) break;
            }
            if (this.protocolThread_.isAlive()) {
                Log.error(this, "Unable to stop protocol thread");
            }
            this.protocolThread_ = null;
        }
        if (this.protocolHandler_ != null) {
            this.protocolHandler_.cleanYourRoom();
        }
        if (this.sensorCollector_ != null) {
            this.sensorCollector_.deactivate();
        }
        try {
            this.protocolHandler_ = (ProtocolHandler)((Class)object2).newInstance();
            this.protocolHandler_.addParameterExtraValues(((Profile)object3).getExtraValues());
            this.protocolHandler_.addProtocolEventListener(this.gaugeScreen_);
            this.sensorCollector_ = new ECUSensorCollector();
            this.sensorCollector_.activate(this.protocolHandler_);
            this.protocolThread_ = new Thread(this.protocolHandler_);
            this.protocolThread_.start();
        }
        catch (Exception exception) {
            throw new Exception("Error in creation of protocol class (" + ((Profile)object3).getProtocolClass() + ") " + exception.getMessage());
        }
        object = new ProfileRenderer((Profile)object3, this.protocolHandler_);
        this.gaugeScreen_.setProfileRenderer((ProfileRenderer)object);
        if (bl || bl2 && this.deviceConfig_.getAutoConnect()) {
            this.doConnect();
        }
    }

    protected void displayGaugeScreen() {
        if (this.gaugeScreen_ == null) {
            throw new TrackerRuntimeException(this, "Unexpected Error: Gauge Screen is null");
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.gaugeScreen_);
    }

    protected void doConnect() {
        try {
            String string = LocalSettingsStore.getStore().getCommPort();
            if (string == null) {
                return;
            }
            this.protocolHandler_.connect(string);
            if (this.deviceConfig_.getAutoConnect()) {
                this.autoConnectHelper_ = new AutoReconnectHelper(string);
                this.autoConnectHelper_.start();
            }
        }
        catch (Throwable throwable) {
            Log.error(this, throwable.getMessage(), throwable);
            this.showError(throwable.getMessage(), (Displayable)this.gaugeScreen_);
        }
    }

    protected void doDisconnect() {
        try {
            if (this.autoConnectHelper_ != null) {
                this.autoConnectHelper_.deactivate();
            }
            if (this.protocolHandler_ != null) {
                this.protocolHandler_.disconnect();
            }
            if (this.sensorCollector_ != null) {
                this.sensorCollector_.deactivate();
            }
        }
        catch (Exception exception) {
            Log.error(this, exception.getMessage(), exception);
            this.showError(exception.getMessage(), (Displayable)this.gaugeScreen_);
        }
    }

    protected void showAlert(Alert alert, Displayable displayable) {
        Display display = Display.getDisplay((MIDlet)this);
        display.setCurrent(alert, displayable);
    }

    protected void showError(String string, Displayable displayable) {
        Alert alert = new Alert(Lang.get("common.error"), string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        this.showAlert(alert, displayable);
    }

    protected void showWarning(String string, Displayable displayable) {
        Alert alert = new Alert(Lang.get("common.error"), string, null, AlertType.WARNING);
        alert.setTimeout(-2);
        this.showAlert(alert, displayable);
    }

    protected void showInfo(String string, Displayable displayable) {
        Alert alert = new Alert(Lang.get("common.error"), string, null, AlertType.INFO);
        alert.setTimeout(-2);
        this.showAlert(alert, displayable);
    }

    public DeviceConfig getDeviceConfig() {
        return this.deviceConfig_;
    }

    public ECUSensorCollector getSensorCollector() {
        return this.sensorCollector_;
    }

    static {
        Lang.setResourcePath(RESOURCE_PATH);
    }

    class AutoReconnectHelper
    extends Thread {
        private String port;
        private boolean active;

        AutoReconnectHelper(String string) {
            this.port = string;
            this.active = true;
        }

        public void deactivate() {
            this.active = false;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(20000L);
                        if (!this.active) {
                            return;
                        }
                        ECUTrackerMidlet.this.protocolHandler_.connect(this.port);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

