/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker;

import com.mympgtracker.ecutracker.config.LocalSettingsStore;
import com.mympgtracker.ecutracker.ecu.comm.ProtocolHandler;
import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.ValueChangedListener;
import com.mympgtracker.ecutracker.ecu.param.ValueConsumer;
import drivehub.client.ProgressLogger;
import drivehub.client.SensorCollector;
import drivehub.client.j2me.RMSRecordStore;
import drivehub.client.j2me.SensorPushHandler;
import java.util.Vector;

public class ECUSensorCollector
implements ValueConsumer,
ValueChangedListener {
    static final String SENSOR_STORAGE = "SensorStorage";
    static Vector log_buffer = new Vector();
    static int recordsStored = 0;
    RMSRecordStore rs;
    SensorCollector sc;
    int miminumPushSize = 1;
    boolean active = false;
    String[] trackedParameters = new String[]{"KPH", "5000", "", "RPM", "1000", "", "INJECTOR_PULSE_WIDTH_MS", "1000", "", "MAF", "1000", "", "STFT1", "2000", "noaverage", "LTFT1", "2000", "noaverage", "COOLANT_TEMP_C", "30000", "noaverage"};
    private SensorPushHandler sensorPushHandler_;
    private ProgressLogger progressLogger = new ProgressLogger(){

        public void info(String string, String string2) {
            ECUSensorCollector.log(string);
        }

        public void info(String string) {
            this.info(string, "");
        }

        public void error(String string, Exception exception) {
            ECUSensorCollector.log(string + " " + exception.getMessage());
        }
    };

    ECUSensorCollector() {
    }

    public boolean isReadyToReceiveValues() {
        return this.active;
    }

    public void onValueChanged(ECUParameter eCUParameter) {
        try {
            this.sc.recordValue(eCUParameter.getName(), eCUParameter.getTimeStamp(), (float)eCUParameter.getValue());
        }
        catch (Exception exception) {
            ECUSensorCollector.log(exception.getMessage());
            exception.printStackTrace();
            this.sc.removeParameter(eCUParameter.getName());
        }
    }

    boolean activate(ProtocolHandler protocolHandler) {
        try {
            this.rs = new RMSRecordStore(SENSOR_STORAGE);
            this.sc = new SensorCollector(this.rs);
            for (int i = 0; i < this.trackedParameters.length / 3; ++i) {
                String string = this.trackedParameters[i * 3 + 0];
                int n = Integer.valueOf(this.trackedParameters[i * 3 + 1]);
                String string2 = this.trackedParameters[i * 3 + 2];
                ECUParameter eCUParameter = protocolHandler.getParameterRegistry().get(string);
                if (eCUParameter == null) continue;
                eCUParameter.addValueConsumer(this);
                eCUParameter.addValueChangedListener(this);
                boolean bl = true;
                if (string2.indexOf("noaverage") != -1) {
                    bl = false;
                }
                this.sc.addParameter(eCUParameter.getName(), n, bl);
            }
            this.sensorPushHandler_ = new SensorPushHandler(this.rs, LocalSettingsStore.getStore().getPushSiteURL(), LocalSettingsStore.getStore().getPushToken(), this.progressLogger);
            this.sensorPushHandler_.setMinimumPushSize(this.miminumPushSize);
            this.sensorPushHandler_.activate();
            this.setActiveTrip(System.currentTimeMillis());
            this.active = true;
        }
        catch (Exception exception) {
            ECUSensorCollector.log(exception.getMessage());
            exception.printStackTrace();
            this.deactivate();
        }
        return this.active;
    }

    void deactivate() {
        this.sc.deactivate();
        if (this.sensorPushHandler_ != null) {
            this.sensorPushHandler_.deactivate();
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (Exception exception) {
            ECUSensorCollector.log(exception.getMessage());
            exception.printStackTrace();
        }
        this.active = false;
    }

    public void setActiveTrip(long l) {
        this.sc.setTripStamp(l);
        this.sensorPushHandler_.setActiveTrip(l);
    }

    public void triggerUpload() {
        this.setActiveTrip(System.currentTimeMillis());
        this.sensorPushHandler_.triggerUpload();
    }

    public static int recordsStored() {
        return recordsStored;
    }

    public static void log(String string) {
        if (string == null) {
            return;
        }
        System.out.println(string);
        log_buffer.addElement(string);
    }

    public static String[] getLog() {
        Object[] objectArray = new String[log_buffer.size()];
        log_buffer.copyInto(objectArray);
        return objectArray;
    }
}

