/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import javax.microedition.lcdui.Graphics;
import ntr.ttme.DoubleRectangle;

public class View {
    public static final double WORLD_MIN_X = -32768.0;
    public static final double WORLD_MAX_X = 32767.0;
    public static final double WORLD_MIN_Y = -32768.0;
    public static final double WORLD_MAX_Y = 32767.0;
    public static final double NO_ZOOM = 1.0;
    public static final double MAX_ZOOM_IN = 8.0;
    public static final double MAX_ZOOM_OUT = 0.0625;
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int DEFAULT_BACKBUFFER_COLOR = 0xFFFFFF;
    private int viewWidth;
    private int viewHeight;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private DoubleRectangle visibleWorld;
    private double viewCenterWorldX;
    private double viewCenterWorldY;
    private double zoomFactor;
    private boolean forcedResolution;
    private double WYSIWYGScaleX;
    private double WYSIWYGScaleY;
    private Graphics frontBuffer;
    private Graphics backBuffer;
    private int backBufferColor;

    public View(int n, int n2, double d, double d2, double d3) {
        this.forcedResolution = false;
        this.viewWidth = n;
        this.viewHeight = n2;
        this.setZoomFactor(d);
        this.configureWYSIWYG();
        this.minX = -32768.0;
        this.maxX = 32767.0;
        this.minY = -32768.0;
        this.maxY = 32767.0;
        this.viewCenterWorldX = d2;
        this.viewCenterWorldY = d3;
        this.visibleWorld = new DoubleRectangle();
        this.centerViewPoint();
    }

    public View(int n, int n2) {
        this(n, n2, 1.0, 0.0, 0.0);
    }

    public View(int n, int n2, double d) {
        this(n, n2, d, 0.0, 0.0);
    }

    public View(int n, int n2, double d, double d2, double d3, int n3, int n4) {
        this.forcedResolution = true;
        this.viewWidth = n;
        this.viewHeight = n2;
        this.setZoomFactor(d);
        this.WYSIWYGScaleX = n3;
        this.WYSIWYGScaleY = n4;
        this.minX = -32768.0;
        this.maxX = 32767.0;
        this.minY = -32768.0;
        this.maxY = 32767.0;
        this.viewCenterWorldX = d2;
        this.viewCenterWorldY = d3;
        this.visibleWorld = new DoubleRectangle();
        this.centerViewPoint();
    }

    public void setFrontBuffer(Graphics graphics) {
        this.frontBuffer = graphics;
    }

    public Graphics getFrontBuffer() {
        if (!this.hasFrontBuffer()) {
            throw new IllegalStateException("FrontBuffer NOT set!");
        }
        return this.frontBuffer;
    }

    public void setBackBuffer(Graphics graphics) {
        this.setBackBuffer(graphics, 0xFFFFFF);
    }

    public void setBackBuffer(Graphics graphics, int n) {
        this.backBuffer = graphics;
        this.backBufferColor = n;
        this.clearBackBuffer();
    }

    public Graphics getBackBuffer() {
        if (!this.hasBackBuffer()) {
            throw new IllegalStateException("BackBuffer NOT set!");
        }
        return this.backBuffer;
    }

    public void setBuffers(Graphics graphics, Graphics graphics2) {
        this.setFrontBuffer(graphics);
        this.setBackBuffer(graphics2);
    }

    public void setBuffers(Graphics graphics, Graphics graphics2, int n) {
        this.setFrontBuffer(graphics);
        this.setBackBuffer(graphics2, n);
    }

    public boolean hasFrontBuffer() {
        return this.frontBuffer != null;
    }

    public boolean hasBackBuffer() {
        return this.backBuffer != null;
    }

    public boolean hasBuffers() {
        return this.hasFrontBuffer() && this.hasBackBuffer();
    }

    public void clearBackBuffer() {
        this.clearBackBuffer(this.backBufferColor);
    }

    public void clearBackBuffer(int n) {
        if (!this.hasBackBuffer()) {
            throw new IllegalStateException("BackBuffer NOT set, unable to clear!");
        }
        this.backBuffer.setColor(n);
        this.backBuffer.fillRect(0, 0, this.viewWidth, this.viewHeight);
    }

    public int convertXWorldToView(double d) {
        return (int)((d - this.visibleWorld.x) * this.zoomFactor * this.WYSIWYGScaleX);
    }

    public int convertYWorldToView(double d) {
        return (int)((d - this.visibleWorld.y) * this.zoomFactor * this.WYSIWYGScaleY);
    }

    public int convertXDistanceWorldToView(double d) {
        return (int)(d * this.zoomFactor * this.WYSIWYGScaleX);
    }

    public int convertYDistanceWorldToView(double d) {
        return (int)(d * this.zoomFactor * this.WYSIWYGScaleY);
    }

    public int convertMinDistanceWorldToView(double d) {
        if (this.WYSIWYGScaleX < this.WYSIWYGScaleX) {
            return this.convertXDistanceWorldToView(d);
        }
        return this.convertYDistanceWorldToView(d);
    }

    public double convertXViewToWorld(int n) {
        return this.visibleWorld.x + (double)n / (this.zoomFactor * this.WYSIWYGScaleX);
    }

    public double convertYViewToWorld(int n) {
        return this.visibleWorld.y + (double)n / (this.zoomFactor * this.WYSIWYGScaleY);
    }

    public double convertXDistanceViewToWorld(int n) {
        return (double)n / (this.zoomFactor * this.WYSIWYGScaleX);
    }

    public double convertYDistanceViewToWorld(int n) {
        return (double)n / (this.zoomFactor * this.WYSIWYGScaleY);
    }

    public double convertMaxDistanceViewToWorld(int n) {
        if (this.WYSIWYGScaleX < this.WYSIWYGScaleY) {
            return this.convertXDistanceViewToWorld(n);
        }
        return this.convertYDistanceViewToWorld(n);
    }

    public void setWorldViewPoint(double d, double d2) {
        this.visibleWorld.x = 0.0;
        this.visibleWorld.y = 0.0;
        this.visibleWorld.width = this.convertXDistanceViewToWorld(this.viewWidth);
        this.visibleWorld.height = this.convertYDistanceViewToWorld(this.viewHeight);
        this.visibleWorld.x = this.minX <= d ? (this.maxX >= d ? d - this.visibleWorld.width / 2.0 : this.maxX - this.visibleWorld.width / 2.0) : this.minX - this.visibleWorld.width / 2.0;
        this.visibleWorld.y = this.minY <= d2 ? (this.maxY >= d2 ? d2 - this.visibleWorld.height / 2.0 : this.maxY - this.visibleWorld.height / 2.0) : this.minY - this.visibleWorld.height / 2.0;
        this.viewCenterWorldX = this.visibleWorld.x + this.visibleWorld.width / 2.0;
        this.viewCenterWorldY = this.visibleWorld.y + this.visibleWorld.height / 2.0;
    }

    public void pan(int n, int n2) {
        this.setWorldViewPoint(this.viewCenterWorldX - this.convertXDistanceViewToWorld(n), this.viewCenterWorldY - this.convertYDistanceViewToWorld(n2));
    }

    public void setZoomFactor(double d) {
        this.zoomFactor = d >= 1.0 ? Math.min(d, 8.0) : Math.max(d, 0.0625);
    }

    public boolean zoomIn(int n, int n2) {
        if (this.zoomFactor < 8.0) {
            this.setZoomFactor(this.zoomFactor * 2.0);
            this.setWorldViewPoint(this.convertXViewToWorld(n), this.convertYViewToWorld(n2));
            return true;
        }
        return false;
    }

    public void centerViewPoint() {
        this.setWorldViewPoint(this.viewCenterWorldX, this.viewCenterWorldY);
    }

    public boolean zoomIn() {
        if (this.zoomFactor < 8.0) {
            this.setZoomFactor(this.zoomFactor * 2.0);
            this.centerViewPoint();
            return true;
        }
        return false;
    }

    public boolean zoomOut() {
        if (this.zoomFactor > 0.0625) {
            this.setZoomFactor(this.zoomFactor / 2.0);
            this.centerViewPoint();
            return true;
        }
        return false;
    }

    public boolean noZoom() {
        if (this.zoomFactor != 1.0) {
            this.setZoomFactor(1.0);
            this.centerViewPoint();
            return true;
        }
        return false;
    }

    public boolean setXFitZoom(double d) {
        double d2 = this.zoomFactor;
        this.setZoomFactor((double)this.viewWidth / (Math.abs(d) * this.WYSIWYGScaleX));
        return this.zoomFactor != d2;
    }

    public boolean setYFitZoom(double d) {
        double d2 = this.zoomFactor;
        this.setZoomFactor((double)this.viewHeight / (Math.abs(d) * this.WYSIWYGScaleY));
        return this.zoomFactor != d2;
    }

    public boolean setXYFitZoom(double d, double d2) {
        double d3 = this.zoomFactor;
        this.setZoomFactor(Math.min((double)this.viewWidth / (Math.abs(d) * this.WYSIWYGScaleX), (double)this.viewHeight / (Math.abs(d2) * this.WYSIWYGScaleY)));
        return this.zoomFactor != d3;
    }

    private void configureWYSIWYG() {
        if (!this.forcedResolution) {
            this.WYSIWYGScaleY = this.WYSIWYGScaleX = 72.0;
        }
    }

    public boolean setRanges(double d, double d2, double d3, double d4) {
        if (d3 > 0.0 && d4 > 0.0) {
            double d5 = d - d3;
            double d6 = d2 - d4;
            double d7 = d3 * 3.0;
            double d8 = d4 * 3.0;
            this.minX = d5;
            this.maxX = d5 + d7;
            this.minY = d6;
            this.maxY = d6 + d8;
            return true;
        }
        return false;
    }

    public double getViewCenterWorldX() {
        return this.viewCenterWorldX;
    }

    public double getViewCenterWorldY() {
        return this.viewCenterWorldY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }
}

