/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import javax.microedition.lcdui.Graphics;
import ntr.ttme.DoublePolygon;
import ntr.ttme.IntPolygon;
import ntr.ttme.Polyline;

public class SplineCurveRenderer {
    public static final int DEFAULT_NUMBER_OF_SPLINE_POINTS = 5;
    int numberOfSplinePoints;
    IntPolygon points;
    DoublePolygon worldPoints;

    public SplineCurveRenderer() {
        this(5);
    }

    public SplineCurveRenderer(int n) {
        this.numberOfSplinePoints = n;
        this.points = new IntPolygon();
        this.worldPoints = new DoublePolygon(n);
    }

    public void RawDrawSpline(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.calculateWorldSpline(n, n2, n3, n4, n5, n6);
        this.points.npoints = 0;
        for (int i = 0; i < this.worldPoints.getNumberOfPoints(); ++i) {
            this.points.addPoint((int)this.worldPoints.getPointX(i), (int)this.worldPoints.getPointY(i));
        }
        graphics.setColor(n7);
        Polyline.draw(graphics, this.points.xpoints, this.points.ypoints, this.points.npoints);
    }

    public void calculateWorldSpline(double d, double d2, double d3, double d4, double d5, double d6) {
        this.worldPoints.clear();
        this.worldPoints.addPoint(d, d2);
        for (int i = 0; i <= this.numberOfSplinePoints; ++i) {
            double d7 = (double)i / (double)this.numberOfSplinePoints;
            double d8 = 1.0 - d7;
            double d9 = d8 * d8;
            double d10 = d7 * d7;
            double d11 = 2.0 * d7 * d8;
            this.worldPoints.addPoint(d9 * d + d11 * d3 + d10 * d5, d9 * d2 + d11 * d4 + d10 * d6);
        }
    }
}

