/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import ntr.ttme.DoubleMatrix3x3;
import ntr.ttme.Transformable;

public abstract class MatrixTransformationAdapter
implements Transformable {
    protected boolean modified;
    protected DoubleMatrix3x3 ctm = DoubleMatrix3x3.createIdentityMatrix();

    protected MatrixTransformationAdapter() {
    }

    public void translate(double d, double d2) {
        this.ctm.rightMul(DoubleMatrix3x3.translate(d, d2));
        this.modified = true;
    }

    public void rotate(double d) {
        this.ctm.rightMul(DoubleMatrix3x3.rotate(d));
        this.modified = true;
    }

    public void rotate(double d, double d2, double d3) {
        this.ctm.rightMul(DoubleMatrix3x3.rotate(d, d2, d3));
        this.modified = true;
    }

    public void scale(double d, double d2) {
        this.ctm.rightMul(DoubleMatrix3x3.scale(d, d2));
        this.modified = true;
    }

    public void scale(double d, double d2, double d3, double d4, double d5, double d6) {
        this.ctm.rightMul(DoubleMatrix3x3.scale(d, d2, d3, d4, d5, d6));
        this.modified = true;
    }

    public void skew(double d) {
        this.ctm.rightMul(DoubleMatrix3x3.skew(d));
        this.modified = true;
    }

    public void skew(double d, double d2, double d3) {
        this.ctm.rightMul(DoubleMatrix3x3.skew(d, d2, d3));
        this.modified = true;
    }
}

