/*
 * Decompiled with CFR 0.152.
 */
package drivehub.client;

import drivehub.client.DirectBOS;
import drivehub.client.SensorData;
import drivehub.client.SensorRecordStore;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SensorCollector {
    private int maxBulkSize = 2048;
    Hashtable paramStorage = new Hashtable();
    private SensorRecordStore adapter;
    long tripStamp = 0L;

    public SensorCollector(SensorRecordStore sensorRecordStore) {
        this.adapter = sensorRecordStore;
    }

    public void addParameter(String string, int n, boolean bl) {
        SensorData sensorData = new SensorData();
        sensorData.updateInterval = n;
        sensorData.optionAverage = bl;
        this.paramStorage.put(string, sensorData);
    }

    public void removeParameter(String string) {
        this.paramStorage.remove(string);
    }

    public void deactivate() {
        Enumeration enumeration = this.paramStorage.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SensorData sensorData = (SensorData)this.paramStorage.get(string);
            if (sensorData.list_bos == null) continue;
            this.adapter.storeRecord(sensorData.list_bos.getBuffer(), sensorData.list_bos.size());
        }
        this.paramStorage.clear();
    }

    public void recordValue(String string, long l, float f) throws IOException {
        SensorData sensorData = (SensorData)this.paramStorage.get(string);
        if (sensorData.list_bos != null && sensorData.list_bos.size() >= this.maxBulkSize) {
            this.adapter.storeRecord(sensorData.list_bos.getBuffer(), sensorData.list_bos.size());
            sensorData.list_bos = null;
        }
        if (sensorData.list_bos == null) {
            sensorData.list_bos = new DirectBOS(this.maxBulkSize);
            sensorData.list_dos = new DataOutputStream(sensorData.list_bos);
            sensorData.list_dos.writeLong(this.tripStamp);
            sensorData.list_dos.writeUTF(string);
            sensorData.list_dos.writeByte(254);
            sensorData.list_dos.writeLong(l);
            sensorData.currentInterval = 1 + sensorData.updateInterval / 10;
            if (sensorData.currentInterval > Short.MAX_VALUE) {
                sensorData.currentInterval = Short.MAX_VALUE;
            }
            sensorData.list_dos.writeByte(255);
            sensorData.list_dos.writeShort(sensorData.currentInterval);
            sensorData.last_ts = l;
            sensorData.currentAveraged = 0.0f;
            sensorData.averagedNo = 0;
        }
        long l2 = l - sensorData.last_ts;
        if (sensorData.optionAverage) {
            sensorData.currentAveraged = (sensorData.currentAveraged * (float)sensorData.averagedNo + f) / (float)(sensorData.averagedNo + 1);
            ++sensorData.averagedNo;
        } else {
            sensorData.currentAveraged = f;
        }
        if (l2 >= (long)sensorData.updateInterval || l2 == 0L) {
            int n = (int)(l2 / (long)sensorData.currentInterval);
            if (n >= 254) {
                sensorData.list_dos.writeByte(254);
                sensorData.list_dos.writeLong(sensorData.last_ts);
                n = 0;
            }
            sensorData.list_dos.writeByte(n);
            sensorData.list_dos.writeFloat(sensorData.currentAveraged);
            sensorData.last_ts = l;
            sensorData.currentAveraged = 0.0f;
            sensorData.averagedNo = 0;
        }
    }

    public void setTripStamp(long l) {
        this.tripStamp = l;
    }

    public long getTripStamp() {
        return this.tripStamp;
    }

    public void setMaxBulkSize(int n) {
        this.maxBulkSize = n;
    }
}

