/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.profile.gauge;

import com.mympgtracker.ecutracker.profile.color.ColorModel;
import com.mympgtracker.ecutracker.profile.gauge.AbstractAnalogGauge;
import com.mympgtracker.util.Coord;
import com.mympgtracker.util.Rect;
import javax.microedition.lcdui.Graphics;

public class SweepAnalogGauge
extends AbstractAnalogGauge {
    public static final String PC_TOP_LEFT = "top-left";
    public static final String PC_TOP_RIGHT = "top-right";
    public static final String PC_TOP_MIDDLE = "top-middle";
    public static final String PC_BOTTOM_LEFT = "bottom-left";
    public static final String PC_BOTTOM_RIGHT = "bottom-right";
    public static final String PC_BOTTOM_MIDDLE = "bottom-middle";
    public static final String PC_MIDDLE_LEFT = "middle-left";
    public static final String PC_MIDDLE_RIGHT = "middle-right";
    protected static final String PROP_S_PIVIOT = "pivot";
    private static final double PIVOT_PERCENT_GAP = 0.05;
    private boolean anglesAreSet_ = false;

    public SweepAnalogGauge() {
        this.outerRingRadiusPrecent_ = 0.9299999999999999;
        this.tickMarkOuterRadiusPrecent_ = 0.9099999999999999;
        this.tickMarkLengthPercent_ = 0.04;
        this.needleWidthPrecent_ = 0.02;
        this.needleTailPrecent_ = 0.025;
        this.minimumAngle_ = 90;
        this.maximumAngle_ = 180;
        this.ringStartAngle_ = this.minimumAngle_;
        this.ringEndAngle_ = this.maximumAngle_;
    }

    public String getPivotCode() {
        return this.getProperty(PROP_S_PIVIOT, PC_BOTTOM_RIGHT);
    }

    public Coord getPivotPoint(Rect rect) {
        Coord coord = null;
        int n = (int)(Math.min((double)rect.width, (double)rect.height) * 0.05);
        if (PC_TOP_LEFT.equals(this.getPivotCode())) {
            coord = new Coord(rect.x + n, rect.y + n);
        } else if (!PC_TOP_MIDDLE.equals(this.getPivotCode())) {
            if (PC_TOP_RIGHT.equals(this.getPivotCode())) {
                coord = new Coord(rect.x + rect.width - n, rect.y + n);
            } else if (PC_BOTTOM_LEFT.equals(this.getPivotCode())) {
                coord = new Coord(rect.x + n, rect.y + rect.height - n);
            } else if (!PC_BOTTOM_MIDDLE.equals(this.getPivotCode()) && PC_BOTTOM_RIGHT.equals(this.getPivotCode())) {
                coord = new Coord(rect.x + rect.width - n, rect.y + rect.height - n);
            }
        }
        return coord;
    }

    public void render(Graphics graphics, Rect rect, ColorModel colorModel, boolean bl) {
        if (!this.anglesAreSet_) {
            this.labelDistanceFromPivotPercentX_ = 1.0;
            this.labelDistanceFromPivotPercentY_ = 1.0;
            this.digitalDistanceFromPivotPercentX_ = 0.3;
            this.digitalDistanceFromPivotPercentY_ = 0.3;
            this.labelAnchor_ = 40;
            this.digitalAnchor_ = 17;
            if (PC_TOP_LEFT.equals(this.getPivotCode())) {
                this.minimumAngle_ = 270;
                this.maximumAngle_ = 360;
            } else if (PC_TOP_MIDDLE.equals(this.getPivotCode())) {
                this.minimumAngle_ = 270;
                this.maximumAngle_ = 90;
            } else if (PC_TOP_RIGHT.equals(this.getPivotCode())) {
                this.minimumAngle_ = 0;
                this.maximumAngle_ = 90;
                this.labelDistanceFromPivotPercentX_ *= -1.0;
                this.digitalDistanceFromPivotPercentX_ *= -1.0;
                this.labelAnchor_ = 36;
            } else if (PC_BOTTOM_LEFT.equals(this.getPivotCode())) {
                this.minimumAngle_ = 180;
                this.maximumAngle_ = 270;
                this.labelDistanceFromPivotPercentY_ *= -1.0;
                this.digitalDistanceFromPivotPercentY_ *= -1.0;
                this.labelAnchor_ = 24;
                this.digitalAnchor_ = 33;
            } else if (PC_BOTTOM_MIDDLE.equals(this.getPivotCode())) {
                this.minimumAngle_ = 90;
                this.maximumAngle_ = 270;
            } else if (PC_BOTTOM_RIGHT.equals(this.getPivotCode())) {
                this.minimumAngle_ = 90;
                this.maximumAngle_ = 180;
                this.labelDistanceFromPivotPercentX_ *= -1.0;
                this.labelDistanceFromPivotPercentY_ *= -1.0;
                this.digitalDistanceFromPivotPercentX_ *= -1.0;
                this.digitalDistanceFromPivotPercentY_ *= -1.0;
                this.labelAnchor_ = 20;
                this.digitalAnchor_ = 33;
            }
            this.ringStartAngle_ = this.minimumAngle_;
            this.ringEndAngle_ = this.maximumAngle_;
            this.anglesAreSet_ = true;
        }
        super.render(graphics, rect, colorModel, bl);
    }
}

