/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.profile.gauge;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.ValueChangedListener;
import com.mympgtracker.ecutracker.ecu.param.ValueConsumer;
import com.mympgtracker.ecutracker.profile.ProfileRenderer;
import com.mympgtracker.ecutracker.profile.color.ColorModel;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Convert;
import com.mympgtracker.util.Coord;
import com.mympgtracker.util.Rect;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public abstract class ProfileGauge
implements ValueChangedListener,
ValueConsumer,
Cleanable {
    protected static final String BOOLEAN_TRUE = "true";
    protected static final String BOOLEAN_FALSE = "false";
    public static final String PROP_STR_LABEL = "label";
    public static final String PROP_STR_PARAMETER_NAME = "param";
    public static final String PROP_D_WIDTH = "width";
    public static final String PROP_I_UPDATE_FREQUENCY = "update-frequency";
    public static final String PROP_D_RANGE_RED = "range-red";
    public static final String PROP_D_RANGE_GREEN = "range-green";
    private long lastUpdateTime_ = -1L;
    private Hashtable props_ = new Hashtable(3);
    private Hashtable bProps_ = new Hashtable();
    private Hashtable iProps_ = new Hashtable();
    private Hashtable dProps_ = new Hashtable();
    protected static final double NULL_DOUBLE = -9.999999999999998E13;
    private ECUParameter param_ = null;
    protected Rect currentRect_ = null;
    protected ColorModel currentColorModel_ = null;
    protected ProfileRenderer profileRenderer_ = null;

    public void cleanYourRoom() {
        this.param_ = null;
        this.currentRect_ = null;
        this.currentColorModel_ = null;
        this.profileRenderer_ = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("type: " + this.getClass().getName() + "\n");
        Enumeration enumeration = this.props_.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = this.getProperty(string);
            stringBuffer.append("  " + string + ": " + string2 + "\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean isReadyToReceiveValues() {
        if (this.profileRenderer_ == null) {
            return false;
        }
        int n = this.getIntProperty(PROP_I_UPDATE_FREQUENCY, -1);
        if (n >= 0 && System.currentTimeMillis() - (long)n < this.lastUpdateTime_) {
            return false;
        }
        return this.profileRenderer_.isGaugeVisible(this);
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime_;
    }

    public void onValueChanged(ECUParameter eCUParameter) {
        this.lastUpdateTime_ = System.currentTimeMillis();
    }

    public void setProfileRenderer(ProfileRenderer profileRenderer) {
        this.profileRenderer_ = profileRenderer;
    }

    public void setECUParameter(ECUParameter eCUParameter) {
        this.param_ = eCUParameter;
        this.param_.addValueConsumer(this);
    }

    public ECUParameter getECUParameter() {
        return this.param_;
    }

    public String getProperty(String string) {
        return (String)this.props_.get(string);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public void setProperty(String string, String string2) {
        this.props_.put(string, string2);
        this.iProps_.remove(string);
        this.dProps_.remove(string);
        this.bProps_.remove(string);
    }

    public int getIntProperty(String string, int n) {
        Integer n2 = (Integer)this.iProps_.get(string);
        if (n2 != null) {
            return n2;
        }
        String string2 = this.getProperty(string);
        n2 = string2 == null ? new Integer(n) : new Integer(Convert.toInt(string2));
        this.iProps_.put(string, n2);
        return n2;
    }

    public void setIntProperty(String string, int n) {
        this.setProperty(string, Convert.toString(n));
    }

    public double getDoubleProperty(String string, double d) {
        Double d2 = (Double)this.dProps_.get(string);
        if (d2 != null) {
            return d2;
        }
        String string2 = this.getProperty(string);
        d2 = string2 == null ? new Double(d) : new Double(Convert.toDouble(string2));
        this.dProps_.put(string, d2);
        return d2;
    }

    public void setDoubleProperty(String string, double d) {
        this.setProperty(string, Convert.toString(d));
    }

    public boolean getBooleanProperty(String string) {
        Boolean bl = (Boolean)this.bProps_.get(string);
        if (bl != null) {
            return bl;
        }
        String string2 = this.getProperty(string);
        bl = new Boolean(BOOLEAN_TRUE.equalsIgnoreCase(string2));
        return bl;
    }

    public void setBooleanProperty(String string, boolean bl) {
        if (bl) {
            this.setProperty(string, BOOLEAN_TRUE);
        } else {
            this.setProperty(string, BOOLEAN_FALSE);
        }
    }

    protected void fillPolygon(Graphics graphics, Coord[] coordArray) {
        for (int i = 0; i < coordArray.length - 2; ++i) {
            graphics.fillTriangle(coordArray[0].x, coordArray[0].y, coordArray[i + 1].x, coordArray[i + 1].y, coordArray[i + 2].x, coordArray[i + 2].y);
        }
    }

    protected void drawPolygon(Graphics graphics, Coord[] coordArray) {
        for (int i = 0; i < coordArray.length; ++i) {
            if (i < coordArray.length - 1) {
                graphics.drawLine(coordArray[i].x, coordArray[i].y, coordArray[i + 1].x, coordArray[i + 1].y);
                continue;
            }
            graphics.drawLine(coordArray[i].x, coordArray[i].y, coordArray[0].x, coordArray[0].y);
        }
    }

    protected void drawCircle(Graphics graphics, Coord coord, int n) {
        graphics.drawArc(coord.x - n, coord.y - n, n * 2, n * 2, 0, 360);
    }

    protected void fillCircle(Graphics graphics, Coord coord, int n) {
        graphics.fillArc(coord.x - n, coord.y - n, n * 2, n * 2, 0, 360);
    }

    protected void drawArc(Graphics graphics, Coord coord, int n, int n2, int n3) {
        graphics.drawArc(coord.x - n, coord.y - n, n * 2, n * 2, -90 - n2, n3 * -1);
    }

    protected void fillArc(Graphics graphics, Coord coord, int n, int n2, int n3) {
        graphics.fillArc(coord.x - n, coord.y - n, n * 2, n * 2, -90 - n2, n3 * -1);
    }

    protected boolean isRangeRedGreenValid() {
        double d;
        double d2 = this.getDoubleProperty(PROP_D_RANGE_GREEN, -1.0);
        return Math.abs(d2 - (d = this.getDoubleProperty(PROP_D_RANGE_RED, -1.0))) > 0.01;
    }

    protected double getRangeRed(double d) {
        double d2;
        double d3 = this.getDoubleProperty(PROP_D_RANGE_GREEN, -1.0);
        if (d < Math.min(d3, d2 = this.getDoubleProperty(PROP_D_RANGE_RED, -1.0))) {
            d = Math.min(d3, d2);
        }
        if (d > Math.max(d3, d2)) {
            d = Math.max(d3, d2);
        }
        double d4 = (d - d3) / (d2 - d3);
        return d4;
    }

    protected int getRangeColor(double d, int n) {
        double d2 = this.getRangeRed(d);
        int n2 = 128;
        int n3 = 255 - n2;
        int n4 = n;
        if (n4 > n2) {
            n4 = n2;
        }
        int n5 = (int)((double)n4 + (double)n3 * d2);
        int n6 = (int)((double)n4 + (double)n3 * (1.0 - d2));
        return (n5 << 16) + (n6 << 8) + n4;
    }

    public abstract void render(Graphics var1, Rect var2, ColorModel var3, boolean var4);
}

