/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.profile.gauge;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.profile.ProfileRenderer;
import com.mympgtracker.ecutracker.profile.color.ColorModel;
import com.mympgtracker.ecutracker.profile.gauge.ProfileGauge;
import com.mympgtracker.ecutracker.profile.text.TTFTextRenderer;
import com.mympgtracker.ecutracker.profile.text.TextRendererCache;
import com.mympgtracker.util.CircularIndex;
import com.mympgtracker.util.Convert;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.Rect;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LineGraphGauge
extends ProfileGauge {
    private static final String PROP_D_RANGE_START = "range-start";
    private static final String PROP_D_RANGE_END = "range-end";
    private static final String PROP_I_PRECISION = "precision";
    private static final String PROP_B_INCLUDE_HIGH_LINE = "include-high-line";
    private static final String PROP_B_INCLUDE_LOW_LINE = "include-low-line";
    private static final String PROP_B_FLIP = "flip";
    private static final String PROP_B_INCLUDE_GHOST_VALUE = "include-ghost-value";
    private static final String PROP_B_INCLUDE_SIDE_VALUES = "include-side-values";
    private Rect lastRect_ = null;
    private Image staticContent_ = null;
    private HistoryValue[] valueHistory_ = null;
    private CircularIndex historyIndex_ = null;
    private Font labelFont_ = null;
    private boolean doNextRender_ = true;

    public double getRangeStart() {
        return this.getDoubleProperty(PROP_D_RANGE_START, -9.999999999999998E13);
    }

    public void setRangeStart(double d) {
        this.setDoubleProperty(PROP_D_RANGE_START, d);
    }

    public double getRangeEnd() {
        return this.getDoubleProperty(PROP_D_RANGE_END, -9.999999999999998E13);
    }

    public void setRangeEnd(double d) {
        this.setDoubleProperty(PROP_D_RANGE_END, d);
    }

    public boolean getFlip() {
        return this.getBooleanProperty(PROP_B_FLIP);
    }

    public boolean getIncludeHighLine() {
        return this.getBooleanProperty(PROP_B_INCLUDE_HIGH_LINE);
    }

    public boolean getIncludeLowLine() {
        return this.getBooleanProperty(PROP_B_INCLUDE_LOW_LINE);
    }

    public boolean getIncludeSideValues() {
        if (this.getProperty(PROP_B_INCLUDE_SIDE_VALUES) == null) {
            return true;
        }
        return this.getBooleanProperty(PROP_B_INCLUDE_SIDE_VALUES);
    }

    public int getPrecision() {
        return this.getIntProperty(PROP_I_PRECISION, 0);
    }

    public boolean includeGhostValue() {
        return this.getBooleanProperty(PROP_B_INCLUDE_GHOST_VALUE);
    }

    protected void finalize() throws Throwable {
        this.getECUParameter().removeValueChangedListener(this);
    }

    public void onValueChanged(ECUParameter eCUParameter) {
        super.onValueChanged(eCUParameter);
        if (this.valueHistory_ == null || this.historyIndex_ == null || this.getECUParameter() == null) {
            return;
        }
        if (this.valueHistory_[this.historyIndex_.getHead()].getTimestamp() < this.getECUParameter().getTimeStamp()) {
            this.historyIndex_.decrementHead();
            this.valueHistory_[this.historyIndex_.getHead()].setValue(this.getECUParameter().getValue());
            this.valueHistory_[this.historyIndex_.getHead()].setTimestamp(this.getECUParameter().getTimeStamp());
        }
        this.doNextRender_ = true;
    }

    public void setECUParameter(ECUParameter eCUParameter) {
        super.setECUParameter(eCUParameter);
        eCUParameter.addValueChangedListener(this);
    }

    public void render(Graphics graphics, Rect rect, ColorModel colorModel, boolean bl) {
        if (this.valueHistory_ == null || rect.width != this.valueHistory_.length) {
            this.valueHistory_ = new HistoryValue[rect.width];
            this.historyIndex_ = new CircularIndex(this.valueHistory_.length);
            this.historyIndex_.resetIndex();
            for (int i = 0; i < this.historyIndex_.getSize(); ++i) {
                this.valueHistory_[this.historyIndex_.getIndex()] = new HistoryValue(0.0, -1L);
                this.historyIndex_.incrementIndex();
            }
        }
        if (bl || this.doNextRender_ || !rect.equals(this.lastRect_) || colorModel != this.currentColorModel_) {
            this.renderStatic(graphics, colorModel, rect);
            this.renderDynamic(graphics, rect, colorModel);
        }
        this.lastRect_ = rect;
        this.currentColorModel_ = colorModel;
        this.doNextRender_ = false;
    }

    public void renderDynamic(Graphics graphics, Rect rect, ColorModel colorModel) {
        int n;
        double d = this.getRangeStart();
        double d2 = this.getRangeEnd();
        int n2 = rect.y + rect.height + 1;
        int n3 = rect.y - 1;
        int n4 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        this.historyIndex_.resetIndex();
        if (this.isRangeRedGreenValid()) {
            n = this.getRangeColor(this.valueHistory_[this.historyIndex_.getHead()].getValue(), colorModel.get(501).value());
            graphics.setColor(n);
            graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        graphics.setColor(colorModel.get(500).value());
        n = -1;
        for (int i = 0; i < this.historyIndex_.getSize(); ++i) {
            HistoryValue historyValue = this.valueHistory_[this.historyIndex_.getIndex()];
            if (i == 0) {
                d4 = historyValue.getValue();
            }
            if (i == 0 && this.includeGhostValue()) {
                try {
                    int n5 = (int)((double)rect.height * 0.5);
                    String string = TTFTextRenderer.generateKey("bombardier.ttf", n5, colorModel.get(504));
                    TTFTextRenderer tTFTextRenderer = (TTFTextRenderer)TextRendererCache.get(string);
                    if (tTFTextRenderer == null) {
                        tTFTextRenderer = new TTFTextRenderer("bombardier.ttf", n5, colorModel.get(504));
                        TextRendererCache.put(string, tTFTextRenderer);
                    }
                    tTFTextRenderer.drawText(graphics, Convert.toString(d4, this.getPrecision()), rect.x + rect.width / 2, rect.y + rect.height / 2, true, true);
                }
                catch (Exception exception) {
                    Log.warn(this, "Unable to draw value text " + exception.getMessage());
                }
            }
            if (historyValue.getValue() > -9.999999999999998E13 && historyValue.getTimestamp() > 0L) {
                ++n4;
                d3 += historyValue.getValue();
                double d5 = Math.max(Math.min(historyValue.getValue(), this.getRangeEnd()), this.getRangeStart());
                int n6 = (int)((double)rect.height * ((d5 - this.getRangeStart()) / (this.getRangeEnd() - this.getRangeStart())));
                n6 = rect.y + rect.height - n6;
                n2 = Math.min(n2, n6);
                n3 = Math.max(n3, n6);
                d = Math.max(d, historyValue.getValue());
                d2 = Math.min(d2, historyValue.getValue());
                graphics.drawLine(rect.x + rect.width - i, n6, rect.x + rect.width - i + 1, n);
                n = n6;
            }
            this.historyIndex_.incrementIndex();
        }
        if (this.getIncludeHighLine()) {
            graphics.setFont(this.labelFont_);
            graphics.setColor(colorModel.get(502).value());
            if (n2 < rect.y + rect.height && n2 > rect.y) {
                graphics.drawLine(rect.x, n2, rect.x + rect.width, n2);
            }
        }
        if (this.getIncludeLowLine()) {
            graphics.setColor(colorModel.get(503).value());
            if (n3 < rect.y + rect.height && n3 > rect.y) {
                graphics.drawLine(rect.x, n3, rect.x + rect.width, n3);
            }
        }
        if (n4 != 0) {
            d3 /= (double)n4;
        }
        graphics.setColor(colorModel.get(202).value());
        if (this.getIncludeSideValues()) {
            graphics.drawString(Convert.toString(d, this.getPrecision()), rect.x + 5, rect.y + 5, 20);
            graphics.drawString(Convert.toString(d3, this.getPrecision()), rect.x + 5, rect.y + rect.height / 2 - this.labelFont_.getHeight() / 2, 20);
            graphics.drawString(Convert.toString(d2, this.getPrecision()), rect.x + 5, rect.y + rect.height - 5, 36);
        }
        if (!this.includeGhostValue()) {
            graphics.drawString(Convert.toString(d4, this.getPrecision()), rect.x + rect.width - 5, rect.y + 5, 24);
        }
    }

    private void renderStatic(Graphics graphics, ColorModel colorModel, Rect rect) {
        this.labelFont_ = ProfileRenderer.findFontBestFitHeight((int)((double)rect.height * 0.15), false);
        graphics.setClip(rect.x, rect.y, rect.width, rect.height);
        if (this.getRangeStart() == -9.999999999999998E13) {
            throw new RuntimeException("Range Start value not set in gauge profile");
        }
        if (this.getRangeEnd() == -9.999999999999998E13) {
            throw new RuntimeException("Range End value not set in gauge profile");
        }
        graphics.setColor(colorModel.get(501).value());
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        graphics.setColor(colorModel.get(201).value());
        graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        String string = this.getProperty("label");
        if (string != null) {
            graphics.setFont(this.labelFont_);
            graphics.setColor(colorModel.get(202).value());
            graphics.drawString(string, rect.x + rect.width - 5, rect.y + rect.height - 5, 40);
        }
        graphics.setClip(0, 0, 1000, 1000);
    }

    private static class HistoryValue {
        private double value_ = 0.0;
        private long timestamp_ = 0L;

        public HistoryValue(double d, long l) {
            this.value_ = d;
            this.timestamp_ = l;
        }

        public double getValue() {
            return this.value_;
        }

        public void setValue(double d) {
            this.value_ = d;
        }

        public long getTimestamp() {
            return this.timestamp_;
        }

        public void setTimestamp(long l) {
            this.timestamp_ = l;
        }

        public String toString() {
            return "[t" + this.getTimestamp() + "][v" + this.getValue() + "]";
        }
    }
}

