/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.profile;

import com.mympgtracker.ecutracker.ecu.comm.ProtocolHandler;
import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.profile.PageBar;
import com.mympgtracker.ecutracker.profile.Profile;
import com.mympgtracker.ecutracker.profile.ProfilePage;
import com.mympgtracker.ecutracker.profile.ProfileRow;
import com.mympgtracker.ecutracker.profile.StatusBar;
import com.mympgtracker.ecutracker.profile.color.ColorModel;
import com.mympgtracker.ecutracker.profile.gauge.ProfileGauge;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Coord;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.Rect;
import com.mympgtracker.util.TrackerException;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ProfileRenderer
implements Cleanable {
    public static final Font[] AVAILABLE_FONTS = new Font[]{Font.getFont((int)0)};
    private boolean refreshPageBar_ = true;
    private Profile profile_ = null;
    private PageBar pageBar_ = null;
    private StatusBar statusBar_ = null;
    private int currentlyActivePage_ = 0;
    private Rect previousRect_ = new Rect();
    private Hashtable rectCache_ = new Hashtable(4);
    private boolean firstTimeRender_ = true;
    private boolean displayChangeForceRedraw_ = false;

    public ProfileRenderer(Profile profile, ProtocolHandler protocolHandler) throws Exception {
        this.profile_ = profile;
        this.pageBar_ = new PageBar();
        this.statusBar_ = new StatusBar();
        for (int i = 0; i < profile.getPageCount(); ++i) {
            ProfilePage profilePage = profile.getPage(i);
            for (int j = 0; j < profilePage.getRowCount(); ++j) {
                ProfileRow profileRow = profilePage.getRow(j);
                for (int k = 0; k < profileRow.getGaugeCount(); ++k) {
                    ProfileGauge profileGauge = profileRow.getGauge(k);
                    profileGauge.setProfileRenderer(this);
                    ECUParameter eCUParameter = protocolHandler.getParameterRegistry().get(profileGauge.getProperty("param"));
                    if (eCUParameter == null) {
                        String string = Lang.get("profile.page") + "(" + (i + 1) + ") ";
                        string = string + Lang.get("profile.row") + "(" + (j + 1) + ") ";
                        string = string + Lang.get("profile.gauge") + "(" + (k + 1) + ") ";
                        string = string + Lang.get("profile.error.unknown_param");
                        string = string + " [" + profileGauge.getProperty("param") + "]. ";
                        string = string + Lang.get("profile.error.resolution1") + " ";
                        throw new Exception(string);
                    }
                    profileGauge.setECUParameter(eCUParameter);
                    eCUParameter.addValueChangedListener(profileGauge);
                }
            }
        }
        this.pageBar_.setPageCount(profile.getPageCount());
    }

    public void cleanYourRoom() {
        for (int i = 0; i < this.profile_.getPageCount(); ++i) {
            ProfilePage profilePage = this.profile_.getPage(i);
            for (int j = 0; j < profilePage.getRowCount(); ++j) {
                ProfileRow profileRow = profilePage.getRow(j);
                for (int k = 0; k < profileRow.getGaugeCount(); ++k) {
                    ProfileGauge profileGauge = profileRow.getGauge(k);
                    profileGauge.cleanYourRoom();
                }
            }
        }
        this.profile_ = null;
    }

    public static Font findFontBestFitHeight(int n, boolean bl) {
        Font font = null;
        for (int i = 0; i < AVAILABLE_FONTS.length && (font = AVAILABLE_FONTS[i]).getHeight() > n; ++i) {
        }
        return font;
    }

    public static Font findFontBestFitWidth(int n, String string, boolean bl) {
        char[] cArray = string.toCharArray();
        Font font = null;
        for (int i = 0; i < AVAILABLE_FONTS.length && (font = AVAILABLE_FONTS[i]).charsWidth(cArray, 0, cArray.length) > n; ++i) {
        }
        return font;
    }

    public void forceFullRedraw() {
        this.displayChangeForceRedraw_ = true;
        this.refreshPageBar_ = true;
    }

    public PageBar getPageBar() {
        return this.pageBar_;
    }

    public int getActivePage() {
        return this.currentlyActivePage_;
    }

    public StatusBar getStatusBar() {
        return this.statusBar_;
    }

    public void setActivePage(int n) {
        if (n >= this.profile_.getPageCount()) {
            return;
        }
        if (n < 0) {
            return;
        }
        this.forceFullRedraw();
        this.currentlyActivePage_ = n;
        this.pageBar_.setActivePage(this.currentlyActivePage_);
    }

    public boolean isGaugeVisible(ProfileGauge profileGauge) {
        ProfilePage profilePage = this.profile_.getPage(this.currentlyActivePage_);
        for (int i = 0; i < profilePage.getRowCount(); ++i) {
            ProfileRow profileRow = profilePage.getRow(i);
            for (int j = 0; j < profileRow.getGaugeCount(); ++j) {
                ProfileGauge profileGauge2 = profileRow.getGauge(j);
                if (profileGauge != profileGauge2) continue;
                return true;
            }
        }
        return false;
    }

    public Rect getGaugeRect(int n, int n2, int n3) {
        ProfilePage profilePage = this.profile_.getPage(n);
        ProfileRow profileRow = profilePage.getRow(n2);
        ProfileGauge profileGauge = profileRow.getGauge(n3);
        return (Rect)this.rectCache_.get(profileGauge);
    }

    public int getGaugeAt(int n, int n2, int n3) {
        int n4 = this.getRowAt(n, n2, n3);
        if (n4 == -1) {
            return -1;
        }
        ProfilePage profilePage = this.profile_.getPage(n);
        ProfileRow profileRow = profilePage.getRow(n4);
        for (int i = 0; i < profileRow.getGaugeCount(); ++i) {
            ProfileGauge profileGauge = profileRow.getGauge(i);
            Rect rect = (Rect)this.rectCache_.get(profileGauge);
            if (!rect.contains(n2, n3)) continue;
            return i;
        }
        return -1;
    }

    public int getRowAt(int n, int n2, int n3) {
        ProfilePage profilePage = this.profile_.getPage(n);
        for (int i = 0; i < profilePage.getRowCount(); ++i) {
            ProfileRow profileRow = profilePage.getRow(i);
            Rect rect = (Rect)this.rectCache_.get(profileRow);
            if (!rect.contains(n2, n3)) continue;
            return i;
        }
        return -1;
    }

    public void render(Graphics graphics, Rect rect, ColorModel colorModel) throws Exception {
        if (this.profile_ == null) {
            throw new TrackerException(this, "render", Lang.get("config.corrupt"));
        }
        if (this.calculateRects(graphics, rect)) {
            this.forceFullRedraw();
        }
        if (this.firstTimeRender_) {
            for (int i = 0; i < this.profile_.getPageCount(); ++i) {
                if (i == this.currentlyActivePage_) continue;
                this.renderPage(graphics, colorModel, i, true);
            }
            this.renderPage(graphics, colorModel, this.currentlyActivePage_, true);
            this.firstTimeRender_ = false;
        } else {
            this.renderPage(graphics, colorModel, this.currentlyActivePage_, this.displayChangeForceRedraw_);
        }
        this.statusBar_.render(graphics, (Rect)this.rectCache_.get(this.statusBar_), colorModel);
        if (this.refreshPageBar_) {
            this.pageBar_.render(graphics, (Rect)this.rectCache_.get(this.pageBar_), colorModel);
            this.refreshPageBar_ = false;
        }
        this.displayChangeForceRedraw_ = false;
    }

    private void renderPage(Graphics graphics, ColorModel colorModel, int n, boolean bl) throws Exception {
        int n2 = 0;
        int n3 = 0;
        try {
            if (this.profile_.getPageCount() == 0) {
                return;
            }
            ProfilePage profilePage = this.profile_.getPage(n);
            Rect rect = (Rect)this.rectCache_.get(profilePage);
            if (rect == null) {
                throw new Exception("Cannot render page: " + n + " the RECT cache has no entry for it");
            }
            for (n2 = 0; n2 < profilePage.getRowCount(); ++n2) {
                ProfileRow profileRow = profilePage.getRow(n2);
                Rect rect2 = (Rect)this.rectCache_.get(profileRow);
                if (rect2 == null) {
                    throw new Exception("Cannot render row: " + n2 + " the RECT cache has no entry for it");
                }
                for (n3 = 0; n3 < profileRow.getGaugeCount(); ++n3) {
                    ProfileGauge profileGauge = profileRow.getGauge(n3);
                    Rect rect3 = (Rect)this.rectCache_.get(profileGauge);
                    if (rect3 == null) {
                        Log.error(this, "Cannot render gauge: " + n2 + " on row " + n2 + " the RECT cache has no entry for it");
                    }
                    if (profileGauge != null) {
                        this.renderGauge(graphics, rect3, profileGauge, colorModel, bl);
                        continue;
                    }
                    Log.fatal(this, "Row " + n2 + " returned a null gauge at " + n3);
                }
            }
        }
        catch (Exception exception) {
            Log.error(this, "There was an unexpected error rendering gauge " + (n3 + 1) + " on row " + (n2 + 1) + " on page " + (n + 1), exception);
            throw exception;
        }
    }

    private boolean calculateRects(Graphics graphics, Rect rect) throws Exception {
        if (rect.equals(this.previousRect_)) {
            return false;
        }
        this.previousRect_ = rect;
        this.rectCache_.clear();
        Font font = ProfileRenderer.findFontBestFitHeight(1, false);
        Rect rect2 = new Rect();
        rect2.set(rect);
        rect2.height = font.getHeight();
        this.rectCache_.put(this.statusBar_, rect2);
        Rect rect3 = new Rect();
        rect3.set(rect);
        rect3.height = rect.height - rect2.height * 2;
        rect3.y = rect2.y + rect2.height;
        Rect rect4 = new Rect();
        rect4.set(rect2);
        rect4.y = rect3.y + rect3.height;
        this.rectCache_.put(this.pageBar_, rect4);
        for (int i = 0; i < this.profile_.getPageCount(); ++i) {
            int n;
            int n2;
            ProfilePage profilePage = this.profile_.getPage(i);
            this.rectCache_.put(profilePage, rect3);
            if (profilePage.getRowCount() <= 0) continue;
            int[] nArray = new int[profilePage.getRowCount()];
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < profilePage.getRowCount(); ++n2) {
                if (profilePage.getRow(n2).getHeightPercent() > 0.0) {
                    nArray[n2] = (int)(profilePage.getRow(n2).getHeightPercent() * (double)rect3.height);
                    n3 += nArray[n2];
                    continue;
                }
                ++n4;
                nArray[n2] = -1;
            }
            if (n3 > rect3.height) {
                throw new Exception("The total row percentage (" + n3 / rect3.height + ") values exceed 100% for page " + (i + 1));
            }
            for (n2 = 0; n2 < profilePage.getRowCount(); ++n2) {
                if (nArray[n2] != -1) continue;
                nArray[n2] = (rect3.height - n3) / n4;
            }
            n2 = 0;
            for (n = 0; n < profilePage.getRowCount(); ++n) {
                Rect rect5 = new Rect(rect3.x, rect3.y + n2, rect3.width, nArray[n]);
                this.rectCache_.put(profilePage.getRow(n), rect5);
                n2 += nArray[n];
                if (n != profilePage.getRowCount() - 1 || rect5.y + rect5.height == rect3.height) continue;
                rect5.height = rect3.y + rect3.height - rect5.y;
            }
            for (int j = 0; j < profilePage.getRowCount(); ++j) {
                int n5;
                ProfileRow profileRow = profilePage.getRow(j);
                if (profileRow.getGaugeCount() <= 0) continue;
                Rect rect6 = (Rect)this.rectCache_.get(profileRow);
                if (rect6 == null) {
                    throw new Exception("The row[" + j + "] RECT was not in the cache.");
                }
                int[] nArray2 = new int[profileRow.getGaugeCount()];
                n = 0;
                int n6 = 0;
                for (n5 = 0; n5 < profileRow.getGaugeCount(); ++n5) {
                    if (profileRow.getGauge(n5).getDoubleProperty("width", -1.0) > 0.0) {
                        nArray2[n5] = (int)(profileRow.getGauge(n5).getDoubleProperty("width", -1.0) * (double)rect6.width);
                        n += nArray2[n5];
                        continue;
                    }
                    ++n6;
                    nArray2[n5] = -1;
                }
                if (n > rect3.width) {
                    throw new Exception("The total gauge percentage (" + n / rect3.width + ") values exceed 100% for page " + (i + 1) + " row " + (j + 1));
                }
                for (n5 = 0; n5 < profileRow.getGaugeCount(); ++n5) {
                    if (nArray2[n5] != -1) continue;
                    nArray2[n5] = (rect3.width - n) / n6;
                }
                n5 = 0;
                for (int k = 0; k < profileRow.getGaugeCount(); ++k) {
                    Rect rect7 = new Rect(n5, rect6.y, nArray2[k], rect6.height);
                    ProfileGauge profileGauge = profileRow.getGauge(k);
                    this.rectCache_.put(profileGauge, rect7);
                    n5 += nArray2[k];
                    if (k != profileRow.getGaugeCount() - 1 || rect7.x + rect7.width == rect3.width) continue;
                    rect7.width = rect3.width - rect7.x;
                }
            }
        }
        return true;
    }

    private void renderGauge(Graphics graphics, Rect rect, ProfileGauge profileGauge, ColorModel colorModel, boolean bl) throws Exception {
        String string = profileGauge.getProperty("param");
        if (string == null) {
            Log.error(this, "Gauge " + profileGauge + " does not have a parameter identified");
        }
        profileGauge.render(graphics, rect, colorModel, bl);
    }

    public static int[] toYArray(Coord[] coordArray) {
        int[] nArray = new int[coordArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = coordArray[i].y;
        }
        return nArray;
    }
}

