/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.param;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.MultiParamMetaParameter;
import com.mympgtracker.util.Convert;

public class VMAFMetaParam
extends MultiParamMetaParameter {
    private static final int RPM_NDX = 0;
    private static final int MAP_NDX = 1;
    private static final int IAT_NDX = 2;
    private double engineVE_ = 10.0;
    private double engineDisp_ = 100.0;

    public VMAFMetaParam(String string, ECUParameter eCUParameter, ECUParameter eCUParameter2, ECUParameter eCUParameter3) {
        super(string, new ECUParameter[]{eCUParameter, eCUParameter2, eCUParameter3});
    }

    public void setExtraValue(String string, String string2) {
        if ("engine-ve".equals(string)) {
            this.engineVE_ = Convert.toDouble(string2);
        }
        if ("engine-liters".equals(string)) {
            this.engineDisp_ = Convert.toDouble(string2);
        }
    }

    public double getValue() {
        if (this.params_[0].getValue() != 0.0) {
            return this.calculateVMAF(this.params_[0].getValue(), this.params_[1].getValue(), this.params_[2].getValue());
        }
        return 0.0;
    }

    public double calculateVMAF(double d, double d2, double d3) {
        return d * d2 / d3 / 120.0 * this.engineVE_ * this.engineDisp_ * 28.97 / 8.314;
    }
}

