/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.ecu.param;

import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.ecu.param.MultiParamMetaParameter;
import com.mympgtracker.ecutracker.ecu.param.StaticParameter;

public class MPG1MetaParam
extends MultiParamMetaParameter {
    public static double AF_STOICH_GAS = 14.7;
    public static double AF_STOICH_E85 = 9.765;
    public static double AF_STOICH_DIESEL = 14.6;
    public static double AF_STOICH_ETHANOL = 9.0;
    private static final int MAF_NDX = 0;
    private static final int KPH_NDX = 1;
    private static final int AF_NDX = 2;

    public MPG1MetaParam(String string, ECUParameter eCUParameter, ECUParameter eCUParameter2, double d) {
        this(string, eCUParameter, eCUParameter2, new StaticParameter(d));
    }

    public MPG1MetaParam(String string, ECUParameter eCUParameter, ECUParameter eCUParameter2, ECUParameter eCUParameter3) {
        super(string, new ECUParameter[]{eCUParameter, eCUParameter2, eCUParameter3});
    }

    protected MPG1MetaParam() {
        super("__MPG1_INTERNAL__", new ECUParameter[0]);
    }

    public double getValue() {
        if (this.params_[0].getValue() != 0.0) {
            return this.calculateMPG(this.params_[0].getValue(), this.params_[1].getValue(), this.params_[2].getValue());
        }
        return 0.0;
    }

    public double calculateMPG(double d, double d2, double d3) {
        return d3 * 28.0118 * d2 * 0.621371 / (3600.0 * d / 100.0);
    }
}

