/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.config;

import com.mympgtracker.ecutracker.config.AttributeList;
import com.mympgtracker.ecutracker.profile.DeviceConfig;
import com.mympgtracker.ecutracker.profile.Profile;
import com.mympgtracker.ecutracker.profile.ProfilePage;
import com.mympgtracker.ecutracker.profile.ProfileRow;
import com.mympgtracker.ecutracker.profile.gauge.AnalogGauge;
import com.mympgtracker.ecutracker.profile.gauge.DigitalCummulativeAverageGauge;
import com.mympgtracker.ecutracker.profile.gauge.DigitalGauge;
import com.mympgtracker.ecutracker.profile.gauge.LineGraphGauge;
import com.mympgtracker.ecutracker.profile.gauge.ProfileGauge;
import com.mympgtracker.ecutracker.profile.gauge.SweepAnalogGauge;
import com.mympgtracker.util.Convert;
import com.mympgtracker.util.qdxml.DocHandler;
import java.util.Hashtable;
import java.util.Vector;

public class ProfileParser
implements DocHandler {
    public static final String NODE_DEVICE = "device";
    public static final String NODE_PROFILE = "profile";
    public static final String NODE_PAGE = "page";
    public static final String NODE_ROW = "row";
    public static final String NODE_GAUGE = "gauge";
    public static final String ATTR_VERSION_MAJOR = "version-major";
    public static final String ATTR_VERSION_MINOR = "version-minor";
    public static final String ATTR_USERNAME = "username";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PROTOCOL_CLASS = "protocol-class";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_AUTO_CONNECT = "auto-connect";
    public static final String ATTR_DEFAULT_PORT = "default-port";
    public static final String ATTR_COMMAND = "command";
    public static final String ATTR_ENGINE_L = "engine-liters";
    public static final String ATTR_ENGINE_VE = "engine-ve";
    public static final String ATTR_ENGINE_NO_CYLS = "engine-no-cyls";
    public static final String ATTR_ENGINE_FUEL_TYPE = "fuel-type";
    public static final String ATTR_INJECTOR_CC_PER_MIN = "injector-ccpm";
    public static final String ATTR_HEIGHT = "height";
    public static final String VALUE_DIGITAL = "digital";
    public static final String VALUE_LINE_GRAPH = "line-graph";
    public static final String VALUE_ANALOG = "analog";
    public static final String VALUE_LED = "led";
    public static final String VALUE_SWEEP = "sweep";
    public static final String VALUE_DIGITAL_AVERAGE = "digital-average";
    private DeviceConfig deviceConfig_ = null;

    public DeviceConfig getDeviceConfig() {
        return this.deviceConfig_;
    }

    public void startDocument() throws Exception {
        this.deviceConfig_ = new DeviceConfig();
    }

    public void endDocument() throws Exception {
    }

    public void startElement(String string, Hashtable hashtable) throws Exception {
        AttributeList attributeList = new AttributeList(hashtable);
        if (NODE_DEVICE.equals(string = string.toLowerCase())) {
            this.deviceConfig_.setUsername(attributeList.get(ATTR_USERNAME, true));
            this.deviceConfig_.setProfileId(attributeList.get(ATTR_ID, true));
            String string2 = attributeList.get(ATTR_AUTO_CONNECT, false);
            String string3 = attributeList.get(ATTR_VERSION_MAJOR, false);
            String string4 = attributeList.get(ATTR_VERSION_MINOR, false);
            if (string3 != null) {
                this.deviceConfig_.setVersionMajor(Integer.parseInt(string3));
            }
            if (string4 != null) {
                this.deviceConfig_.setVersionMinor(Integer.parseInt(string4));
            }
            if (string2 != null) {
                string2 = string2.toLowerCase();
                this.deviceConfig_.setAutoConnect("true".equals(string2));
            }
        } else if (NODE_PROFILE.equals(string)) {
            Profile profile = new Profile();
            profile.setName(attributeList.get(ATTR_NAME, true));
            profile.setProtocolClass(attributeList.get(ATTR_PROTOCOL_CLASS, true));
            profile.addExtraValue(ATTR_ENGINE_L, attributeList.get(ATTR_ENGINE_L, false));
            profile.addExtraValue(ATTR_ENGINE_VE, attributeList.get(ATTR_ENGINE_VE, false));
            profile.addExtraValue(ATTR_ENGINE_NO_CYLS, attributeList.get(ATTR_ENGINE_NO_CYLS, false));
            profile.addExtraValue(ATTR_ENGINE_FUEL_TYPE, attributeList.get(ATTR_ENGINE_FUEL_TYPE, false));
            profile.addExtraValue(ATTR_INJECTOR_CC_PER_MIN, attributeList.get(ATTR_INJECTOR_CC_PER_MIN, false));
            this.deviceConfig_.addProfile(profile);
        } else if (NODE_PAGE.equals(string)) {
            Profile profile = this.deviceConfig_.getProfile(this.deviceConfig_.getProfileCount() - 1);
            profile.addPage(new ProfilePage());
        } else if (NODE_ROW.equals(string)) {
            Profile profile = this.deviceConfig_.getProfile(this.deviceConfig_.getProfileCount() - 1);
            ProfilePage profilePage = profile.getPage(profile.getPageCount() - 1);
            ProfileRow profileRow = new ProfileRow();
            String string5 = attributeList.get(ATTR_HEIGHT);
            if (string5 != null) {
                profileRow.setHeightPercent(Convert.toDouble(string5));
            }
            profilePage.addRow(profileRow);
        } else if (NODE_GAUGE.equals(string)) {
            Profile profile = this.deviceConfig_.getProfile(this.deviceConfig_.getProfileCount() - 1);
            ProfilePage profilePage = profile.getPage(profile.getPageCount() - 1);
            ProfileRow profileRow = profilePage.getRow(profilePage.getRowCount() - 1);
            profileRow.addGauge(this.createGauge(attributeList));
        } else {
            throw new RuntimeException("Invalid XML Tag [" + string + "] in profile");
        }
    }

    public void endElement(String string) throws Exception {
    }

    public void text(String string) throws Exception {
    }

    private ProfileGauge createGauge(AttributeList attributeList) {
        String string = attributeList.get(ATTR_TYPE);
        ProfileGauge profileGauge = null;
        if (VALUE_DIGITAL.equals(string)) {
            profileGauge = new DigitalGauge();
        } else if (VALUE_LINE_GRAPH.equals(string)) {
            profileGauge = new LineGraphGauge();
        } else if (VALUE_ANALOG.equals(string)) {
            profileGauge = new AnalogGauge();
        } else if (!VALUE_LED.equals(string)) {
            if (VALUE_SWEEP.equals(string)) {
                profileGauge = new SweepAnalogGauge();
            } else if (VALUE_DIGITAL_AVERAGE.equals(string)) {
                profileGauge = new DigitalCummulativeAverageGauge();
            } else {
                throw new RuntimeException("Invalid Gauge Type " + string);
            }
        }
        Vector vector = attributeList.getKeys();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            String string3 = attributeList.get(string2);
            profileGauge.setProperty(string2, string3);
        }
        return profileGauge;
    }
}

