/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker.config;

import com.mympgtracker.util.Convert;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.StringTok;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.rms.RecordStore;

public class LocalSettingsStore {
    private static LocalSettingsStore store_ = null;
    private static final String RS_NAME = "ECU Trackersettings";
    private static final int RECORD_ID_DEVICE_CONFIG = 1;
    private static final int RECORD_ID_LOCAL_SETTINGS = 2;
    public static final String INTERNAL_DEMO_CONFIG_NAME = "demo";
    private static final int SETTING_INDEX_ACTIVE_PROFILE = 0;
    private static final int SETTING_INDEX_COMM_PORT = 1;
    private static final int SETTING_INDEX_USERNAME = 2;
    private static final int SETTING_INDEX_DEVICE_ID = 3;
    private static final int SETTING_INDEX_PUSH_TOKEN = 4;
    private static final int SETTING_INDEX_PUSH_SITE = 5;
    private String deviceConfig_ = null;
    private int activeProfileIndex_ = -1;
    private String commPort_ = null;
    private String username_ = "internal";
    private String deviceId_ = "demo";
    private String pushToken_;
    private String pushSiteURL_ = "drivehub.us/events/push";
    static /* synthetic */ Class class$java$lang$Class;

    private LocalSettingsStore() {
    }

    public static LocalSettingsStore getStore() throws Exception {
        if (store_ == null) {
            store_ = new LocalSettingsStore();
            store_.load();
        }
        return store_;
    }

    public void delete() throws Exception {
        RecordStore.deleteRecordStore((String)RS_NAME);
    }

    public void load() throws Exception {
        this.fetchFromStore();
    }

    public void save() throws Exception {
        this.saveToStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFromStore() throws Exception {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
            this.deviceConfig_ = this.getInternalDeviceConfig(INTERNAL_DEMO_CONFIG_NAME);
            if (recordStore.getNumRecords() > 1) {
                byte[] byArray = recordStore.getRecord(2);
                String string = new String(byArray);
                String[] stringArray = StringTok.tokenize(string);
                if (stringArray.length > 0) {
                    this.activeProfileIndex_ = Convert.toInt(stringArray[0]);
                }
                if (stringArray.length > 1) {
                    this.commPort_ = stringArray[1];
                    if (this.commPort_.equals("null")) {
                        this.commPort_ = null;
                    }
                }
                this.username_ = stringArray.length > 2 ? stringArray[2] : "internal";
                this.deviceId_ = stringArray.length > 3 ? stringArray[3] : INTERNAL_DEMO_CONFIG_NAME;
                this.pushToken_ = stringArray.length > 4 ? stringArray[4] : null;
                this.pushSiteURL_ = stringArray.length > 5 ? stringArray[5] : "drivehub.us/events/push";
            }
        }
        finally {
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToStore() throws Exception {
        RecordStore recordStore = null;
        try {
            byte[] byArray = null;
            RecordStore.deleteRecordStore((String)RS_NAME);
            recordStore = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
            byArray = this.deviceConfig_.getBytes();
            recordStore.addRecord(byArray, 0, byArray.length);
            String string = this.activeProfileIndex_ + "," + this.commPort_ + "," + this.username_ + "," + this.deviceId_ + "," + this.pushToken_ + "," + this.pushSiteURL_;
            byArray = string.getBytes();
            recordStore.addRecord(byArray, 0, byArray.length);
        }
        finally {
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getInternalDeviceConfig(String string) throws Exception {
        InputStreamReader inputStreamReader = null;
        try {
            InputStream inputStream = (class$java$lang$Class == null ? (class$java$lang$Class = LocalSettingsStore.class$("java.lang.Class")) : class$java$lang$Class).getResourceAsStream("/ecutracker-res/" + string + ".xml");
            if (inputStream == null) {
                throw new Exception(Lang.get("fetch.status.error.not_found"));
            }
            inputStreamReader = new InputStreamReader(inputStream);
            StringBuffer stringBuffer = new StringBuffer();
            int n = -1;
            while ((n = inputStreamReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
    }

    public String setInternalDeviceConfig(String string) throws Exception {
        String string2 = this.getInternalDeviceConfig(string);
        this.setDeviceConfig(string2);
        return string2;
    }

    public String getDeviceConfig() throws Exception {
        return this.deviceConfig_;
    }

    public void setDeviceConfig(String string) throws Exception {
        this.deviceConfig_ = string;
        this.activeProfileIndex_ = -1;
    }

    public String getCommPort() throws Exception {
        return this.commPort_;
    }

    public void setCommPort(String string) throws Exception {
        this.commPort_ = string;
    }

    public int getActiveProfileIndex() throws Exception {
        return this.activeProfileIndex_;
    }

    public void setActiveProfileIndex(int n) throws Exception {
        this.activeProfileIndex_ = n;
    }

    public String getUsername() throws Exception {
        return this.username_;
    }

    public void setUsername(String string) throws Exception {
        this.username_ = string;
    }

    public String getDeviceId() throws Exception {
        return this.deviceId_;
    }

    public void setDeviceId(String string) throws Exception {
        this.deviceId_ = string;
    }

    public String getPushToken() {
        return this.pushToken_;
    }

    public String getPushSiteURL() {
        return this.pushSiteURL_;
    }

    public void setPushToken(String string) {
        this.pushToken_ = string;
    }

    public void setPushSiteURL(String string) {
        this.pushSiteURL_ = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

