/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker;

import com.mympgtracker.ecutracker.ECUTrackerMidlet;
import com.mympgtracker.ecutracker.MainControlForm;
import com.mympgtracker.ecutracker.config.LocalSettingsStore;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class SensorPushOptionsForm
extends Form
implements CommandListener,
Cleanable {
    private ECUTrackerMidlet trackerMidlet_ = null;
    private Command cancelCommand_ = null;
    private Command saveCommand_ = null;
    private TextField tokenField_ = null;
    private TextField siteurlField_ = null;
    private StringItem statusField_ = null;
    public static final String DEFAULT_PUSHSITE = "drivehub.us/events/push";

    public SensorPushOptionsForm(ECUTrackerMidlet eCUTrackerMidlet) {
        super(Lang.get("form.options.title"));
        this.trackerMidlet_ = eCUTrackerMidlet;
        this.setCommandListener(this);
        this.tokenField_ = new TextField(Lang.get("form.options.label.token"), null, 50, 0);
        this.append((Item)this.tokenField_);
        this.siteurlField_ = new TextField(Lang.get("form.options.label.siteurl"), null, 50, 4);
        this.append((Item)this.siteurlField_);
        this.append((Item)new StringItem(Lang.get("form.options.label.pushinstructions"), " " + Lang.get("form.options.pushinstructions")));
        this.saveCommand_ = new Command(Lang.get("common.command.save"), 4, 1);
        this.addCommand(this.saveCommand_);
        this.cancelCommand_ = new Command(Lang.get("common.command.cancel"), 3, 1);
        this.addCommand(this.cancelCommand_);
        try {
            this.tokenField_.setString(LocalSettingsStore.getStore().getPushToken());
            this.siteurlField_.setString(LocalSettingsStore.getStore().getPushSiteURL());
        }
        catch (Exception exception) {
            Log.error(this, "Unable to set username and profile fields", exception);
        }
    }

    public void cleanYourRoom() {
        this.saveCommand_ = null;
        this.cancelCommand_ = null;
        this.trackerMidlet_ = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        block4: {
            try {
                if (command == this.saveCommand_) {
                    this.saveAndClose();
                    break block4;
                }
                if (command == this.cancelCommand_) {
                    Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new MainControlForm(this.trackerMidlet_));
                    this.cleanYourRoom();
                    break block4;
                }
                throw new RuntimeException("Invalid Command " + command.getLabel());
            }
            catch (Exception exception) {
                this.statusUpdate(exception.getMessage());
                Alert alert = new Alert("Error", exception.getMessage(), null, AlertType.ERROR);
                this.trackerMidlet_.showAlert(alert, (Displayable)this);
            }
        }
    }

    private void saveAndClose() throws Exception {
        LocalSettingsStore.getStore().setActiveProfileIndex(0);
        LocalSettingsStore.getStore().setPushToken(this.tokenField_.getString());
        LocalSettingsStore.getStore().setPushSiteURL(this.siteurlField_.getString());
        LocalSettingsStore.getStore().save();
        this.trackerMidlet_.reInitialize(false);
        Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new MainControlForm(this.trackerMidlet_));
        this.cleanYourRoom();
    }

    public void statusUpdate(String string) {
        this.statusField_.setText(" " + string);
    }
}

