/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker;

import com.mympgtracker.ecutracker.ECUTrackerMidlet;
import com.mympgtracker.ecutracker.MainControlForm;
import com.mympgtracker.ecutracker.config.LocalSettingsStore;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.StringTok;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class SelectComPortForm
extends List
implements CommandListener,
Cleanable {
    public static final String COMM_PORT_URL_PREFIX = "comm:";
    private ECUTrackerMidlet trackerMidlet_ = null;
    private MainControlForm parentForm_ = null;
    private Command cancelCommand_ = null;

    public SelectComPortForm(ECUTrackerMidlet eCUTrackerMidlet, MainControlForm mainControlForm) {
        super(Lang.get("form.com.title"), 3);
        this.trackerMidlet_ = eCUTrackerMidlet;
        this.parentForm_ = mainControlForm;
        this.setCommandListener(this);
        this.cancelCommand_ = new Command(Lang.get("common.command.cancel"), 3, 2);
        this.addCommand(this.cancelCommand_);
        try {
            String string = LocalSettingsStore.getStore().getCommPort();
            string = string == null ? "" : string;
            String[] stringArray = StringTok.tokenize(System.getProperty("microedition.commports"));
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) >= 0) {
                    this.append(stringArray[i], MainControlForm.CHECK_MARK);
                    this.setSelectedIndex(i, true);
                    continue;
                }
                this.append(stringArray[i], MainControlForm.BLANK_CHECK_MARK);
            }
        }
        catch (Exception exception) {
            Log.error(this, "Unable to set current com port", exception);
        }
    }

    public void cleanYourRoom() {
        this.cancelCommand_ = null;
        this.trackerMidlet_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == this.cancelCommand_) {
                Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)this.parentForm_);
            } else {
                LocalSettingsStore.getStore().setCommPort(COMM_PORT_URL_PREFIX + this.getString(this.getSelectedIndex()));
                LocalSettingsStore.getStore().save();
                Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)this.parentForm_);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Alert alert = new Alert("Error", exception.getMessage(), null, AlertType.ERROR);
            this.trackerMidlet_.showAlert(alert, (Displayable)new MainControlForm(this.trackerMidlet_));
        }
        finally {
            this.cleanYourRoom();
        }
    }
}

