/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker;

import com.mympgtracker.ecutracker.ECUTrackerMidlet;
import com.mympgtracker.ecutracker.InitableForm;
import com.mympgtracker.ecutracker.MainControlForm;
import com.mympgtracker.ecutracker.config.LocalSettingsStore;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import java.util.Vector;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class SelectBTDeviceForm
extends List
implements CommandListener,
Cleanable,
DiscoveryListener,
InitableForm {
    private static final String BT_URL_PREFIX = "btspp://";
    private ECUTrackerMidlet trackerMidlet_ = null;
    private MainControlForm parentForm_ = null;
    private Command cancelCommand_ = null;
    private Command searchCommand_ = null;
    private Vector discoveredDevices_ = new Vector();

    public SelectBTDeviceForm() {
        super(Lang.get("form.bt.searching"), 3);
    }

    public void init(ECUTrackerMidlet eCUTrackerMidlet, MainControlForm mainControlForm) {
        this.trackerMidlet_ = eCUTrackerMidlet;
        this.parentForm_ = mainControlForm;
        this.setCommandListener(this);
        this.cancelCommand_ = new Command(Lang.get("common.command.cancel"), 3, 1);
        this.addCommand(this.cancelCommand_);
        this.searchCommand_ = new Command(Lang.get("form.bt.command.search"), 8, 1);
        this.addCommand(this.searchCommand_);
        this.commandAction(this.searchCommand_, null);
    }

    public void cleanYourRoom() {
        this.cancelCommand_ = null;
        this.searchCommand_ = null;
        this.trackerMidlet_ = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == this.cancelCommand_) {
                LocalDevice localDevice = LocalDevice.getLocalDevice();
                localDevice.getDiscoveryAgent().cancelInquiry((DiscoveryListener)this);
                Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)this.parentForm_);
                this.cleanYourRoom();
            } else if (command == this.searchCommand_) {
                this.doDeviceSearch();
            } else {
                LocalDevice localDevice = LocalDevice.getLocalDevice();
                localDevice.getDiscoveryAgent().cancelInquiry((DiscoveryListener)this);
                RemoteDevice remoteDevice = (RemoteDevice)this.discoveredDevices_.elementAt(this.getSelectedIndex());
                LocalSettingsStore.getStore().setCommPort(BT_URL_PREFIX + remoteDevice.getBluetoothAddress() + ":1");
                LocalSettingsStore.getStore().save();
                Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)this.parentForm_);
                this.cleanYourRoom();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Alert alert = new Alert("Error", exception.getMessage(), null, AlertType.ERROR);
            this.trackerMidlet_.showAlert(alert, (Displayable)new MainControlForm(this.trackerMidlet_));
        }
    }

    private void doDeviceSearch() throws Exception {
        LocalDevice localDevice = LocalDevice.getLocalDevice();
        localDevice.getDiscoveryAgent().cancelInquiry((DiscoveryListener)this);
        this.setTitle(Lang.get("form.bt.searching"));
        this.deleteAll();
        this.discoveredDevices_.removeAllElements();
        localDevice.getDiscoveryAgent().startInquiry(10390323, (DiscoveryListener)this);
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        try {
            String string = remoteDevice.getBluetoothAddress();
            try {
                String string2 = remoteDevice.getFriendlyName(true);
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (Exception exception) {
                Log.warn(this, "Failed to get friendly name for device");
            }
            Log.info(this, "Discovered: " + string);
            this.discoveredDevices_.addElement(remoteDevice);
            this.append(string, MainControlForm.BLANK_CHECK_MARK);
        }
        catch (Exception exception) {
            Log.error(this, "Error adding BT Device to list", exception);
        }
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
    }

    public void serviceSearchCompleted(int n, int n2) {
    }

    public void inquiryCompleted(int n) {
        Log.info(this, "Inquery Completed: " + n);
        this.setTitle(Lang.get("form.bt.found") + " (" + this.size() + ")");
    }
}

