/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker;

import com.mympgtracker.ecutracker.ECUTrackerMidlet;
import com.mympgtracker.ecutracker.MainControlForm;
import com.mympgtracker.ecutracker.config.LocalSettingsStore;
import com.mympgtracker.ecutracker.config.ProfileFetcher;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class OptionsForm
extends Form
implements CommandListener,
Cleanable {
    private ECUTrackerMidlet trackerMidlet_ = null;
    private Command cancelCommand_ = null;
    private Command saveCommand_ = null;
    private Command defaultCommand_ = null;
    private TextField usernameField_ = null;
    private TextField deviceField_ = null;
    private StringItem statusField_ = null;
    public static final String DEFAULT_USERNAME = "internal";
    public static final String DEFAULT_DEVICE_ID = "demo";
    private String fetchedProfile_ = null;

    public OptionsForm(ECUTrackerMidlet eCUTrackerMidlet) {
        super(Lang.get("form.options.title"));
        this.trackerMidlet_ = eCUTrackerMidlet;
        this.setCommandListener(this);
        this.usernameField_ = new TextField(Lang.get("form.options.label.username"), null, 50, 1);
        this.append((Item)this.usernameField_);
        this.deviceField_ = new TextField(Lang.get("form.options.label.device"), null, 10, 0);
        this.append((Item)this.deviceField_);
        this.statusField_ = new StringItem(Lang.get("form.options.label.status"), " " + Lang.get("fetch.status.ready"));
        this.append((Item)this.statusField_);
        this.append((Item)new StringItem(Lang.get("form.options.label.instructions"), " " + Lang.get("form.options.instructions")));
        this.saveCommand_ = new Command(Lang.get("common.command.download"), 2, 1);
        this.addCommand(this.saveCommand_);
        this.cancelCommand_ = new Command(Lang.get("common.command.cancel"), 3, 1);
        this.addCommand(this.cancelCommand_);
        this.defaultCommand_ = new Command(Lang.get("form.options.command.default"), 4, 2);
        this.addCommand(this.defaultCommand_);
        try {
            this.usernameField_.setString(LocalSettingsStore.getStore().getUsername());
            this.deviceField_.setString(LocalSettingsStore.getStore().getDeviceId());
        }
        catch (Exception exception) {
            Log.error(this, "Unable to set username and profile fields", exception);
        }
    }

    public void cleanYourRoom() {
        this.saveCommand_ = null;
        this.cancelCommand_ = null;
        this.defaultCommand_ = null;
        this.trackerMidlet_ = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        block5: {
            try {
                if (command == this.saveCommand_) {
                    this.loadDeviceProfile();
                    break block5;
                }
                if (command == this.cancelCommand_) {
                    Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new MainControlForm(this.trackerMidlet_));
                    this.cleanYourRoom();
                    break block5;
                }
                if (command == this.defaultCommand_) {
                    this.usernameField_.setString(DEFAULT_USERNAME);
                    this.deviceField_.setString(DEFAULT_DEVICE_ID);
                    this.loadDeviceProfile();
                    break block5;
                }
                throw new RuntimeException("Invalid Command " + command.getLabel());
            }
            catch (Exception exception) {
                this.statusUpdate(exception.getMessage());
                Alert alert = new Alert("Error", exception.getMessage(), null, AlertType.ERROR);
                this.trackerMidlet_.showAlert(alert, (Displayable)this);
            }
        }
    }

    private void saveAndClose() throws Exception {
        if (this.fetchedProfile_ != null) {
            LocalSettingsStore.getStore().setDeviceConfig(this.fetchedProfile_);
        }
        LocalSettingsStore.getStore().setActiveProfileIndex(0);
        LocalSettingsStore.getStore().setUsername(this.usernameField_.getString());
        LocalSettingsStore.getStore().setDeviceId(this.deviceField_.getString());
        LocalSettingsStore.getStore().save();
        this.trackerMidlet_.reInitialize(false);
        Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new MainControlForm(this.trackerMidlet_));
        this.cleanYourRoom();
    }

    public void statusUpdate(String string) {
        this.statusField_.setText(" " + string);
    }

    public void setFetchedProfile(String string) throws Exception {
        this.fetchedProfile_ = string;
        if (this.fetchedProfile_ == null) {
            this.statusUpdate(Lang.get("fetch.status.error"));
        } else {
            this.saveAndClose();
        }
    }

    private void loadDeviceProfile() throws Exception {
        if (DEFAULT_USERNAME.equals(this.usernameField_.getString())) {
            LocalSettingsStore.getStore().setInternalDeviceConfig(this.deviceField_.getString());
            LocalSettingsStore.getStore().setActiveProfileIndex(0);
            this.statusUpdate(Lang.get("fetch.status.done"));
            this.saveAndClose();
            return;
        }
        String string = ProfileFetcher.generateFetchUrl(this.usernameField_.getString(), this.deviceField_.getString());
        Log.info(this, "Profile URL: " + string);
        ProfileFetcher profileFetcher = new ProfileFetcher(string, this);
        profileFetcher.start();
    }
}

