/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker;

import com.mympgtracker.ecutracker.DebugForm;
import com.mympgtracker.ecutracker.ECUTrackerMidlet;
import com.mympgtracker.ecutracker.InitableForm;
import com.mympgtracker.ecutracker.OptionsForm;
import com.mympgtracker.ecutracker.SelectComPortForm;
import com.mympgtracker.ecutracker.SensorPushOptionsForm;
import com.mympgtracker.ecutracker.SplashForm;
import com.mympgtracker.ecutracker.config.LocalSettingsStore;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Log;
import com.mympgtracker.util.TrackerRuntimeException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class MainControlForm
extends List
implements CommandListener,
Cleanable {
    private boolean foundBluetoothStack_ = false;
    private ECUTrackerMidlet trackerMidlet_ = null;
    private Command connectCommand_ = null;
    private Command disconnectCommand_ = null;
    private Command exitCommand_ = null;
    private Command debugCommand_ = null;
    private Command backCommand_ = null;
    private Command profileCommand_ = null;
    private Command sensorOptionsCommand_ = null;
    private Command comPortCommand_ = null;
    private Command btDevCommand_ = null;
    private Command aboutCommand_ = null;
    public static Image CHECK_MARK = null;
    public static Image BLANK_CHECK_MARK = null;
    static /* synthetic */ Class class$com$mympgtracker$ecutracker$MainControlForm;

    public MainControlForm(ECUTrackerMidlet eCUTrackerMidlet) {
        super(Lang.get("form.control.label.profiles"), 3);
        this.trackerMidlet_ = eCUTrackerMidlet;
        this.setCommandListener(this);
        try {
            Class.forName("javax.bluetooth.LocalDevice");
            this.foundBluetoothStack_ = true;
        }
        catch (Throwable throwable) {
            this.foundBluetoothStack_ = false;
        }
        try {
            if (this.trackerMidlet_.getDeviceConfig() != null) {
                int n = LocalSettingsStore.getStore().getActiveProfileIndex();
                if (n < 0 || n >= this.trackerMidlet_.getDeviceConfig().getProfileCount()) {
                    n = 0;
                }
                for (int i = 0; i < this.trackerMidlet_.getDeviceConfig().getProfileCount(); ++i) {
                    String string = this.trackerMidlet_.getDeviceConfig().getProfile(i).getName();
                    if (n == i) {
                        int n2 = this.append(string, CHECK_MARK);
                        this.setSelectedIndex(n2, true);
                        continue;
                    }
                    this.append(string, BLANK_CHECK_MARK);
                }
            }
        }
        catch (Exception exception) {
            Log.fatal(this, "Unable to set selected active profile.", exception);
        }
        this.backCommand_ = new Command(Lang.get("common.command.back"), 6, 10);
        this.addCommand(this.backCommand_);
        this.connectCommand_ = new Command(Lang.get("common.command.connect"), 6, 12);
        this.addCommand(this.connectCommand_);
        this.disconnectCommand_ = new Command(Lang.get("common.command.disconnect"), 6, 20);
        this.addCommand(this.disconnectCommand_);
        this.profileCommand_ = new Command(Lang.get("form.control.command.profile"), 6, 25);
        this.addCommand(this.profileCommand_);
        this.sensorOptionsCommand_ = new Command(Lang.get("form.control.command.sensoroptions"), 6, 26);
        this.addCommand(this.sensorOptionsCommand_);
        if (this.foundBluetoothStack_) {
            this.btDevCommand_ = new Command(Lang.get("form.control.command.bt"), 6, 30);
            this.addCommand(this.btDevCommand_);
        }
        this.comPortCommand_ = new Command(Lang.get("form.control.command.com"), 6, 30);
        this.addCommand(this.comPortCommand_);
        if (Log.echoToRecordStore_) {
            this.debugCommand_ = new Command(Lang.get("form.control.command.debug"), 6, 90);
            this.addCommand(this.debugCommand_);
        }
        this.aboutCommand_ = new Command(Lang.get("form.control.command.about"), 6, 95);
        this.addCommand(this.aboutCommand_);
        this.exitCommand_ = new Command(Lang.get("form.control.command.exit"), 7, 99);
        this.addCommand(this.exitCommand_);
    }

    public void cleanYourRoom() {
        this.trackerMidlet_ = null;
        this.connectCommand_ = null;
        this.disconnectCommand_ = null;
        this.exitCommand_ = null;
        this.debugCommand_ = null;
        this.backCommand_ = null;
        this.profileCommand_ = null;
        this.sensorOptionsCommand_ = null;
        this.comPortCommand_ = null;
        this.btDevCommand_ = null;
        this.aboutCommand_ = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand_) {
            this.trackerMidlet_.notifyDestroyed();
            return;
        }
        if (command == this.debugCommand_) {
            Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new DebugForm(this.trackerMidlet_, (Displayable)this));
        } else if (command == this.profileCommand_) {
            Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new OptionsForm(this.trackerMidlet_));
            this.cleanYourRoom();
        } else if (command == this.sensorOptionsCommand_) {
            Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new SensorPushOptionsForm(this.trackerMidlet_));
            this.cleanYourRoom();
        } else if (command == this.comPortCommand_) {
            Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new SelectComPortForm(this.trackerMidlet_, this));
        } else {
            if (command == this.btDevCommand_) {
                try {
                    Class<?> clazz = Class.forName("com.mympgtracker.ecutracker.SelectBTDeviceForm");
                    Object obj = clazz.newInstance();
                    ((InitableForm)obj).init(this.trackerMidlet_, this);
                    Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)obj);
                }
                catch (Throwable throwable) {
                    Log.fatal(this, "Unable to display BT selection form", throwable);
                    this.trackerMidlet_.showError(throwable.getMessage(), (Displayable)this);
                    return;
                }
            }
            if (command == this.backCommand_ || command == this.connectCommand_) {
                try {
                    this.trackerMidlet_.reInitialize(command == this.connectCommand_);
                    this.trackerMidlet_.displayGaugeScreen();
                }
                catch (Throwable throwable) {
                    Log.error(this, throwable.getMessage(), throwable);
                    this.trackerMidlet_.showError(throwable.getMessage(), (Displayable)this);
                    return;
                }
                Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)this.trackerMidlet_.gaugeScreen_);
                this.cleanYourRoom();
            } else if (command == this.disconnectCommand_) {
                this.trackerMidlet_.doDisconnect();
            } else if (command == this.aboutCommand_) {
                Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new SplashForm(this.trackerMidlet_, (Displayable)this, false));
            } else {
                try {
                    this.storeChanges();
                    this.trackerMidlet_.reInitialize(false);
                    this.trackerMidlet_.displayGaugeScreen();
                    this.cleanYourRoom();
                }
                catch (Throwable throwable) {
                    Log.error(this, throwable.getMessage(), throwable);
                    this.trackerMidlet_.showError(throwable.getMessage(), (Displayable)this);
                    return;
                }
            }
        }
    }

    private void storeChanges() throws Exception {
        int n = this.getSelectedIndex();
        if (n != LocalSettingsStore.getStore().getActiveProfileIndex()) {
            // empty if block
        }
        LocalSettingsStore.getStore().setActiveProfileIndex(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            CHECK_MARK = Image.createImage((String)"/ecutracker-res/img/check.png");
            BLANK_CHECK_MARK = Image.createImage((String)"/ecutracker-res/img/check-blank.png");
        }
        catch (Exception exception) {
            throw new TrackerRuntimeException(class$com$mympgtracker$ecutracker$MainControlForm == null ? (class$com$mympgtracker$ecutracker$MainControlForm = MainControlForm.class$("com.mympgtracker.ecutracker.MainControlForm")) : class$com$mympgtracker$ecutracker$MainControlForm, exception.getMessage());
        }
    }
}

