/*
 * Decompiled with CFR 0.152.
 */
package com.mympgtracker.ecutracker;

import com.mympgtracker.ecutracker.ECUTrackerMidlet;
import com.mympgtracker.ecutracker.MainControlForm;
import com.mympgtracker.ecutracker.SensorPushStatusForm;
import com.mympgtracker.ecutracker.ecu.comm.ProtocolEventListener;
import com.mympgtracker.ecutracker.ecu.param.ECUParameter;
import com.mympgtracker.ecutracker.menu.MenuRenderer;
import com.mympgtracker.ecutracker.profile.ProfileRenderer;
import com.mympgtracker.ecutracker.profile.color.ColorModel;
import com.mympgtracker.util.Cleanable;
import com.mympgtracker.util.Convert;
import com.mympgtracker.util.Lang;
import com.mympgtracker.util.Rect;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GaugeCanvas
extends Canvas
implements Cleanable,
ProtocolEventListener {
    private static final String SCAN_IND_0 = "[*    ]";
    private static final String SCAN_IND_1 = "[ *   ]";
    private static final String SCAN_IND_2 = "[  *  ]";
    private static final String SCAN_IND_3 = "[   * ]";
    private static final String SCAN_IND_4 = "[    *]";
    private static final int MENU_CONNECT = 0;
    private static final int MENU_DISCONNECT = 1;
    private static final int MENU_SETTINGS = 2;
    private static final int MENU_SENSOR_PUSH = 3;
    private static final int MENU_BACK = 4;
    private ECUTrackerMidlet trackerMidlet_ = null;
    private ProfileRenderer profileRenderer_ = null;
    private ColorModel colorModel_ = ColorModel.DEFAULT_MODEL;
    private Image graphicsBuffer_ = null;
    private boolean scanIndexDirection_ = true;
    private int scanIndex_ = 0;
    private long lastBatchTime_ = 0L;
    private boolean menuActive_ = false;
    private MenuRenderer menuRenderer_ = new MenuRenderer();

    public GaugeCanvas(ECUTrackerMidlet eCUTrackerMidlet) {
        this.setFullScreenMode(true);
        this.trackerMidlet_ = eCUTrackerMidlet;
        if (!this.isDoubleBuffered()) {
            this.graphicsBuffer_ = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        }
        this.menuRenderer_.addItem(Lang.get("common.command.connect"));
        this.menuRenderer_.addItem(Lang.get("common.command.disconnect"));
        this.menuRenderer_.addItem(Lang.get("common.command.settings"));
        this.menuRenderer_.addItem(Lang.get("common.command.sensorpushstatus"));
        this.menuRenderer_.addItem(Lang.get("common.command.done"));
    }

    public void cleanYourRoom() {
        if (this.profileRenderer_ != null) {
            this.profileRenderer_.cleanYourRoom();
        }
        this.trackerMidlet_ = null;
        this.profileRenderer_ = null;
        this.graphicsBuffer_ = null;
        this.menuRenderer_.cleanYourRoom();
        this.menuRenderer_ = null;
    }

    public void setProfileRenderer(ProfileRenderer profileRenderer) {
        if (this.profileRenderer_ != null) {
            this.profileRenderer_ = null;
        }
        this.profileRenderer_ = profileRenderer;
        this.repaint();
    }

    protected void sizeChanged(int n, int n2) {
        super.sizeChanged(n, n2);
        if (!this.isDoubleBuffered()) {
            this.graphicsBuffer_ = Image.createImage((int)n, (int)n2);
        }
        this.repaint();
        System.gc();
    }

    protected void paint(Graphics graphics) {
        if (!this.isShown() || this.profileRenderer_ == null) {
            return;
        }
        try {
            Rect rect = new Rect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            if (this.isDoubleBuffered()) {
                this.profileRenderer_.render(graphics, rect, this.colorModel_);
                if (this.menuActive_) {
                    this.menuRenderer_.render(graphics, rect, this.colorModel_);
                }
            } else {
                Graphics graphics2 = this.graphicsBuffer_.getGraphics();
                this.profileRenderer_.render(graphics2, rect, this.colorModel_);
                if (this.menuActive_) {
                    this.menuRenderer_.render(graphics2, rect, this.colorModel_);
                }
                graphics.drawImage(this.graphicsBuffer_, 0, 0, 20);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void keyPressed(int n) {
        this.profileRenderer_.forceFullRedraw();
        if (this.menuActive_ && this.menuKeyPressed(n)) {
            return;
        }
        if (8 == this.getGameAction(n)) {
            this.menuActive_ = true;
        } else if (2 == this.getGameAction(n)) {
            this.profileRenderer_.setActivePage(this.profileRenderer_.getActivePage() - 1);
        } else if (5 == this.getGameAction(n)) {
            this.profileRenderer_.setActivePage(this.profileRenderer_.getActivePage() + 1);
        } else if (6 == this.getGameAction(n)) {
            for (int i = 0; i < ColorModel.ALL_MODELS.length - 1; ++i) {
                if (ColorModel.ALL_MODELS[i] != this.colorModel_) continue;
                this.colorModel_ = ColorModel.ALL_MODELS[i + 1];
                break;
            }
        } else if (1 == this.getGameAction(n)) {
            for (int i = ColorModel.ALL_MODELS.length - 1; i >= 1; --i) {
                if (ColorModel.ALL_MODELS[i] != this.colorModel_) continue;
                this.colorModel_ = ColorModel.ALL_MODELS[i - 1];
                break;
            }
        } else if (n != 63 || !System.getProperty("microedition.platform").equalsIgnoreCase("Palm OS")) {
            Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new MainControlForm(this.trackerMidlet_));
        }
        this.repaint();
    }

    private boolean menuKeyPressed(int n) {
        boolean bl = false;
        if (1 == this.getGameAction(n)) {
            this.menuRenderer_.selectUp();
            bl = true;
        } else if (6 == this.getGameAction(n)) {
            this.menuRenderer_.selectDown();
            bl = true;
        } else if (8 == this.getGameAction(n)) {
            this.menuActive_ = false;
            switch (this.menuRenderer_.getSelected()) {
                case 0: {
                    this.trackerMidlet_.doConnect();
                    break;
                }
                case 1: {
                    this.trackerMidlet_.doDisconnect();
                    break;
                }
                case 2: {
                    Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new MainControlForm(this.trackerMidlet_));
                    break;
                }
                case 3: {
                    Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new SensorPushStatusForm(this.trackerMidlet_, (Displayable)this));
                    break;
                }
            }
            bl = true;
        }
        this.repaint();
        return bl;
    }

    private void setStatus(String string) {
        if (this.profileRenderer_ != null && this.profileRenderer_.getStatusBar() != null) {
            this.profileRenderer_.getStatusBar().setStatusMessage(string);
        }
    }

    protected void pointerPressed(int n, int n2) {
        super.pointerPressed(n, n2);
        int n3 = this.profileRenderer_.getPageBar().getPageIndex(n, n2);
        if (n3 != -1) {
            this.profileRenderer_.setActivePage(n3);
            this.repaint();
        } else {
            Display.getDisplay((MIDlet)this.trackerMidlet_).setCurrent((Displayable)new MainControlForm(this.trackerMidlet_));
        }
    }

    public void initStarted() {
        this.setStatus(Lang.get("protocol.status.init.started"));
        this.repaint();
    }

    public void initStatus(String string) {
        if (string == null) {
            string = "null??";
        }
        this.setStatus(string);
        this.repaint();
    }

    public void initFinished() {
        this.lastBatchTime_ = System.currentTimeMillis();
        this.setStatus(Lang.get("protocol.status.init.finished"));
        this.repaint();
    }

    public void protocolConnecting() {
        this.setStatus(Lang.get("protocol.status.connecting"));
        this.repaint();
    }

    public void protocolDisconnected() {
        this.setStatus(Lang.get("protocol.status.disconnected"));
        this.repaint();
    }

    public void parametersFetched(ECUParameter[] eCUParameterArray) {
        if (eCUParameterArray == null || eCUParameterArray.length == 0) {
            this.setStatus("-");
        } else {
            String string = null;
            switch (this.scanIndex_) {
                case 0: {
                    string = SCAN_IND_0;
                    break;
                }
                case 1: {
                    string = SCAN_IND_1;
                    break;
                }
                case 2: {
                    string = SCAN_IND_2;
                    break;
                }
                case 3: {
                    string = SCAN_IND_3;
                    break;
                }
                case 4: {
                    string = SCAN_IND_4;
                    break;
                }
                default: {
                    this.scanIndex_ = 0;
                }
            }
            if (this.scanIndexDirection_) {
                ++this.scanIndex_;
                if (this.scanIndex_ >= 4) {
                    this.scanIndexDirection_ = false;
                    this.scanIndex_ = 4;
                }
            } else {
                --this.scanIndex_;
                if (this.scanIndex_ <= 0) {
                    this.scanIndexDirection_ = true;
                    this.scanIndex_ = 0;
                }
            }
            string = string + " " + Convert.toString((double)(System.currentTimeMillis() - this.lastBatchTime_) / 1000.0, 2) + Lang.get("common.second.short");
            string = string + " " + Runtime.getRuntime().freeMemory() / 1024L + "kb";
            this.setStatus(string);
        }
        this.lastBatchTime_ = System.currentTimeMillis();
        this.repaint();
    }
}

