.include "TN12DEF.INC"					; include chip definition
;------------------------------
.def	temp1=r16
.def	temp2=r17
.def	PulseQuantity=r19
.def	BeforePulseDelay=r20
.def	PulseLong=r21
.def	PulseSpace=r22

.equ	PulseQuantityInitVal=2				; 2 pulse qty
.equ	BeforePulseDelayInitVal=0			; 0 sec delay before pulse
.equ	PulseLongInitVal=2				; 0.5 sec pulse duration
.equ	PulseSpaceInitVal=4				; 1 sec space between pulse
;------------------------------
	rjmp	RESET					; Reset Handle
	rjmp	INT0VECT				; External Interrupt0 Vector Address
	rjmp	NOVECT					; Pin change Interrupt Vector Address
	rjmp	OVF0VECT				; Overflow0 Interrupt Vector Address
	rjmp	NOVECT					; EEPROM ready Interrupt Vector Address ATTiny12 (Analog Comparator Interrupt Vector Address ATTiny11)
	rjmp	NOVECT					; Analog Comparator Interrupt Vector Address ATTiny12
;------------------------------
RESET:
; init timer
	ldi     temp1, (1<<CS02)|(1<<CS00)		; enable timer, CLK/1024
	out     TCCR0, temp1
	ldi     temp1, (1<<TOIE0)			; enable Timer0 Overflow int
	out     TIMSK, temp1
; init int0
	ldi     temp1, (1<<INT0)			; enable int0
	out     GIMSK, temp1
	ldi     temp1, (1<<ISC00)			; int0 at change
	out     MCUCR, temp1
; init ports
	ldi	temp1, (1<<PINB0)			; 0 - output pin
	out	DDRB, temp1
; clear values
	ldi	PulseQuantity, 0
	ldi	BeforePulseDelay, 0
	ldi	PulseLong, 0
	ldi	PulseSpace, 0
; enable interrupts
	sei
;------------------------------
MAIN:
	rjmp	MAIN
;------------------------------
OVF0VECT:
	in	temp1, SREG				; Store the Status register in reg temp1
; near every .25 sec:
; ATTiny12 internal RC clock 1.2MHz => 1200000 / 1024 = 1172 / 256 = 4.6 => 1 / 4.6 = .22 sec

	tst	PulseQuantity
	breq	EX_OVF0VECT				; INT0 pin state not changed

	tst	BeforePulseDelay
	breq	DELAYCOMPLETE
	dec	BeforePulseDelay
	rjmp	EX_OVF0VECT

DELAYCOMPLETE:
	tst	PulseLong
	breq	UPCOMPLETE
	dec	PulseLong
	sbi	PORTB, PINB0
	rjmp	EX_OVF0VECT

UPCOMPLETE:
	tst	PulseSpace
	breq	DNCOMPLETE
	dec	PulseSpace
	cbi	PORTB, PINB0
	rjmp	EX_OVF0VECT

; another one pulse fully complete
DNCOMPLETE:
	ldi	PulseLong, PulseLongInitVal
	ldi	PulseSpace, PulseSpaceInitVal
	cbi	PORTB, PINB0
	dec	PulseQuantity

EX_OVF0VECT:
	out	SREG, temp1				; Restore Status register
	reti
;------------------------------
INT0VECT:
	in	temp2, SREG				; Store the Status register in reg temp2

	tst	PulseQuantity
	brne	EX_INT0VECT
	ldi	PulseQuantity, PulseQuantityInitVal
	ldi	BeforePulseDelay, BeforePulseDelayInitVal
	ldi	PulseLong, PulseLongInitVal
	ldi	PulseSpace, PulseSpaceInitVal

EX_INT0VECT:
	out	SREG, temp2				; Restore Status register
	reti
;------------------------------
NOVECT:
	reti