/* ==================================================================================================
 * TPMS plugin																						*
 * File: SensorPos.cs																					*
 * Author: Dipl.-Ing. Wolfgang Otto																	*
 * eMail: Wolfgang@exner-otto.de																	*
 * Date: February 2009																				*
 *																									*
 * This file is subject to the condition of GNU GENERAL PUBLIC LICENSE								*
 * Therefore you are free to use this software for your own requirements and use the				*
 * source code for any modification.																*
 * The only wish is to inform the author about any kind of development.								*
 * =================================================================================================*/

using System;
using System.Drawing;
using System.Windows.Forms;
using System.Text;
using System.IO;
using System.Diagnostics;
using centrafuse.Plugins;

namespace tpms
{	
	public class sensorpos : CFDialog
	{
		public sensorpos()
		{
			this.CF_pluginPauseAudioFlag = false;
			this.CF_pluginName = "SENSORPOS";
			this.CF_pluginIsGUI = true;	
		}
			
		private void SENSORPOS_Loaded(object sender, EventArgs e)
		{
			//===========================================================
			// Event that fires when the aplication is loaded.
			//===========================================================

            if (tpms.useDebug) CFTools.writeModuleLog("START", tpms.errLog);
			
			try
			{
			
			}
            catch (Exception errmsg) { CFTools.writeModuleLog("SENSORPOS_Loaded: " + errmsg.Message, errmsg.StackTrace, tpms.errLog); }
            if (tpms.useDebug) CFTools.writeModuleLog("END", tpms.errLog);
		}

		//==========================================================================================
		#region CFPlugin methods
		//==========================================================================================
		
		public override void CF_pluginShow()
		{
			//  This is called by the system when a button with this plugin action has been clicked.
			this.Visible = true;
		}

		public override void CF_pluginClose()
		{	
			this.Dispose();		// Disposes the plugin.
		}
		
		public override void CF_pluginUpdateLanguageSkin(string language, string skin) 
		{
			// This is called by the system when the language has changed.
			this.CF_localskinsetup();
		}
				
		public override void CF_pluginPause()
		{
			// This is called by the system when it pauses all audio.

		}

		public override void CF_pluginResume()
		{
			// This is called by the system when it resumes all audio.
		}

		public override void CF_pluginCommand(string command, string param1, string param2)
		{
			// Used for plugin to plugin communication.  Parameters can be passed into CF_Main_systemCommands with CF_Actions.PLUGIN, plugin name, plugin command, and a command parameter.
		}

		public override string CF_pluginData(string command, string param)
		{
			// Used for retrieving information from plugins. You can run CF_getPluginData with a plugin name, command, and parameter to retrieve information from other plugins running on the system.
			string retvalue = "";
			return retvalue;
		}
		

		public override void CF_pluginInit()
		{	
			string sx = string .Empty;
			try
			{
				//----------------------------------------------------------------
				// configure skin layout
				//----------------------------------------------------------------
				this.CF_loadConfig(tpms.pluginCfg);

				#region LANGUAGE SYNCHRONISATION
				try
				{
					sx = tpms.pluginFolder + "/languages/" + this.CF_getConfigSetting(CF_ConfigSettings.Language).Trim().ToUpper() + ".xml";
					if (!File.Exists(sx)) sx = tpms.pluginFolder + "/languages/english.xml";
					this.CF_loadLang(sx);
					tpms.languagexml.Load(sx);
				}
				catch (Exception errmsg) {CFTools.writeModuleLog("Error in language file found", errmsg.Message,tpms.errLog);}
            
				#endregion language synchronisation

				this.CF_localskinsetup();

			}
			catch(Exception errmsg) { CFTools.writeModuleLog(errmsg.Message, errmsg.StackTrace,tpms.errLog); }

			finally
			{
				// create event to detect application is loaded
                this.CF_Event_applicationLoaded += new EventHandler(SENSORPOS_Loaded);
			}
		}

		///  This is called to setup the skin.  This will usually be called  in CF_pluginInit.  It will also called by the system when
		///  the resolution has been changed.
		public override void CF_localskinsetup()
		{
            if (tpms.useDebug) CFTools.writeModuleLog("END", tpms.errLog);
		
			this.CF_clearControls();
            
			//  Initializes the skin with the specified skin file path, if it exists.  Otherwise load the default skin.
			this.CF_initSkin(tpms.pluginFolder + "/skins/" + this.currentSkin + "/skin.xml");
			//  Loads the skin images.
            
			this.CF_loadImages(	tpms.pluginFolder + "/skins/" + this.currentSkin + "/sensorpos_off.png",
								tpms.pluginFolder + "/skins/" + this.currentSkin + "/sensorpos_down.png");
            
			// Define the reduced size of this plugin
			this.Bounds = this.CF_createRect(
				Int32.Parse(pluginSkinReader.readPluginField("/SKIN/SENSORPOS/X")),
                Int32.Parse(pluginSkinReader.readPluginField("/SKIN/SENSORPOS/Y")),
                Int32.Parse(pluginSkinReader.readPluginField("/SKIN/SENSORPOS/WIDTH")),
                Int32.Parse(pluginSkinReader.readPluginField("/SKIN/SENSORPOS/HEIGHT")));
            
			//  Creates plugin buttons
            this.CF_createButton("CLOSE", "", new MouseEventHandler(Click_Action));
            this.CF_updateButtonText("CLOSE", tpms.languagexml.SelectSingleNode("APPLANG/TPMS/BUTTONS/CLOSE").InnerText);
            
            this.CF_createButton("OK", "", new MouseEventHandler(Click_Action));
            this.CF_updateButtonText("OK", tpms.languagexml.SelectSingleNode("APPLANG/SENSORPOS/BUTTONS/OK").InnerText);
            
            //  Creates plugin labels.
			this.CF_createLabel("TITLE");
            this.CF_updateText("TITLE", this.pluginLang.readPluginField("APPLANG/SENSORPOS/LABELS/TITLE"));
            for (int i = 1; i <= 5; i++)
            {
                // create labels for tire sensor assigment
                this.CF_createLabel("TIRE" + Convert.ToString(i));
                this.CF_updateText("TIRE" + Convert.ToString(i), this.pluginLang.readPluginField("APPLANG/SENSORPOS/LABELS/TIRE" + Convert.ToString(i)));
                
                this.CF_createLabel("T" + Convert.ToString(i) + "VALUE");
                
                // now create buttons
                this.CF_createButton("T" + Convert.ToString(i) + "UP", "", new MouseEventHandler(Click_Action));
                this.CF_createButton("T" + Convert.ToString(i) + "DOWN", "", new MouseEventHandler(Click_Action));
                
                // get values out of config.xml
                try
                {
                    this.CF_updateText("T" + Convert.ToString(i) + "VALUE", this.pluginConfig.readPluginField("/APPCONFIG/SETUP/SENSORLOCATION/TIRE" + Convert.ToString(i)));
                
                    if (this.CF_getText("T" + Convert.ToString(i) + "VALUE") == "")
                        this.CF_updateText("T" + Convert.ToString(i) + "VALUE", "1");
                }
                catch { this.CF_updateText("T" + Convert.ToString(i) + "VALUE", Convert.ToString(i)); }
            }
			if (tpms.useDebug) CFTools.writeModuleLog("END", tpms.errLog);
		}
		#endregion
		
		private void Msg_Close(object sender, MouseEventArgs e)
		{
			this.DialogResult = DialogResult.OK;
		}

        private string UpCount(ref byte cnt)
        {
            if ((cnt < 1) || (cnt > 5))
                return "1";
            ++cnt;
            if (cnt > 5)
                return "5";
            else
                return Convert.ToString(cnt);
        }

        private string DownCount(ref byte cnt)
        {
            if ((cnt < 1) || (cnt > 5))
                return "1";
            --cnt;
            if (cnt < 1)
                return "1";
            else
                return Convert.ToString(cnt);
        }

        private void Click_Action(object sender, MouseEventArgs e)
        {
            string btnStr = string.Empty;
            string btnNr = string.Empty;
            byte CurrValue;
            int TotSum = 0;

            if (tpms.useDebug) CFTools.writeModuleLog("START", tpms.errLog);

            CFControls.skinButton tmp = new centrafuse.Plugins.CFControls.skinButton();
            tmp = (CFControls.skinButton)sender;
            btnStr = tmp.Name.ToString().Trim().ToUpper();

            switch (btnStr)
            {
                #region OK - Save all modified settings
               
                case "OK":
                    // Save and reload config settings
                    for (int i = 1; i <= 5; i++)
                    {
                        tpms.configxml.SelectSingleNode("/APPCONFIG/SETUP/SENSORLOCATION/TIRE" + Convert.ToString(i)).InnerText = this.CF_getText("T" + Convert.ToString(i) + "VALUE");
                        TotSum = TotSum + Convert.ToInt16(this.CF_getText("T" + Convert.ToString(i) + "VALUE"));
                    }

                    // check that all tires has different numbers
                    if (TotSum != 15)
                    {
                        this.CF_systemDisplayDialog(CF_Dialogs.OkBox, this.pluginLang.readPluginField("/APPLANG/SENSORPOS/TXTINVALIDNUMBERS"));
                    }
                    else
                    {
                        tpms.configxml.Save(tpms.pluginCfg);
                        this.CF_loadConfig(tpms.pluginCfg);
                        // Launches system YesNo dialog to verify the user wants to overwrite their current settings.  If yes then the local XML document is saved.
                        this.DialogResult = DialogResult.OK;
                    }
                    
                    break;
                #endregion

                #region CANCEL - rollback a changed settings
                case "CLOSE":
                    this.DialogResult = DialogResult.Cancel;
                    tpms.configxml.Load(tpms.pluginCfg);
                    break;
                #endregion

                #region UP counting the tire number
                case "T1UP":
                case "T2UP":
                case "T3UP":
                case "T4UP":
                case "T5UP":
                    // fist get the value,which should be saved to the config.xml file
                    try
                    {
                        CurrValue = Convert.ToByte(this.CF_getText("T" + btnStr[1] + "VALUE"));
                        CFTools.writeModuleLog("CurrValue=" + Convert.ToString(CurrValue), tpms.errLog);
                    }
                    catch { CurrValue = 1; }
                    // the convert this value to a normalized string 
                    this.CF_updateText("T" + btnStr[1] + "VALUE", UpCount(ref CurrValue));
                    break;                   

                #endregion

                #region DOWN counting the tire number
                case "T1DOWN":
                case "T2DOWN":
                case "T3DOWN":
                case "T4DOWN":
                case "T5DOWN":
                    try
                    {
                        CurrValue = Convert.ToByte(this.CF_getText("T" + btnStr[1] + "VALUE"));
                    }
                    catch { CurrValue = 1; } 
                    this.CF_updateText("T" + btnStr[1] + "VALUE", DownCount(ref CurrValue));
                    break;
                #endregion
            }
            if (tpms.useDebug) CFTools.writeModuleLog("END", tpms.errLog);
        }	
	}
}

	

	

	
