/* ==================================================================================================
 * TPMS plugin																						*
 * File: message.cs																					*
 * Author: Dipl.-Ing. Wolfgang Otto																	*
 * eMail: Wolfgang@exner-otto.de																	*
 * Date: November 2007																				*
 *																									*
 * This file is subject to the condition of GNU GENERAL PUBLIC LICENSE								*
 * Therefore you are free to use this software for your own requirements and use the				*
 * source code for any modification.																*
 * The only wish is to inform the author about any kind of development.								*
 * =================================================================================================*/

using System;
using System.Drawing;
using System.Windows.Forms;
using System.Text;
using System.IO;
using System.Diagnostics;
using centrafuse.Plugins;

namespace tpms
{	
	public class message : CFDialog
	{
		public string MESSAGETEXT;
		protected System.Windows.Forms.Timer hideTimer;
		
		public message()
		{
			this.CF_pluginPauseAudioFlag = false;
			this.CF_pluginName = "MESSAGE";
			this.CF_pluginIsGUI = true;	
		}
	
		protected void hideTimer_Tick(object sender, EventArgs e)
		{
			//===========================================================
			// close this information dialog after a predefined time
			//===========================================================
			hideTimer.Stop();
			this.DialogResult = DialogResult.OK;
		}

		private void MESSAGE_Loaded(object sender, EventArgs e)
		{
			//===========================================================
			// Event that fires when the aplication is loaded.
			//===========================================================

            if (tpms.useDebug) CFTools.writeModuleLog("START", tpms.errLog);
			
			try
			{
				//----------------------------------------------------------------------------------
				// checkTimer: Timer for detecting a pressure or temperature fault by on of the tires
				//----------------------------------------------------------------------------------
				hideTimer = new System.Windows.Forms.Timer();
				try { hideTimer.Interval = Convert.ToInt16(this.pluginConfig.readPluginField("/APPCONFIG/HIDETIMEMS")); } 
				catch {hideTimer.Interval = 5000;} // standard value is 5 seconds
				hideTimer.Tick += new EventHandler(hideTimer_Tick);

				hideTimer.Enabled= true;
			}
			catch(Exception errmsg) { CFTools.writeModuleLog("MESSAGE_Loaded: " + errmsg.Message, errmsg.StackTrace,tpms.errLog); }
            if (tpms.useDebug) CFTools.writeModuleLog("END", tpms.errLog);
		}

		//==========================================================================================
		#region CFPlugin methods
		//==========================================================================================
		
		public override void CF_pluginShow()
		{
			//  This is called by the system when a button with this plugin action has been clicked.
			this.Visible = true;
		}

		public override void CF_pluginClose()
		{	
			this.Dispose();		// Disposes the plugin.
		}
		
		public override void CF_pluginUpdateLanguageSkin(string language, string skin) 
		{
			// This is called by the system when the language has changed.
			this.CF_localskinsetup();
		}
		
		
		public override void CF_pluginPause()
		{
			// This is called by the system when it pauses all audio.

		}

		public override void CF_pluginResume()
		{
			// This is called by the system when it resumes all audio.
		}

		public override void CF_pluginCommand(string command, string param1, string param2)
		{
			// Used for plugin to plugin communication.  Parameters can be passed into CF_Main_systemCommands with CF_Actions.PLUGIN, plugin name, plugin command, and a command parameter.
		}

		public override string CF_pluginData(string command, string param)
		{
			// Used for retrieving information from plugins. You can run CF_getPluginData with a plugin name, command, and parameter to retrieve information from other plugins running on the system.
			string retvalue = "";
			return retvalue;
		}
		

		public override void CF_pluginInit()
		{	
			string sx = string .Empty;
			try
			{
				//----------------------------------------------------------------
				// configure skin layout
				//----------------------------------------------------------------
				this.CF_loadConfig(tpms.pluginCfg);

				#region LANGUAGE SYNCHRONISATION
				try
				{
					sx = tpms.pluginFolder + "/languages/" + this.CF_getConfigSetting(CF_ConfigSettings.Language).Trim().ToUpper() + ".xml";
					if (!File.Exists(sx)) sx = tpms.pluginFolder + "/languages/english.xml";
					this.CF_loadLang(sx);
					tpms.languagexml.Load(sx);
				}
				catch (Exception errmsg) {CFTools.writeModuleLog("Error in language file found", errmsg.Message,tpms.errLog);}
            
				#endregion language synchronisation

				this.CF_localskinsetup();

			}
			catch(Exception errmsg) { CFTools.writeModuleLog(errmsg.Message, errmsg.StackTrace,tpms.errLog); }

			finally
			{
				// create event to detect application is loaded
				this.CF_Event_applicationLoaded += new EventHandler(MESSAGE_Loaded);
			}
		}

		///  This is called to setup the skin.  This will usually be called  in CF_pluginInit.  It will also called by the system when
		///  the resolution has been changed.
		public override void CF_localskinsetup()
		{
                if (tpms.useDebug) CFTools.writeModuleLog("END", tpms.errLog);
			
				this.CF_clearControls();
				//  Initializes the skin with the specified skin file path, if it exists.  Otherwise load the default skin.
				this.CF_initSkin(tpms.pluginFolder + "/skins/" + this.currentSkin + "/skin.xml");
				//  Loads the skin images.
				this.CF_loadImages(	tpms.pluginFolder + "/skins/" + this.currentSkin + "/message_off.png",
									tpms.pluginFolder + "/skins/" + this.currentSkin + "/message_down.png");
				// Define the reduced size of this plugin
				this.Bounds = this.CF_createRect(
					Int32.Parse(pluginSkinReader.readPluginField("/SKIN/MESSAGE/X")),
					Int32.Parse(pluginSkinReader.readPluginField("/SKIN/MESSAGE/Y")),
					Int32.Parse(pluginSkinReader.readPluginField("/SKIN/MESSAGE/WIDTH")),
					Int32.Parse(pluginSkinReader.readPluginField("/SKIN/MESSAGE/HEIGHT")));

				//  Creates plugin buttons
				this.CF_createButton("CLOSE", "", new MouseEventHandler(Msg_Close));
				//  Creates plugin labels.
				this.CF_createLabel("MESSAGE");
				this.CF_createLabel("TITLE");
			
				this.CF_updateButtonText("CLOSE", tpms.languagexml.SelectSingleNode("APPLANG/TPMS/BUTTONS/CLOSE").InnerText);
				this.CF_updateText("TITLE", this.pluginLang.readPluginField("APPLANG/TITLE"));							
				this.CF_updateText("MESSAGE", MESSAGETEXT);
			    if (tpms.useDebug) CFTools.writeModuleLog("END", tpms.errLog);
		}

		#endregion
		
		private void Msg_Close(object sender, MouseEventArgs e)
		{
			this.DialogResult = DialogResult.OK;
		}	
		
	}
}

	

	

	
