#define F_CPU 1000000UL  

#include <avr/io.h>
#include <util/delay.h>
#include <avr/pgmspace.h>

#define LCD PORTC
#define E_LCD 3
#define RW_LCD 4
#define RS_LCD 5
#define CS1 6
#define CS2 7
#define RES_LCD 2
#define LCD_PORT PORTB
#define LCD_DDR DDRB
#define LCD_CONTROL_PORT DDRC
#define LCD_PIN PINB

#define SetBit(x,y) (x|=(1<<y))
#define ClrBit(x,y) (x&=~(1<<y))


const char menu_sym[1024]PROGMEM={
     0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0xFD,0xFD,0x19,0x31,0x61,
     0x61,0x31,0x19,0xFD,0xFD,0x01,0x01,0xFD,
     0xFD,0xCD,0xCD,0x0D,0x0D,0x01,0x01,0xFD,
     0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x80,0x80,0x80,0x8F,0x8F,0x80,0x80,0x80,
     0x80,0x80,0x80,0x8F,0x8F,0x80,0x80,0x8F,
     0x8F,0x8C,0x0C,0x0C,0x0C,0x00,0x00,0x0F,
     0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0xFF,0x00,0x00,0x00,0xE0,0xE0,0xE0,
     0xE0,0x20,0xF0,0xF8,0xFC,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
     0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xF0,
     0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,
     0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0xFF,0x00,0x00,0x00,0x1F,0x1F,0x1F,
     0x1F,0x10,0x3F,0x7F,0xFF,0xFF,0xFF,0x00,
     0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
     0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x7F,
     0x3F,0x1F,0x0F,0x07,0x02,0x00,0x00,0x00,
     0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,
     0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x03,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1D,0x1D,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1F,0x1F,0x1F,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1C,0x1F,0x1F,0x1F,0x00,0x00,0x00,
     0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0xFE,0x01,0x71,0xF9,0xFD,0xFD,0xFD,
     0xF9,0xF1,0xC1,0xC1,0xF1,0xF9,0xFD,0xFD,
     0xFD,0xF9,0x71,0x01,0xFE,0xFE,0xFE,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x81,0x81,0x81,0xE1,0x21,0x21,0x21,0x21,
     0x21,0x21,0xFE,0xFE,0xFE,0x00,0x00,0x00,
     0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0xFF,0x00,0x00,0x00,0x39,0x7F,0xFF,
     0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,
     0x39,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
     0x00,0xFE,0x02,0xEA,0xAA,0x6A,0xAA,0x6A,
     0xAB,0xE2,0x1A,0x9A,0x1A,0xE2,0xE2,0xE2,
     0xFE,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,
     0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x87,0xB8,0xB8,0xB8,0xB8,0xB8,0xB9,
     0xB9,0xBB,0xBB,0xBB,0xBB,0xB9,0xB9,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xBF,0xBF,0xBF,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x87,
     0xB8,0xBB,0xBA,0xBA,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBA,0xBA,
     0xBB,0xB8,0xBF,0xBF,0xBF,0x80,0x80,0x80,
     0xFD,0xC1,0xC1,0xC1,0xC1,0xFD,0xFD,0x01,
     0x01,0xFD,0xFD,0xC1,0xC1,0xF9,0xFD,0x0D,
     0x0D,0xFD,0xF9,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0xFF,0xFF,0xFF,0xFB,0x77,
     0xAF,0xDF,0xAF,0x77,0xFB,0xFF,0xFF,0xFF,
     0x0F,0x00,0x00,0x00,0x00,0x0F,0x8F,0x80,
     0x80,0x8F,0x8F,0x80,0x80,0x87,0x8F,0x8C,
     0x8C,0x8F,0x87,0x80,0x80,0x80,0x80,0x80,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x8F,0x8F,0x8F,0x0E,0x0F,
     0x0F,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0xFF,
     0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,
     0x80,0xE0,0xF0,0xF8,0xF8,0x1C,0x1C,0x1C,
     0x1C,0xF8,0xF8,0xF0,0xE0,0x80,0x00,0x00,
     0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0xFF,0x00,0x00,0xFE,0x12,
     0x12,0x02,0x02,0xF0,0x10,0xF0,0x10,0xE0,
     0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
     0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
     0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,
     0x07,0x1F,0x3F,0x7F,0x7F,0xE0,0xE0,0xE0,
     0xE0,0x7F,0x7F,0x3F,0x1F,0x07,0x00,0x00,
     0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0xFF,0x00,0x08,0xFC,0x00,
     0xFC,0x84,0xFC,0x00,0x08,0xFC,0x00,0x80,
     0x00,0xFC,0x94,0xFC,0x00,0x00,0xFF,0xFF,
     0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
     0x00,0x00,0x00,0x00,0x00,0x03,0x1C,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1F,0x1F,0x1F,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x03,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1F,0x1F,
     0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
     0x00,0x00,0x00,0x00,0x00,0xFE,0x01,0x01,
     0x09,0x31,0xC1,0x01,0x01,0x01,0xC1,0x31,
     0x11,0x11,0x11,0x11,0xF1,0x01,0x01,0x01,
     0xFE,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0xFE,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0xE1,0xF1,
     0x11,0x01,0x01,0x81,0x01,0x01,0x01,0xFE,
     0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,0xFF,
     0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,
     0x00,0x00,0x00,0x33,0x2C,0x23,0x20,0x20,
     0x20,0x30,0x0C,0x03,0x00,0x00,0x00,0x00,
     0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,
     0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x07,0x03,
     0x03,0x03,0x03,0x01,0x00,0x00,0x00,0xFF,
     0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,
     0x80,0x80,0x80,0x80,0x80,0x87,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xBF,0xBF,0xBF,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x87,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xBF,
     0xBF,0xBF,0x80,0x80,0x80,0x80,0x80,0xFF
};



void lcd_cmd(unsigned char data)
    {   
    LCD_DDR=0xFF;
	ClrBit(LCD,RS_LCD);
	ClrBit(LCD,RW_LCD);
    //delay_us(30);
    LCD_PORT=data;
	SetBit(LCD,E_LCD);
    //delay_us(30);
    ClrBit(LCD,E_LCD);
    }

void lcd_on()
    {
	SetBit(LCD,CS1);  
    ClrBit(LCD,CS2);
    lcd_cmd(0b00111111);
	SetBit(LCD,CS2);  
    ClrBit(LCD,CS1);
    lcd_cmd(0b00111111);
    }
    
     
void lcd_data(unsigned char data)
    {
	SetBit(LCD,RS_LCD);
	ClrBit(LCD,RW_LCD);
    LCD_DDR=0xFF;
    LCD_PORT=data;
	SetBit(LCD,E_LCD);
    //delay_us(30);
    ClrBit(LCD,E_LCD);
    
    }
void lcd_gotox(unsigned char x)
    {

    
        if (x<=127)
            {
            if (x<64)
                {
                SetBit(LCD,CS1);  
    			ClrBit(LCD,CS2);
                }
            else
                {
                SetBit(LCD,CS2);  
    			ClrBit(LCD,CS1);
                x=x-64;
                }
            
            lcd_cmd(0b01000000|x);
            }
    }


void lcd_gotoy(unsigned char y)
    {
    if (y<=7)
        {
        SetBit(LCD,CS1);  
    	ClrBit(LCD,CS2);
        lcd_cmd(0b10111000|y);  
        SetBit(LCD,CS2);  
    	ClrBit(LCD,CS1);
        lcd_cmd(0b10111000|y);   
        }
    }
    

void lcd_gotoxy(unsigned char x,unsigned char y)
    {
    if ((x<=127)&(y<=7))
        {
        lcd_gotox(x);
        lcd_cmd(0b10111000|y); 
        }
    }

void lcd_clr()
    {
    
    unsigned char x,y;
    
    for(y=0;y<8;y++)
        {
        lcd_gotoy(y);
        for (x=0;x<128;x++)
            {
            lcd_gotox(x); 
            lcd_data(0x00);
            }
        }
    }     

    


void lcd_init()
    {
    LCD_PORT=0x00;
    LCD_CONTROL_PORT=0xFF; 
    LCD_PORT=0x00;
    ClrBit(LCD,RES_LCD);
    _delay_ms(10);
    SetBit(LCD,RES_LCD);
    lcd_clr();
    lcd_on();
    }


void lcd_put_menu(int addres)
    {
    unsigned char i,j;

    for (i=0;i<8;i++)
        {
        lcd_gotoxy(0,i);
            for (j=0;j<64;j++)
                lcd_data(pgm_read_byte(addres++));
        }    

	for (i=0;i<8;i++)
        {
		lcd_gotoxy(64,i);
            for (j=0;j<64;j++)
                lcd_data(pgm_read_byte(addres++));
		}
    }


void main()
	{
	lcd_init();
	lcd_put_menu(&menu_sym[0]);
	while(1);
	}
