Imports System.Runtime.InteropServices

Public Class RS232
    Inherits MarshalByRefObject

    <DllImport("kernel32.dll")> Private Shared Function CreateFile( _
           <MarshalAs(UnmanagedType.LPStr)> ByVal lpFileName As String, _
           ByVal dwDesiredAccess As Integer, ByVal dwShareMode As Integer, _
           ByVal lpSecurityAttributes As Integer, _
           ByVal dwCreationDisposition As Integer, _
           ByVal dwFlagsAndAttributes As Integer, _
           ByVal hTemplateFile As Integer) As Integer
    End Function

    <DllImport("kernel32.dll")> Private Shared Function GetCommState( _
        ByVal hCommDev As Integer, ByRef lpDCB As DCB) As Integer
    End Function

    <DllImport("kernel32.dll")> Private Shared Function ReadFile( _
    ByVal hFile As Integer, ByVal Buffer As Byte(), _
    ByVal nNumberOfBytesToRead As Integer, _
    ByRef lpNumberOfBytesRead As Integer, _
    ByRef lpOverlapped As OVERLAPPED) As Integer
    End Function

    <DllImport("kernel32.dll")> Private Shared Function SetCommState( _
    ByVal hCommDev As Integer, ByRef lpDCB As DCB) As Integer
    End Function

    <DllImport("kernel32.dll")> Private Shared Function WriteFile( _
    ByVal hFile As Integer, ByVal Buffer As Byte(), _
    ByVal nNumberOfBytesToWrite As Integer, _
    ByRef lpNumberOfBytesWritten As Integer, _
    ByRef lpOverlapped As OVERLAPPED) As Integer
    End Function

    <DllImport("kernel32.dll")> Private Shared Function CloseHandle( _
            ByVal hObject As Integer) As Integer
    End Function

    <DllImport("kernel32.dll")> Private Shared Function GetLastError() As Integer
    End Function

    <DllImport("kernel32.dll")> Private Shared Function BuildCommDCB( _
        ByVal lpDef As String, ByRef lpDCB As DCB) As Integer
    End Function

    <StructLayout(LayoutKind.Sequential)> Structure DCB
        Public DCBlength As Integer
        Public BaudRate As Integer
        Public fBitFields As Integer 'See Comments Win32API.Txt
        Public wReserved As Integer
        Public XonLim As Integer
        Public XoffLim As Integer
        Public ByteSize As Byte
        Public Parity As Byte
        Public StopBits As Byte
        Public XonChar As Byte
        Public XoffChar As Byte
        Public ErrorChar As Byte
        Public EofChar As Byte
        Public EvtChar As Byte
        Public wReserved1 As Integer 'Reserved - Do Not Use
    End Structure


    <StructLayout(LayoutKind.Sequential)> Structure OVERLAPPED
        Public ternal As Integer
        Public ternalHigh As Integer
        Public offset As Integer
        Public OffsetHigh As Integer
        Public hEvent As Integer
    End Structure

    Const OPEN_EXISTING = 3
    Const GENERIC_READ = &H80000000
    Const GENERIC_WRITE = &H40000000
    Const PARITYSTRING = "NOE"

    Private hPort As Integer
    Private dcbPort As DCB
    Private m_opened As Boolean
    Private m_port As String
    Private m_speed As Integer
    Private m_parity As enumParity
    Private m_stop As enumStopBits
    Private m_databits As Integer

    Public Sub New()
        'Set all default values
        m_opened = False
        m_port = "COM1"
        m_speed = 9600
        m_parity = enumParity.None
        m_stop = enumStopBits.One
        m_databits = 8
    End Sub

    'This function opens a comport in your system for communication
    Public Sub Open(ByVal portname As String, ByVal Spd As Integer, ByVal Pty As enumParity, ByVal Dtb As Integer, ByVal Stp As enumStopBits)
        Dim m_CommDCB As String
        Dim m_Baud As String
        Dim m_Parity As String
        Dim m_Data As String
        Dim m_Stop As Byte

        'Try to create a filehandle to the comport we want to use
        hPort = CreateFile(portname, GENERIC_READ + GENERIC_WRITE, 0, 0, OPEN_EXISTING, 0, 0)

        'Look if the handle is valid (mus be higher than zero!)
        If hPort < 1 Then
            Throw New Exception("Can't open the comport! (Errorcode :" & GetLastError().ToString() & ")")
        End If

        'Setup the DCB (comport settings)
        m_Baud = Spd.ToString()
        m_Parity = PARITYSTRING.Substring(Pty, 1)
        m_Data = Dtb.ToString()
        m_Stop = Stp

        m_CommDCB = String.Format("baud={0} parity={1} data={2} stop={3}", m_Baud, m_Parity, m_Data, m_Stop)

        BuildCommDCB(m_CommDCB, dcbPort)

        'If we can't put the settings in place, we probably can't use the comport
        'for our task.
        If SetCommState(hPort, dcbPort) = 0 Then
            Throw New Exception("kan de compoort niet openen(" & GetLastError().ToString() & ")")
        End If

        'If all's fine we set the opened parameter to true
        m_opened = True
    End Sub

    'This function is pratically the same as the other open
    Public Sub Open()
        Open(m_port, m_speed, m_parity, m_databits, m_stop)
    End Sub

    'This function closes the comport
    'by releasing it's filehandle
    Public Sub Close()
        CloseHandle(hPort)
        hPort = -1
        m_opened = False
    End Sub

    Public Sub Write(ByVal data As Byte)
        Dim dt As Byte()
        Dim written As Integer

        dt = Array.CreateInstance(GetType(Byte), 1)
        dt(0) = data 'We have a multi-byte buffer, which you can ofcourse enable...

        'Check if our comport is open
        If Opened = True Then
            WriteFile(hPort, dt, 1, written, Nothing)
        Else
            Throw New Exception("Comport not opened")
        End If

        dt = Nothing
    End Sub

    Public Function Read() As Byte
        Dim rd As Integer
        Dim ovl As New OVERLAPPED
        Dim dt As Byte()

        dt = Array.CreateInstance(GetType(Byte), 1) 'Initialize the buffer

        'Check if the comport is opened
        If Opened = True Then
            ReadFile(hPort, dt, 1, rd, ovl)
        Else
            Throw New Exception("Comport not opened")
        End If

        Return dt(0)
    End Function

    Public Enum enumStopBits As Byte
        One = 1
        One5 = 1.5
        Two = 2
    End Enum

    Public Enum enumParity As Integer
        None = 0
        Odd = 1
        Even = 2
    End Enum

    Public Property Port() As String
        Get
            Return m_port
        End Get
        Set(ByVal Value As String)
            m_port = Value
        End Set
    End Property

    Public Property Speed() As Integer
        Get
            Return m_speed
        End Get
        Set(ByVal Value As Integer)
            m_speed = Value
        End Set
    End Property

    Public Property Parity() As enumParity
        Get
            Return m_parity
        End Get
        Set(ByVal Value As enumParity)
            m_parity = Value
        End Set
    End Property

    Public Property StopBits() As enumStopBits
        Get
            Return m_stop
        End Get
        Set(ByVal Value As enumStopBits)
            m_stop = Value
        End Set
    End Property

    Public Property DataBits() As Integer
        Get
            Return m_databits
        End Get
        Set(ByVal Value As Integer)
            m_databits = Value
        End Set
    End Property

    Public ReadOnly Property Opened() As Boolean
        Get
            Return m_opened
        End Get
    End Property
End Class
