Option Strict Off
Option Explicit On
Imports System.Runtime.InteropServices
Imports System
Namespace Radio


    Module mMixer
        ' mixer API prototypes
        Private Declare Function mixerGetNumDevs Lib "winmm.dll" () As Integer
        'UPGRADE_WARNING: Structure MIXERCAPS may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="C429C3A5-5D47-4CD9-8F51-74A1616405DC"'
        Private Declare Function mixerGetDevCaps Lib "winmm.dll" Alias "mixerGetDevCapsA" (ByVal uMxId As Integer, ByRef pmxcaps As MIXERCAPS, ByVal cbmxcaps As Integer) As Integer
        Private Declare Function mixerOpen Lib "winmm.dll" (ByRef phmx As Integer, ByVal uMxId As Integer, ByVal dwCallback As Integer, ByVal dwInstance As Integer, ByVal fdwOpen As Integer) As Integer
        Private Declare Function mixerClose Lib "winmm.dll" (ByVal hmx As Integer) As Integer
        'UPGRADE_WARNING: Structure MIXERLINE may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="C429C3A5-5D47-4CD9-8F51-74A1616405DC"'
        Private Declare Ansi Function mixerGetLineInfoA Lib "winmm.dll" (ByVal hmxobj As Integer, ByRef pmxl As MIXERLINE, ByVal fdwInfo As Integer) As Integer
        Private Declare Function mixerGetLineControls Lib "winmm.dll" Alias "mixerGetLineControlsA" (ByVal hmxobj As Integer, ByRef pmxlc As MIXERLINECONTROLS, ByVal fdwControls As Integer) As Integer
        'UPGRADE_WARNING: Structure MIXERCONTROLDETAILS may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="C429C3A5-5D47-4CD9-8F51-74A1616405DC"'
        Private Declare Function mixerGetControlDetails Lib "winmm.dll" Alias "mixerGetControlDetailsA" (ByVal hmxobj As Integer, ByRef pmxcd As MIXERCONTROLDETAILS, ByVal fdwDetails As Integer) As Integer
        'UPGRADE_WARNING: Structure MIXERCONTROLDETAILS may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="C429C3A5-5D47-4CD9-8F51-74A1616405DC"'
        Private Declare Function mixerSetControlDetails Lib "winmm.dll" (ByVal hmxobj As Integer, ByRef pmxcd As MIXERCONTROLDETAILS, ByVal fdwDetails As Integer) As Integer

        ' misc API prototypes
        'UPGRADE_ISSUE: Declaring a parameter 'As Any' is not supported. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="FAE78A8D-8978-4FD4-8208-5B7324A8F795"'
        Private Declare Sub CopyStructFromPtr Lib "kernel32" Alias "RtlMoveMemory" (ByRef struct As Object, ByVal ptr As Integer, ByVal cb As Integer)
        'UPGRADE_ISSUE: Declaring a parameter 'As Any' is not supported. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="FAE78A8D-8978-4FD4-8208-5B7324A8F795"'
        Private Declare Sub CopyPtrFromStruct Lib "kernel32" Alias "RtlMoveMemory" (ByVal ptr As Integer, ByRef struct As Object, ByVal cb As Integer)
        Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Integer, ByVal dwBytes As Integer) As Integer
        Private Declare Function GlobalLock Lib "kernel32" (ByVal hMem As Integer) As Integer
        Private Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Integer) As Integer

        <StructLayout(LayoutKind.Sequential)> _
        Private Structure MIXERCONTROLDETAILS_UNSIGNED
            <FieldOffset(0)> Public dwValue As Integer        '  value of the control
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
           Private Structure MIXERLINE
            <FieldOffset(0)> Public cbStruct As Integer                '  size of MIXERLINE structure
            <FieldOffset(4)> Public dwDestination As Integer          '  zero based destination index
            <FieldOffset(8)> Public dwSource As Integer               '  zero based source index (if source)
            <FieldOffset(12)> Public dwLineID As Integer               '  unique line id for mixer device
            <FieldOffset(16)> Public fdwLine As Integer                '  state/information about line
            <FieldOffset(20)> Public dwUser As Integer                 '  driver specific information
            <FieldOffset(24)> Public dwComponentType As Integer        '  component type line connects to
            <FieldOffset(28)> Public cChannels As Integer              '  number of channels line supports
            <FieldOffset(32)> Public cConnections As Integer           '  number of connections (possible)
            <FieldOffset(36)> Public cControls As Integer              '  number of controls at this line
            <FieldOffset(40), MarshalAsAttribute(UnmanagedType.ByValTStr, SizeConst:=MIXER_SHORT_NAME_CHARS)> Public szShortName As String  ' * MIXER_SHORT_NAME_CHARS
            <FieldOffset(56), MarshalAsAttribute(UnmanagedType.ByValTStr, SizeConst:=MIXER_LONG_NAME_CHARS)> Public szName As String ' * MIXER_LONG_NAME_CHARS
            <FieldOffset(120)> Public dwType As Integer
            <FieldOffset(124)> Public dwDeviceID As Integer
            <FieldOffset(128)> Public wMid As Integer
            <FieldOffset(132)> Public wPid As Integer
            <FieldOffset(136)> Public vDriverVersion As Integer
            <FieldOffset(168), MarshalAsAttribute(UnmanagedType.ByValTStr, SizeConst:=MAXPNAMELEN)> Public szPname As String ' * MAXPNAMELEN
        End Structure
        Public Structure MIXERCONTROL
            <FieldOffset(0)> Public cbStruct As Integer           '  size in Byte of MIXERCONTROL
            <FieldOffset(4)> Public dwControlID As Integer        '  unique control id for mixer device
            <FieldOffset(8)> Public dwControlType As Integer      '  MIXERCONTROL_CONTROLTYPE_xxx
            <FieldOffset(12)> Public fdwControl As Integer         '  MIXERCONTROL_CONTROLF_xxx
            <FieldOffset(16)> Public cMultipleItems As Integer     '  if MIXERCONTROL_CONTROLF_MULTIPLE set
            <FieldOffset(20), MarshalAsAttribute(UnmanagedType.ByValTStr, SizeConst:=MIXER_SHORT_NAME_CHARS)> Public szShortName As String ' * MIXER_SHORT_NAME_CHARS  ' short name of control
            <FieldOffset(36), MarshalAsAttribute(UnmanagedType.ByValTStr, SizeConst:=MIXER_LONG_NAME_CHARS)> Public szName As String '  * MIXER_LONG_NAME_CHARS ' Integer name of control
            <FieldOffset(100)> Public lMinimum As Integer           '  Minimum value
            <FieldOffset(104)> Public lMaximum As Integer           '  Maximum value
            <FieldOffset(108), MarshalAs(UnmanagedType.ByValArray, SizeConst:=11, ArraySubType:=UnmanagedType.AsAny)> Public reserved() As Integer      '  reserved structure space
        End Structure
        Private Structure MIXERLINECONTROLS
            Dim cbStruct As Integer '  size in Byte of MIXERLINECONTROLS
            Dim dwLineID As Integer '  line id (from MIXERLINE.dwLineID)
            '  MIXER_GETLINECONTROLSF_ONEBYID or
            Dim dwControl As Integer '  MIXER_GETLINECONTROLSF_ONEBYPrivate Type
            Dim cControls As Integer '  count of controls pmxctrl points to
            Dim cbmxctrl As Integer '  size in Byte of _one_ MIXERCONTROL
            Dim pamxctrl As IntPtr 'Integer '  pointer to first MIXERCONTROL array
        End Structure
        Private Structure MIXERCONTROLDETAILS
            Dim cbStruct As Integer ' size in Byte of MIXERCONTROLDETAILS
            Dim dwControlID As Integer ' control id to get/set details on
            Dim cChannels As Integer ' number of channels in paDetails array
            Dim item As Integer ' hwndOwner or cMultipleItems
            Dim cbDetails As Integer ' size of _one_ details_XX struct
            Dim paDetails As IntPtr ' pointer to array of details_XX structs
        End Structure

        <StructLayout(LayoutKind.Sequential)> Public Structure MIXERCAPS
            <FieldOffset(0)> Public wMid As Short
            <FieldOffset(2)> Public wPid As Short
            <FieldOffset(4)> Public vDriverVersion As Integer
            <FieldOffset(8), MarshalAsAttribute(UnmanagedType.ByValTStr, SizeConst:=32)> Public szPname As String
            <FieldOffset(40)> Public fdwSupport As Integer
            <FieldOffset(44)> Public cDestinations As Integer
        End Structure

        Public Enum VOL_CONTROL '  
            SPEAKER = 0
            LINEIN = 1
            MICROPHONE = 2
            SYNTHESIZER = 3
            COMPACTDISC = 4
            WAVEOUT = 5
            TELEPHONE = 6
            UNDEFINED = 7
        End Enum
        Public Enum MUTE_CONTROL
            SPEAKER_MUTE = 8
            LINEIN_MUTE = 9
            MICROPHONE_MUTE = 10
            SYNTHESIZER_MUTE = 11
            COMPACTDISC_MUTE = 12
            WAVEOUT_MUTE = 13
            TELEPHONE_MUTE = 14
            UNDEFINED_MUTE = 15
        End Enum

        Private Const MIXER_SETCONTROLDETAILSF_VALUE As Integer = &H0
        Private Const MIXER_GETCONTROLDETAILSF_VALUE As Integer = &H0
        Private Const MIXERLINE_COMPONENTTYPE_DST_SPEAKERS As Integer = &H4S
        Private Const MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED As Integer = &H1000
        Private Const MIXERLINE_COMPONENTTYPE_SRC_LINE As Integer = &H1002
        Private Const MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE As Integer = &H1003
        Private Const MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER As Integer = &H1004
        Private Const MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC As Integer = &H1005
        Private Const MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE As Integer = &H1006
        Private Const MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT As Integer = &H1008

        Private Const MIXER_GETLINEINFOF_COMPONENTTYPE As Integer = &H3

        Private Const MIXERCONTROL_CONTROLTYPE_VOLUME As Integer = &H50030001
        Private Const MIXERCONTROL_CONTROLTYPE_MUTE As Integer = &H20010002

        Private Const MIXER_GETLINECONTROLSF_ONEBYTYPE As Integer = &H2

        Private Const MMSYSERR_NOERROR As Integer = 0

        Private Const MAXPNAMELEN As Integer = 32
        Private Const MIXER_LONG_NAME_CHARS As Integer = 64
        Private Const MIXER_SHORT_NAME_CHARS As Integer = 16

        'UPGRADE_WARNING: Array uMixerControls may need to have individual elements initialized. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="B97B714D-9338-48AC-B03F-345B617E2B02"'
        Public uMixerControls(15) As MIXERCONTROL '    
        Private hMixerHandle As Integer '  

        Public Function OpenMixer(ByVal MixerNumber As Integer) As Boolean
            If MixerNumber < 0 Or MixerNumber > mixerGetNumDevs - 1 Then Exit Function
            MixerNumber = MixerNumber
            If Not mixerOpen(hMixerHandle, MixerNumber, 0, 0, 0) = MMSYSERR_NOERROR Then Exit Function

            ' 
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_DST_SPEAKERS, MIXERCONTROL_CONTROLTYPE_VOLUME, uMixerControls(VOL_CONTROL.SPEAKER))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_LINE, MIXERCONTROL_CONTROLTYPE_VOLUME, uMixerControls(VOL_CONTROL.LINEIN))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE, MIXERCONTROL_CONTROLTYPE_VOLUME, uMixerControls(VOL_CONTROL.MICROPHONE))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER, MIXERCONTROL_CONTROLTYPE_VOLUME, uMixerControls(VOL_CONTROL.SYNTHESIZER))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC, MIXERCONTROL_CONTROLTYPE_VOLUME, uMixerControls(VOL_CONTROL.COMPACTDISC))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT, MIXERCONTROL_CONTROLTYPE_VOLUME, uMixerControls(VOL_CONTROL.WAVEOUT))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE, MIXERCONTROL_CONTROLTYPE_VOLUME, uMixerControls(VOL_CONTROL.TELEPHONE))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED, MIXERCONTROL_CONTROLTYPE_VOLUME, uMixerControls(VOL_CONTROL.UNDEFINED))

            '  - mute
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_DST_SPEAKERS, MIXERCONTROL_CONTROLTYPE_MUTE, uMixerControls(MUTE_CONTROL.SPEAKER_MUTE))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_LINE, MIXERCONTROL_CONTROLTYPE_MUTE, uMixerControls(MUTE_CONTROL.LINEIN_MUTE))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE, MIXERCONTROL_CONTROLTYPE_MUTE, uMixerControls(MUTE_CONTROL.MICROPHONE_MUTE))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER, MIXERCONTROL_CONTROLTYPE_MUTE, uMixerControls(MUTE_CONTROL.SYNTHESIZER_MUTE))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC, MIXERCONTROL_CONTROLTYPE_MUTE, uMixerControls(MUTE_CONTROL.COMPACTDISC_MUTE))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT, MIXERCONTROL_CONTROLTYPE_MUTE, uMixerControls(MUTE_CONTROL.WAVEOUT_MUTE))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE, MIXERCONTROL_CONTROLTYPE_MUTE, uMixerControls(MUTE_CONTROL.TELEPHONE_MUTE))
            Call GetMixerControl(hMixerHandle, MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED, MIXERCONTROL_CONTROLTYPE_MUTE, uMixerControls(MUTE_CONTROL.UNDEFINED_MUTE))

            OpenMixer = Not (hMixerHandle = 0)
        End Function

        Public Function CloseMixer() As Boolean
            CloseMixer = (mixerClose(hMixerHandle) = MMSYSERR_NOERROR)
            hMixerHandle = 0
        End Function

        Public ReadOnly Property IsMixerOpened() As Boolean
            Get
                IsMixerOpened = Not (hMixerHandle = 0)
            End Get
        End Property

        '    

        Public ReadOnly Property MixerVolName(ByVal Control As VOL_CONTROL) As String
            Get
                If hMixerHandle = &H0S Then Exit Property

                MixerVolName = uMixerControls(Control).szName
                MixerVolName = MixerVolName
            End Get
        End Property

        Public ReadOnly Property MixerMuteName(ByVal Control As MUTE_CONTROL) As String
            Get
                MixerMuteName = MixerVolName(Control)
            End Get
        End Property

        '   


        Public Property Volume(ByVal Control As VOL_CONTROL) As Integer
            Get
                Volume = GetControlValue(hMixerHandle, uMixerControls(Control))
            End Get
            Set(ByVal Value As Integer)
                Call SetControlValue(hMixerHandle, uMixerControls(Control), Value)
            End Set
        End Property
        '___________________________________________________________________________


        Public Property Mute(ByVal Control As MUTE_CONTROL) As Boolean
            Get
                Mute = CBool(GetControlValue(hMixerHandle, uMixerControls(Control)))
            End Get
            Set(ByVal Value As Boolean)
                Call SetControlValue(hMixerHandle, uMixerControls(Control), System.Math.Abs(CInt(Value)))
            End Set
        End Property

        '     

        Public Function EnumSndDevices(ByRef strDevices() As String) As Short '   
            Dim i As Short
            Dim xCaps As MIXERCAPS
            EnumSndDevices = mixerGetNumDevs()
            EnumSndDevices = EnumSndDevices - &H1S
            If Not EnumSndDevices = &HFFFFS Then ReDim strDevices(EnumSndDevices)

            For i = 0 To EnumSndDevices
                Call mixerGetDevCaps(i, xCaps, 52)
                strDevices(i) = xCaps.szPname
            Next
        End Function

        '   ... 


        Private Function GetMixerControl(ByVal hmixer As Integer, ByVal componentType As Integer, ByVal ctrlType As Integer, ByRef mxc As MIXERCONTROL) As Boolean
            Dim mxlc As New MIXERLINECONTROLS
            Dim mxl As New MIXERLINE
            Dim pmxcd As New MIXERCONTROLDETAILS
            Dim rc As Integer

            Dim hMem As Integer

            mxl.cbStruct = Marshal.SizeOf(mxl)
            mxl.dwComponentType = componentType

            rc = mixerGetLineInfoA(hmixer, mxl, MIXER_GETLINEINFOF_COMPONENTTYPE)


            If MMSYSERR_NOERROR = rc Then
                Dim sizeofMIXERCONTROL As Integer = 152
                Dim ctrl As Integer = Marshal.SizeOf(GetType(MIXERCONTROL))
                mxlc.pamxctrl = Marshal.AllocCoTaskMem(sizeofMIXERCONTROL)
                mxlc.cbStruct = Marshal.SizeOf(mxlc)
                mxlc.dwLineID = mxl.dwLineID
                mxlc.dwControl = ctrlType
                mxlc.cControls = 1
                mxlc.cbmxctrl = sizeofMIXERCONTROL

                mxc.cbStruct = sizeofMIXERCONTROL


                rc = mixerGetLineControls(hmixer, mxlc, MIXER_GETLINECONTROLSF_ONEBYTYPE)

                If MMSYSERR_NOERROR = rc Then
                    GetMixerControl = True

                    mxc = CType(Marshal.PtrToStructure(mxlc.pamxctrl, GetType(MIXERCONTROL)), MIXERCONTROL)
                Else
                    GetMixerControl = False
                End If
            End If

            Call GlobalFree(hMem)
        End Function


        Private Function SetControlValue(ByVal hmixer As Integer, ByVal mxc As MIXERCONTROL, ByVal volume As Integer) As Boolean
            ' This function sets the value for a volume control. 
            ' Returns True if successful 
            Dim retValue As Boolean
            Dim rc As Integer
            Dim mxcd As New MIXERCONTROLDETAILS
            Dim vol As New MIXERCONTROLDETAILS_UNSIGNED

            mxcd.item = 0
            mxcd.dwControlID = mxc.dwControlID
            mxcd.cbStruct = Marshal.SizeOf(mxcd)
            mxcd.cbDetails = Marshal.SizeOf(vol)

            ' Allocate a buffer for the control value buffer 
            mxcd.cChannels = 1
            vol.dwValue = volume / 100 * uMixerControls(0).lMaximum

            ' Copy the data into the control value buffer 
            mxcd.paDetails = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(MIXERCONTROLDETAILS_UNSIGNED)))
            Marshal.StructureToPtr(vol, mxcd.paDetails, False)

            ' Set the control value 
            rc = mixerSetControlDetails(hmixer, mxcd, MIXER_SETCONTROLDETAILSF_VALUE)

            If MMSYSERR_NOERROR = rc Then
                retValue = True
            Else
                retValue = False
            End If
            Return retValue
        End Function 'SetVolumeControl 

        Private Function GetControlValue(ByVal hMixer As Integer, ByRef mxc As MIXERCONTROL) As Integer
            Dim mxcd As MIXERCONTROLDETAILS
            Dim hMem As Integer
            Dim du As New MIXERCONTROLDETAILS_UNSIGNED
            If hMixerHandle = &H0S Then Exit Function

            mxcd.item = mxc.cMultipleItems
            mxcd.dwControlID = mxc.dwControlID
            mxcd.cbStruct = Marshal.SizeOf(mxcd)
            mxcd.cbDetails = &H4S

            hMem = GlobalAlloc(&H40S, &H4S)
            mxcd.paDetails = GlobalLock(hMem)
            mxcd.cChannels = 1

            Call mixerGetControlDetails(hMixer, mxcd, &H0S)
            du = Marshal.PtrToStructure(mxcd.paDetails, GetType(MIXERCONTROLDETAILS_UNSIGNED))

            GetControlValue = System.Math.Abs((du.dwValue * 100) / (mxc.lMaximum - mxc.lMinimum))

            Call GlobalFree(hMem)
        End Function



    End Module
End Namespace